/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler;

import fr.insalyon.citi.golo.compiler.ir.AssignmentStatement;
import fr.insalyon.citi.golo.compiler.ir.BinaryOperation;
import fr.insalyon.citi.golo.compiler.ir.Block;
import fr.insalyon.citi.golo.compiler.ir.ClosureReference;
import fr.insalyon.citi.golo.compiler.ir.CollectionLiteral;
import fr.insalyon.citi.golo.compiler.ir.ConditionalBranching;
import fr.insalyon.citi.golo.compiler.ir.ConstantStatement;
import fr.insalyon.citi.golo.compiler.ir.ExpressionStatement;
import fr.insalyon.citi.golo.compiler.ir.FunctionInvocation;
import fr.insalyon.citi.golo.compiler.ir.GoloFunction;
import fr.insalyon.citi.golo.compiler.ir.GoloIrVisitor;
import fr.insalyon.citi.golo.compiler.ir.GoloModule;
import fr.insalyon.citi.golo.compiler.ir.GoloStatement;
import fr.insalyon.citi.golo.compiler.ir.LoopBreakFlowStatement;
import fr.insalyon.citi.golo.compiler.ir.LoopStatement;
import fr.insalyon.citi.golo.compiler.ir.MethodInvocation;
import fr.insalyon.citi.golo.compiler.ir.ReferenceLookup;
import fr.insalyon.citi.golo.compiler.ir.ReferenceTable;
import fr.insalyon.citi.golo.compiler.ir.ReturnStatement;
import fr.insalyon.citi.golo.compiler.ir.ThrowStatement;
import fr.insalyon.citi.golo.compiler.ir.TryCatchFinally;
import fr.insalyon.citi.golo.compiler.ir.UnaryOperation;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ClosureCaptureGoloIrVisitor
implements GoloIrVisitor {
    private final Deque<Context> stack = new LinkedList<Context>();

    ClosureCaptureGoloIrVisitor() {
    }

    private Context context() {
        return this.stack.peek();
    }

    private void newContext() {
        this.stack.push(new Context());
    }

    private void dropContext() {
        this.stack.pop();
    }

    private void dropBlockTable() {
        if (!this.stack.isEmpty()) {
            this.context().referenceTableStack.pop();
        }
    }

    private void pushBlockTable(Block block) {
        if (!this.stack.isEmpty()) {
            if (!this.context().referenceTableStack.isEmpty()) {
                block.getReferenceTable().relink(this.context().referenceTableStack.peek());
            }
            this.context().referenceTableStack.push(block.getReferenceTable());
        }
    }

    private void locallyDeclared(String name) {
        if (!this.stack.isEmpty()) {
            this.context().localReferences.add(name);
        }
    }

    private void locallyAssigned(String name) {
        if (!this.stack.isEmpty()) {
            this.context().accessedReferences.add(name);
        }
    }

    private void accessed(String name) {
        if (!this.stack.isEmpty()) {
            this.context().accessedReferences.add(name);
        }
    }

    private void definedInBlock(Set<String> references, Block block) {
        if (!this.stack.isEmpty()) {
            for (String ref : references) {
                this.context().definingBlock.put(ref, block);
            }
            this.context().allReferences.addAll(references);
        }
    }

    private void declaredParameters(List<String> references) {
        this.context().parameterReferences.addAll(references);
    }

    @Override
    public void visitModule(GoloModule module) {
        for (GoloFunction function : module.getFunctions()) {
            function.accept(this);
        }
        for (String augmentation : module.getAugmentations().keySet()) {
            Set<GoloFunction> functions = module.getAugmentations().get(augmentation);
            for (GoloFunction function : functions) {
                function.accept(this);
            }
        }
    }

    @Override
    public void visitFunction(GoloFunction function) {
        if (function.isSynthetic()) {
            this.newContext();
            this.declaredParameters(function.getParameterNames());
            function.getBlock().internReferenceTable();
            function.getBlock().accept(this);
            this.makeArguments(function, this.context().shouldBeArguments());
            this.dropUnused(this.context().shouldBeRemoved());
            this.dropContext();
        } else {
            function.getBlock().accept(this);
        }
    }

    private void dropUnused(Set<String> refs) {
        Context context = this.context();
        for (String ref : refs) {
            if (context.parameterReferences.contains(ref)) continue;
            context.definingBlock.get(ref).getReferenceTable().remove(ref);
        }
    }

    private void makeArguments(GoloFunction function, Set<String> refs) {
        HashSet<String> existing = new HashSet<String>(function.getParameterNames());
        for (String ref : refs) {
            if (existing.contains(ref) || ref.equals(function.getSyntheticSelfName())) continue;
            function.addSyntheticParameter(ref);
        }
    }

    @Override
    public void visitBlock(Block block) {
        this.pushBlockTable(block);
        this.definedInBlock(block.getReferenceTable().ownedSymbols(), block);
        for (GoloStatement statement : block.getStatements()) {
            statement.accept(this);
        }
        this.dropBlockTable();
    }

    @Override
    public void visitConstantStatement(ConstantStatement constantStatement) {
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) {
        returnStatement.getExpressionStatement().accept(this);
    }

    @Override
    public void visitFunctionInvocation(FunctionInvocation functionInvocation) {
        if (this.context() != null) {
            Context context = this.context();
            String name = functionInvocation.getName();
            if (context.allReferences.contains(name)) {
                this.accessed(name);
                if (context.referenceTableStack.peek().get(name).isModuleState()) {
                    functionInvocation.setOnModuleState(true);
                } else {
                    functionInvocation.setOnReference(true);
                }
            }
        }
        for (ExpressionStatement statement : functionInvocation.getArguments()) {
            statement.accept(this);
        }
        for (FunctionInvocation invocation : functionInvocation.getAnonymousFunctionInvocations()) {
            invocation.accept(this);
        }
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        ClosureReference closure;
        GoloFunction target;
        String name = assignmentStatement.getLocalReference().getName();
        if (!this.stack.isEmpty()) {
            assignmentStatement.setLocalReference(this.context().referenceTableStack.peek().get(name));
        }
        this.locallyAssigned(name);
        if (assignmentStatement.isDeclaring()) {
            this.locallyDeclared(name);
        }
        assignmentStatement.getExpressionStatement().accept(this);
        if (assignmentStatement.getExpressionStatement() instanceof ClosureReference && (target = (closure = (ClosureReference)assignmentStatement.getExpressionStatement()).getTarget()).getSyntheticParameterNames().contains(name)) {
            target.removeSyntheticParameter(name);
            target.setSyntheticSelfName(name);
        }
    }

    @Override
    public void visitReferenceLookup(ReferenceLookup referenceLookup) {
        this.accessed(referenceLookup.getName());
    }

    @Override
    public void visitConditionalBranching(ConditionalBranching conditionalBranching) {
        conditionalBranching.getCondition().accept(this);
        conditionalBranching.getTrueBlock().accept(this);
        if (conditionalBranching.hasFalseBlock()) {
            conditionalBranching.getFalseBlock().accept(this);
        } else if (conditionalBranching.hasElseConditionalBranching()) {
            conditionalBranching.getElseConditionalBranching().accept(this);
        }
    }

    @Override
    public void visitBinaryOperation(BinaryOperation binaryOperation) {
        binaryOperation.getLeftExpression().accept(this);
        binaryOperation.getRightExpression().accept(this);
    }

    @Override
    public void visitUnaryOperation(UnaryOperation unaryOperation) {
        unaryOperation.getExpressionStatement().accept(this);
    }

    @Override
    public void visitLoopStatement(LoopStatement loopStatement) {
        if (loopStatement.hasInitStatement()) {
            loopStatement.getInitStatement().accept(this);
        }
        loopStatement.getConditionStatement().accept(this);
        loopStatement.getBlock().accept(this);
        if (loopStatement.hasPostStatement()) {
            loopStatement.getPostStatement().accept(this);
        }
    }

    @Override
    public void visitMethodInvocation(MethodInvocation methodInvocation) {
        for (ExpressionStatement statement : methodInvocation.getArguments()) {
            statement.accept(this);
        }
        for (FunctionInvocation invocation : methodInvocation.getAnonymousFunctionInvocations()) {
            invocation.accept(this);
        }
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) {
        throwStatement.getExpressionStatement().accept(this);
    }

    @Override
    public void visitTryCatchFinally(TryCatchFinally tryCatchFinally) {
        tryCatchFinally.getTryBlock().accept(this);
        if (tryCatchFinally.hasCatchBlock()) {
            this.locallyAssigned(tryCatchFinally.getExceptionId());
            this.locallyDeclared(tryCatchFinally.getExceptionId());
            tryCatchFinally.getCatchBlock().accept(this);
        }
        if (tryCatchFinally.hasFinallyBlock()) {
            tryCatchFinally.getFinallyBlock().accept(this);
        }
    }

    @Override
    public void visitClosureReference(ClosureReference closureReference) {
        Context context;
        closureReference.getTarget().accept(this);
        if (closureReference.getTarget().isSynthetic() && (context = this.context()) != null) {
            for (String refName : closureReference.getTarget().getParameterNames()) {
                ReferenceTable referenceTable = context.referenceTableStack.peek();
                if (!referenceTable.hasReferenceFor(refName)) continue;
                this.accessed(refName);
            }
        }
    }

    @Override
    public void visitLoopBreakFlowStatement(LoopBreakFlowStatement loopBreakFlowStatement) {
    }

    @Override
    public void visitCollectionLiteral(CollectionLiteral collectionLiteral) {
        for (ExpressionStatement statement : collectionLiteral.getExpressions()) {
            statement.accept(this);
        }
    }

    static class Context {
        final Set<String> parameterReferences = new HashSet<String>();
        final Set<String> allReferences = new HashSet<String>();
        final Set<String> localReferences = new HashSet<String>();
        final Set<String> accessedReferences = new HashSet<String>();
        final Map<String, Block> definingBlock = new HashMap<String, Block>();
        final Deque<ReferenceTable> referenceTableStack = new LinkedList<ReferenceTable>();

        Context() {
        }

        Set<String> shouldBeArguments() {
            HashSet<String> result = new HashSet<String>();
            for (String ref : this.accessedReferences) {
                if (this.localReferences.contains(ref)) continue;
                result.add(ref);
            }
            return result;
        }

        Set<String> shouldBeRemoved() {
            HashSet<String> result = new HashSet<String>(this.allReferences);
            for (String ref : this.accessedReferences) {
                result.remove(ref);
            }
            return result;
        }
    }
}

