/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class TypeMatching {
    private static final Map<Class, Class> PRIMITIVE_MAP = new HashMap<Class, Class>(){
        {
            this.put(Byte.TYPE, Byte.class);
            this.put(Short.TYPE, Short.class);
            this.put(Character.TYPE, Character.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Float.TYPE, Float.class);
            this.put(Double.TYPE, Double.class);
            this.put(Boolean.TYPE, Boolean.class);
        }
    };

    public static boolean haveEnoughArgumentsForVarargs(Object[] arguments, Constructor constructor, Class<?>[] parameterTypes) {
        return constructor.isVarArgs() && arguments.length >= parameterTypes.length;
    }

    public static boolean haveEnoughArgumentsForVarargs(Object[] arguments, Method method, Class<?>[] parameterTypes) {
        return method.isVarArgs() && arguments.length >= parameterTypes.length - 1;
    }

    public static boolean haveSameNumberOfArguments(Object[] arguments, Class<?>[] parameterTypes) {
        return parameterTypes.length == arguments.length;
    }

    public static boolean canAssign(Class<?>[] types2, Object[] arguments, boolean varArgs) {
        if (types2.length == 0 || arguments.length == 0) {
            return true;
        }
        for (int i = 0; i < types2.length - 1; ++i) {
            if (TypeMatching.valueAndTypeMatch(types2[i], arguments[i])) continue;
            return false;
        }
        int last = types2.length - 1;
        if (last >= arguments.length) {
            return false;
        }
        if (varArgs) {
            return TypeMatching.valueAndTypeMatch(types2[last].getComponentType(), arguments[last]);
        }
        return TypeMatching.valueAndTypeMatch(types2[last], arguments[last]);
    }

    public static boolean valueAndTypeMatch(Class<?> type, Object value) {
        return TypeMatching.primitiveCompatible(type, value) || type.isInstance(value) || value == null || TypeMatching.samAssignment(type, value);
    }

    public static boolean samAssignment(Class<?> type, Object value) {
        return value instanceof MethodHandle && TypeMatching.isSAM(type);
    }

    public static boolean isSAM(Class<?> type) {
        return type.isInterface() && type.getMethods().length == 1;
    }

    public static boolean primitiveCompatible(Class<?> type, Object value) {
        if (!type.isPrimitive() || value == null) {
            return false;
        }
        return PRIMITIVE_MAP.get(type) == value.getClass();
    }
}

