/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler;

import fr.insalyon.citi.golo.compiler.GoloCompilationException;
import fr.insalyon.citi.golo.compiler.PackageAndClass;
import fr.insalyon.citi.golo.compiler.ir.AssignmentStatement;
import fr.insalyon.citi.golo.compiler.ir.BinaryOperation;
import fr.insalyon.citi.golo.compiler.ir.Block;
import fr.insalyon.citi.golo.compiler.ir.ClosureReference;
import fr.insalyon.citi.golo.compiler.ir.CollectionLiteral;
import fr.insalyon.citi.golo.compiler.ir.ConditionalBranching;
import fr.insalyon.citi.golo.compiler.ir.ConstantStatement;
import fr.insalyon.citi.golo.compiler.ir.ExpressionStatement;
import fr.insalyon.citi.golo.compiler.ir.FunctionInvocation;
import fr.insalyon.citi.golo.compiler.ir.GoloFunction;
import fr.insalyon.citi.golo.compiler.ir.GoloModule;
import fr.insalyon.citi.golo.compiler.ir.GoloStatement;
import fr.insalyon.citi.golo.compiler.ir.LocalReference;
import fr.insalyon.citi.golo.compiler.ir.LoopBreakFlowStatement;
import fr.insalyon.citi.golo.compiler.ir.LoopStatement;
import fr.insalyon.citi.golo.compiler.ir.MethodInvocation;
import fr.insalyon.citi.golo.compiler.ir.ModuleImport;
import fr.insalyon.citi.golo.compiler.ir.ReferenceLookup;
import fr.insalyon.citi.golo.compiler.ir.ReferenceTable;
import fr.insalyon.citi.golo.compiler.ir.ReturnStatement;
import fr.insalyon.citi.golo.compiler.ir.Struct;
import fr.insalyon.citi.golo.compiler.ir.ThrowStatement;
import fr.insalyon.citi.golo.compiler.ir.TryCatchFinally;
import fr.insalyon.citi.golo.compiler.ir.UnaryOperation;
import fr.insalyon.citi.golo.compiler.parser.ASTAnonymousFunctionInvocation;
import fr.insalyon.citi.golo.compiler.parser.ASTAssignment;
import fr.insalyon.citi.golo.compiler.parser.ASTAssociativeExpression;
import fr.insalyon.citi.golo.compiler.parser.ASTAugmentDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTBlock;
import fr.insalyon.citi.golo.compiler.parser.ASTBreak;
import fr.insalyon.citi.golo.compiler.parser.ASTCase;
import fr.insalyon.citi.golo.compiler.parser.ASTCollectionLiteral;
import fr.insalyon.citi.golo.compiler.parser.ASTCommutativeExpression;
import fr.insalyon.citi.golo.compiler.parser.ASTCompilationUnit;
import fr.insalyon.citi.golo.compiler.parser.ASTConditionalBranching;
import fr.insalyon.citi.golo.compiler.parser.ASTContinue;
import fr.insalyon.citi.golo.compiler.parser.ASTForEachLoop;
import fr.insalyon.citi.golo.compiler.parser.ASTForLoop;
import fr.insalyon.citi.golo.compiler.parser.ASTFunction;
import fr.insalyon.citi.golo.compiler.parser.ASTFunctionDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTFunctionInvocation;
import fr.insalyon.citi.golo.compiler.parser.ASTImportDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTLetOrVar;
import fr.insalyon.citi.golo.compiler.parser.ASTLiteral;
import fr.insalyon.citi.golo.compiler.parser.ASTMatch;
import fr.insalyon.citi.golo.compiler.parser.ASTMethodInvocation;
import fr.insalyon.citi.golo.compiler.parser.ASTModuleDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTReference;
import fr.insalyon.citi.golo.compiler.parser.ASTReturn;
import fr.insalyon.citi.golo.compiler.parser.ASTStructDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTThrow;
import fr.insalyon.citi.golo.compiler.parser.ASTToplevelDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTTryCatchFinally;
import fr.insalyon.citi.golo.compiler.parser.ASTUnaryExpression;
import fr.insalyon.citi.golo.compiler.parser.ASTWhileLoop;
import fr.insalyon.citi.golo.compiler.parser.ASTerror;
import fr.insalyon.citi.golo.compiler.parser.GoloASTNode;
import fr.insalyon.citi.golo.compiler.parser.GoloParserVisitor;
import fr.insalyon.citi.golo.compiler.parser.Node;
import fr.insalyon.citi.golo.compiler.parser.SimpleNode;
import fr.insalyon.citi.golo.runtime.OperatorType;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

class ParseTreeToGoloIrVisitor
implements GoloParserVisitor {
    private GoloCompilationException.Builder exceptionBuilder;

    ParseTreeToGoloIrVisitor() {
    }

    public void setExceptionBuilder(GoloCompilationException.Builder builder) {
        this.exceptionBuilder = builder;
    }

    public GoloCompilationException.Builder getExceptionBuilder() {
        return this.exceptionBuilder;
    }

    private GoloCompilationException.Builder getOrCreateExceptionBuilder(Context context) {
        if (this.exceptionBuilder == null) {
            this.exceptionBuilder = new GoloCompilationException.Builder(context.module.getPackageAndClass().toString());
        }
        return this.exceptionBuilder;
    }

    @Override
    public Object visit(ASTerror node, Object data) {
        return null;
    }

    public GoloModule transform(ASTCompilationUnit compilationUnit) {
        Context context = new Context();
        this.visit(compilationUnit, (Object)context);
        return context.module;
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        throw new IllegalStateException("visit(SimpleNode) shall never be invoked");
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        Context context = (Context)data;
        Object ret = node.childrenAccept(this, data);
        context.module.internStructAugmentations();
        return ret;
    }

    @Override
    public Object visit(ASTModuleDeclaration node, Object data) {
        Context context = (Context)data;
        context.module = new GoloModule(PackageAndClass.fromString(node.getName()));
        node.setIrElement(context.module);
        context.referenceTableStack.push(new ReferenceTable());
        return node.childrenAccept(this, data);
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        Context context = (Context)data;
        ModuleImport moduleImport = new ModuleImport(PackageAndClass.fromString(node.getName()));
        node.setIrElement(moduleImport);
        context.module.addImport(moduleImport);
        return node.childrenAccept(this, data);
    }

    @Override
    public Object visit(ASTToplevelDeclaration node, Object data) {
        return node.childrenAccept(this, data);
    }

    @Override
    public Object visit(ASTStructDeclaration node, Object data) {
        Context context = (Context)data;
        GoloModule module = context.module;
        PackageAndClass structClass = new PackageAndClass(module.getPackageAndClass().toString() + ".types", node.getName());
        module.addStruct(new Struct(structClass, node.getMembers()));
        GoloFunction factory = new GoloFunction(node.getName(), GoloFunction.Visibility.PUBLIC, GoloFunction.Scope.MODULE);
        Block block = new Block(context.referenceTableStack.peek().fork());
        factory.setBlock(block);
        block.addStatement(new ReturnStatement(new FunctionInvocation(structClass.toString())));
        module.addFunction(factory);
        factory = new GoloFunction(node.getName(), GoloFunction.Visibility.PUBLIC, GoloFunction.Scope.MODULE);
        factory.setParameterNames(new LinkedList<String>(node.getMembers()));
        FunctionInvocation call = new FunctionInvocation(structClass.toString());
        ReferenceTable table = context.referenceTableStack.peek().fork();
        block = new Block(table);
        for (String member : node.getMembers()) {
            call.addArgument(new ReferenceLookup(member));
            table.add(new LocalReference(LocalReference.Kind.CONSTANT, member));
        }
        factory.setBlock(block);
        block.addStatement(new ReturnStatement(call));
        module.addFunction(factory);
        factory = new GoloFunction("Immutable" + node.getName(), GoloFunction.Visibility.PUBLIC, GoloFunction.Scope.MODULE);
        factory.setParameterNames(new LinkedList<String>(node.getMembers()));
        call = new FunctionInvocation(structClass.toString() + "." + "$_immutable");
        table = context.referenceTableStack.peek().fork();
        block = new Block(table);
        for (String member : node.getMembers()) {
            call.addArgument(new ReferenceLookup(member));
            table.add(new LocalReference(LocalReference.Kind.CONSTANT, member));
        }
        factory.setBlock(block);
        block.addStatement(new ReturnStatement(call));
        module.addFunction(factory);
        return data;
    }

    @Override
    public Object visit(ASTAugmentDeclaration node, Object data) {
        Context context = (Context)data;
        context.augmentation = node.getTarget();
        return node.childrenAccept(this, data);
    }

    @Override
    public Object visit(ASTFunctionDeclaration node, Object data) {
        Context context = (Context)data;
        GoloFunction function = new GoloFunction(node.getName(), node.isLocal() ? GoloFunction.Visibility.LOCAL : GoloFunction.Visibility.PUBLIC, node.isAugmentation() ? GoloFunction.Scope.AUGMENT : GoloFunction.Scope.MODULE);
        node.setIrElement(function);
        context.objectStack.push(function);
        node.childrenAccept(this, data);
        context.objectStack.pop();
        return data;
    }

    @Override
    public Object visit(ASTContinue node, Object data) {
        Context context = (Context)data;
        LoopBreakFlowStatement statement = LoopBreakFlowStatement.newContinue();
        node.setIrElement(statement);
        context.objectStack.push(statement);
        return data;
    }

    @Override
    public Object visit(ASTBreak node, Object data) {
        Context context = (Context)data;
        LoopBreakFlowStatement statement = LoopBreakFlowStatement.newBreak();
        node.setIrElement(statement);
        context.objectStack.push(statement);
        return data;
    }

    @Override
    public Object visit(ASTFunction node, Object data) {
        GoloFunction function;
        boolean isSynthetic;
        Context context = (Context)data;
        boolean bl = isSynthetic = !(context.objectStack.peek() instanceof GoloFunction);
        if (isSynthetic) {
            function = new GoloFunction("__$$_closure_" + context.nextClosureId++, GoloFunction.Visibility.LOCAL, GoloFunction.Scope.CLOSURE);
            function.setSynthetic(true);
            context.objectStack.push(function);
        } else {
            function = (GoloFunction)context.objectStack.peek();
        }
        node.setIrElement(function);
        function.setParameterNames(node.getArguments());
        function.setVarargs(node.isVarargs());
        if (GoloFunction.Scope.AUGMENT.equals((Object)function.getScope())) {
            context.module.addAugmentation(context.augmentation, function);
        } else {
            context.module.addFunction(function);
        }
        if (node.isCompactForm()) {
            Node astChild = node.jjtGetChild(0);
            ASTReturn astReturn = new ASTReturn(0);
            astReturn.jjtAddChild(astChild, 0);
            ASTBlock astBlock = new ASTBlock(0);
            astBlock.jjtAddChild(astReturn, 0);
            astBlock.jjtAccept(this, data);
        } else {
            node.childrenAccept(this, data);
        }
        Block functionBlock = function.getBlock();
        ReferenceTable referenceTable = functionBlock.getReferenceTable();
        for (String parameter : function.getParameterNames()) {
            referenceTable.add(new LocalReference(LocalReference.Kind.CONSTANT, parameter));
        }
        this.insertMissingReturnStatement(function);
        if (isSynthetic) {
            context.objectStack.pop();
            context.objectStack.push(new ClosureReference(function));
        }
        return data;
    }

    private void insertMissingReturnStatement(GoloFunction function) {
        Block block = function.getBlock();
        if (!block.hasReturn()) {
            ReturnStatement missingReturnStatement = new ReturnStatement(new ConstantStatement(null));
            if (function.isMain()) {
                missingReturnStatement.returningVoid();
            }
            block.addStatement(missingReturnStatement);
        }
    }

    @Override
    public Object visit(ASTUnaryExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, data);
        UnaryOperation unaryOperation = new UnaryOperation(this.operationFrom(node.getOperator()), (ExpressionStatement)context.objectStack.pop());
        context.objectStack.push(unaryOperation);
        node.setIrElement(unaryOperation);
        return data;
    }

    private OperatorType operationFrom(String symbol) {
        switch (symbol) {
            case "+": {
                return OperatorType.PLUS;
            }
            case "-": {
                return OperatorType.MINUS;
            }
            case "*": {
                return OperatorType.TIMES;
            }
            case "/": {
                return OperatorType.DIVIDE;
            }
            case "%": {
                return OperatorType.MODULO;
            }
            case "<": {
                return OperatorType.LESS;
            }
            case "<=": {
                return OperatorType.LESSOREQUALS;
            }
            case "==": {
                return OperatorType.EQUALS;
            }
            case "!=": {
                return OperatorType.NOTEQUALS;
            }
            case ">": {
                return OperatorType.MORE;
            }
            case ">=": {
                return OperatorType.MOREOREQUALS;
            }
            case "and": {
                return OperatorType.AND;
            }
            case "or": {
                return OperatorType.OR;
            }
            case "not": {
                return OperatorType.NOT;
            }
            case "is": {
                return OperatorType.IS;
            }
            case "isnt": {
                return OperatorType.ISNT;
            }
            case "oftype": {
                return OperatorType.OFTYPE;
            }
            case ":": {
                return OperatorType.METHOD_CALL;
            }
            case "orIfNull": {
                return OperatorType.ORIFNULL;
            }
            case "?:": {
                return OperatorType.ELVIS_METHOD_CALL;
            }
        }
        throw new IllegalArgumentException(symbol);
    }

    private void makeBinaryOperation(GoloASTNode node, List<String> symbols, Context context) {
        MethodInvocation invocation;
        LinkedList<ExpressionStatement> expressions = new LinkedList<ExpressionStatement>();
        LinkedList<OperatorType> operators = new LinkedList<OperatorType>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, context);
            expressions.push((ExpressionStatement)context.objectStack.pop());
        }
        for (String operatorSymbol : symbols) {
            operators.push(this.operationFrom(operatorSymbol));
        }
        ExpressionStatement right = (ExpressionStatement)expressions.pop();
        ExpressionStatement left = (ExpressionStatement)expressions.pop();
        OperatorType operator = (OperatorType)((Object)operators.pop());
        BinaryOperation current = new BinaryOperation(operator, left, right);
        if (operator == OperatorType.ELVIS_METHOD_CALL) {
            invocation = (MethodInvocation)right;
            invocation.setNullSafeGuarded(true);
        }
        while (!expressions.isEmpty()) {
            left = (ExpressionStatement)expressions.pop();
            operator = (OperatorType)((Object)operators.pop());
            if (operator == OperatorType.ELVIS_METHOD_CALL) {
                invocation = (MethodInvocation)current.getLeftExpression();
                invocation.setNullSafeGuarded(true);
            }
            current = new BinaryOperation(operator, left, current);
        }
        node.setIrElement(current);
        context.objectStack.push(current);
    }

    @Override
    public Object visit(ASTCommutativeExpression node, Object data) {
        Context context = (Context)data;
        if (node.jjtGetNumChildren() > 1) {
            this.makeBinaryOperation(node, node.getOperators(), context);
        } else {
            node.childrenAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTAssociativeExpression node, Object data) {
        Context context = (Context)data;
        if (node.jjtGetNumChildren() > 1) {
            this.makeBinaryOperation(node, node.getOperators(), context);
        } else {
            node.childrenAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTLiteral node, Object data) {
        Context context = (Context)data;
        ConstantStatement constantStatement = new ConstantStatement(node.getLiteralValue());
        context.objectStack.push(constantStatement);
        node.setIrElement(constantStatement);
        return data;
    }

    @Override
    public Object visit(ASTCollectionLiteral node, Object data) {
        Context context = (Context)data;
        LinkedList<ExpressionStatement> expressions = new LinkedList<ExpressionStatement>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            GoloASTNode expressionNode = (GoloASTNode)node.jjtGetChild(i);
            expressionNode.jjtAccept(this, data);
            expressions.add((ExpressionStatement)context.objectStack.pop());
        }
        CollectionLiteral.Type type = CollectionLiteral.Type.valueOf(node.getType());
        context.objectStack.push(new CollectionLiteral(type, expressions));
        return data;
    }

    @Override
    public Object visit(ASTReference node, Object data) {
        Context context = (Context)data;
        ReferenceLookup referenceLookup = new ReferenceLookup(node.getName());
        context.objectStack.push(referenceLookup);
        node.setIrElement(referenceLookup);
        return data;
    }

    @Override
    public Object visit(ASTLetOrVar node, Object data) {
        Context context = (Context)data;
        LocalReference localReference = new LocalReference(this.referenceKindOf(node), node.getName());
        context.referenceTableStack.peek().add(localReference);
        node.childrenAccept(this, data);
        AssignmentStatement assignmentStatement = new AssignmentStatement(localReference, (ExpressionStatement)context.objectStack.pop());
        assignmentStatement.setDeclaring(true);
        node.setIrElement(assignmentStatement);
        if (node.isModuleState()) {
            context.module.addLocalState(localReference);
            context.module.addModuleStateInitializer(context.referenceTableStack.peek(), assignmentStatement);
        } else {
            context.objectStack.push(assignmentStatement);
        }
        return data;
    }

    private LocalReference.Kind referenceKindOf(ASTLetOrVar node) {
        if (node.isModuleState()) {
            return node.getType() == ASTLetOrVar.Type.LET ? LocalReference.Kind.MODULE_CONSTANT : LocalReference.Kind.MODULE_VARIABLE;
        }
        return node.getType() == ASTLetOrVar.Type.LET ? LocalReference.Kind.CONSTANT : LocalReference.Kind.VARIABLE;
    }

    @Override
    public Object visit(ASTAssignment node, Object data) {
        Context context = (Context)data;
        LocalReference reference = context.referenceTableStack.peek().get(node.getName());
        if (reference == null) {
            this.getOrCreateExceptionBuilder(context).report(GoloCompilationException.Problem.Type.UNDECLARED_REFERENCE, node, "Assigning to either a parameter or an undeclared reference `" + node.getName() + "` at (line=" + node.getLineInSourceCode() + ", column=" + node.getColumnInSourceCode() + ")");
        }
        node.childrenAccept(this, data);
        if (reference != null) {
            AssignmentStatement assignmentStatement = new AssignmentStatement(reference, (ExpressionStatement)context.objectStack.pop());
            context.objectStack.push(assignmentStatement);
            node.setIrElement(assignmentStatement);
        }
        return data;
    }

    @Override
    public Object visit(ASTReturn node, Object data) {
        Context context = (Context)data;
        if (node.jjtGetNumChildren() > 0) {
            node.childrenAccept(this, data);
        } else {
            context.objectStack.push(new ConstantStatement(null));
        }
        ExpressionStatement statement = (ExpressionStatement)context.objectStack.pop();
        ReturnStatement returnStatement = new ReturnStatement(statement);
        context.objectStack.push(returnStatement);
        node.setIrElement(returnStatement);
        return data;
    }

    @Override
    public Object visit(ASTThrow node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, data);
        ExpressionStatement statement = (ExpressionStatement)context.objectStack.pop();
        ThrowStatement throwStatement = new ThrowStatement(statement);
        context.objectStack.push(throwStatement);
        node.setIrElement(throwStatement);
        return data;
    }

    @Override
    public Object visit(ASTBlock node, Object data) {
        Context context = (Context)data;
        ReferenceTable blockReferenceTable = context.referenceTableStack.peek().fork();
        context.referenceTableStack.push(blockReferenceTable);
        Block block = new Block(blockReferenceTable);
        node.setIrElement(block);
        if (context.objectStack.peek() instanceof GoloFunction) {
            GoloFunction function = (GoloFunction)context.objectStack.peek();
            function.setBlock(block);
            if (function.isSynthetic()) {
                context.objectStack.pop();
            }
        }
        context.objectStack.push(block);
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            GoloASTNode child = (GoloASTNode)node.jjtGetChild(i);
            child.jjtAccept(this, data);
            GoloStatement statement = (GoloStatement)context.objectStack.pop();
            block.addStatement(statement);
        }
        context.referenceTableStack.pop();
        return data;
    }

    @Override
    public Object visit(ASTFunctionInvocation node, Object data) {
        GoloASTNode argumentNode;
        Context context = (Context)data;
        FunctionInvocation functionInvocation = new FunctionInvocation(node.getName());
        int i = 0;
        int numChildren = node.jjtGetNumChildren();
        for (i = 0; i < numChildren && !((argumentNode = (GoloASTNode)node.jjtGetChild(i)) instanceof ASTAnonymousFunctionInvocation); ++i) {
            argumentNode.jjtAccept(this, data);
            functionInvocation.addArgument((ExpressionStatement)context.objectStack.pop());
        }
        context.objectStack.push(functionInvocation);
        node.setIrElement(functionInvocation);
        if (i < numChildren) {
            while (i < numChildren) {
                ASTAnonymousFunctionInvocation invocationNode = (ASTAnonymousFunctionInvocation)node.jjtGetChild(i);
                invocationNode.jjtAccept(this, data);
                FunctionInvocation invocation = (FunctionInvocation)context.objectStack.pop();
                functionInvocation.addAnonymousFunctionInvocation(invocation);
                ++i;
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTAnonymousFunctionInvocation node, Object data) {
        Context context = (Context)data;
        FunctionInvocation invocation = new FunctionInvocation();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            GoloASTNode argumentNode = (GoloASTNode)node.jjtGetChild(i);
            argumentNode.jjtAccept(this, data);
            invocation.addArgument((ExpressionStatement)context.objectStack.pop());
        }
        context.objectStack.push(invocation);
        node.setIrElement(invocation);
        return data;
    }

    @Override
    public Object visit(ASTMethodInvocation node, Object data) {
        GoloASTNode argumentNode;
        Context context = (Context)data;
        MethodInvocation methodInvocation = new MethodInvocation(node.getName());
        int i = 0;
        int numChildren = node.jjtGetNumChildren();
        for (i = 0; i < numChildren && !((argumentNode = (GoloASTNode)node.jjtGetChild(i)) instanceof ASTAnonymousFunctionInvocation); ++i) {
            argumentNode.jjtAccept(this, data);
            methodInvocation.addArgument((ExpressionStatement)context.objectStack.pop());
        }
        context.objectStack.push(methodInvocation);
        node.setIrElement(methodInvocation);
        if (i < numChildren) {
            while (i < numChildren) {
                ASTAnonymousFunctionInvocation invocationNode = (ASTAnonymousFunctionInvocation)node.jjtGetChild(i);
                invocationNode.jjtAccept(this, data);
                FunctionInvocation invocation = (FunctionInvocation)context.objectStack.pop();
                methodInvocation.addAnonymousFunctionInvocation(invocation);
                ++i;
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTConditionalBranching node, Object data) {
        Context context = (Context)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        ExpressionStatement condition = (ExpressionStatement)context.objectStack.pop();
        node.jjtGetChild(1).jjtAccept(this, data);
        Block trueBlock = (Block)context.objectStack.pop();
        Object elseObject = null;
        if (node.jjtGetNumChildren() > 2) {
            Node elseNode = node.jjtGetChild(2);
            elseNode.jjtAccept(this, data);
            elseObject = context.objectStack.pop();
        }
        ConditionalBranching conditionalBranching = elseObject == null || elseObject instanceof Block ? new ConditionalBranching(condition, trueBlock, (Block)elseObject) : new ConditionalBranching(condition, trueBlock, (ConditionalBranching)elseObject);
        context.objectStack.push(conditionalBranching);
        node.setIrElement(conditionalBranching);
        return data;
    }

    @Override
    public Object visit(ASTCase node, Object data) {
        Context context = (Context)data;
        int lastWhen = node.jjtGetNumChildren() - 1;
        LinkedList<Object> stack = new LinkedList<Object>();
        for (int i = 0; i < lastWhen; i += 2) {
            node.jjtGetChild(i).jjtAccept(this, data);
            stack.push(context.objectStack.pop());
            node.jjtGetChild(i + 1).jjtAccept(this, data);
            stack.push(context.objectStack.pop());
        }
        node.jjtGetChild(node.jjtGetNumChildren() - 1).jjtAccept(this, data);
        stack.push(context.objectStack.pop());
        Block otherwise = (Block)stack.pop();
        Block lastWhenBlock = (Block)stack.pop();
        ExpressionStatement lastWhenCondition = (ExpressionStatement)stack.pop();
        ConditionalBranching branching = new ConditionalBranching(lastWhenCondition, lastWhenBlock, otherwise);
        while (!stack.isEmpty()) {
            lastWhenBlock = (Block)stack.pop();
            lastWhenCondition = (ExpressionStatement)stack.pop();
            branching = new ConditionalBranching(lastWhenCondition, lastWhenBlock, branching);
        }
        context.objectStack.push(branching);
        node.setIrElement(branching);
        return data;
    }

    @Override
    public Object visit(ASTMatch node, Object data) {
        int i;
        ASTCase astCase = new ASTCase(0);
        String varName = "__$$_match_" + System.currentTimeMillis();
        for (i = 0; i < node.jjtGetNumChildren() - 1; ++i) {
            astCase.jjtAddChild(node.jjtGetChild(i), i);
            this.matchTreeToCase(node, astCase, ++i, varName);
        }
        this.matchTreeToCase(node, astCase, i, varName);
        ASTLetOrVar var = new ASTLetOrVar(0);
        var.setName(varName);
        var.setType(ASTLetOrVar.Type.VAR);
        ASTLiteral astLiteral = new ASTLiteral(0);
        astLiteral.setLiteralValue(null);
        var.jjtAddChild(astLiteral, 0);
        ASTReference astReference = new ASTReference(0);
        astReference.setName(varName);
        ASTBlock astBlock = new ASTBlock(0);
        astBlock.jjtAddChild(var, 0);
        astBlock.jjtAddChild(astCase, 1);
        astBlock.jjtAddChild(astReference, 2);
        astBlock.jjtAccept(this, data);
        return data;
    }

    private void matchTreeToCase(ASTMatch node, ASTCase astCase, int i, String varName) {
        ASTBlock astBlock = new ASTBlock(0);
        astCase.jjtAddChild(astBlock, i);
        ASTAssignment astAssignment = new ASTAssignment(0);
        astAssignment.setName(varName);
        astAssignment.jjtAddChild(node.jjtGetChild(i), 0);
        astBlock.jjtAddChild(astAssignment, 0);
    }

    @Override
    public Object visit(ASTWhileLoop node, Object data) {
        Context context = (Context)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        ExpressionStatement condition = (ExpressionStatement)context.objectStack.pop();
        node.jjtGetChild(1).jjtAccept(this, data);
        Block block = (Block)context.objectStack.pop();
        LoopStatement loopStatement = new LoopStatement(null, condition, block, null);
        context.objectStack.push(loopStatement);
        node.setIrElement(loopStatement);
        return data;
    }

    @Override
    public Object visit(ASTForLoop node, Object data) {
        Context context = (Context)data;
        ReferenceTable localTable = context.referenceTableStack.peek().fork();
        context.referenceTableStack.push(localTable);
        node.jjtGetChild(0).jjtAccept(this, data);
        AssignmentStatement init = (AssignmentStatement)context.objectStack.pop();
        node.jjtGetChild(1).jjtAccept(this, data);
        ExpressionStatement condition = (ExpressionStatement)context.objectStack.pop();
        node.jjtGetChild(2).jjtAccept(this, data);
        GoloStatement post = (GoloStatement)context.objectStack.pop();
        node.jjtGetChild(3).jjtAccept(this, data);
        Block block = (Block)context.objectStack.pop();
        LoopStatement loopStatement = new LoopStatement(init, condition, block, post);
        Block localBlock = new Block(localTable);
        localBlock.addStatement(loopStatement);
        context.objectStack.push(localBlock);
        context.referenceTableStack.pop();
        node.setIrElement(loopStatement);
        return data;
    }

    @Override
    public Object visit(ASTForEachLoop node, Object data) {
        Context context = (Context)data;
        ReferenceTable localTable = context.referenceTableStack.peek().fork();
        LocalReference elementReference = new LocalReference(LocalReference.Kind.VARIABLE, node.getElementIdentifier());
        localTable.add(elementReference);
        String iteratorId = "$$__iterator__$$__" + System.currentTimeMillis();
        LocalReference iteratorReference = new LocalReference(LocalReference.Kind.VARIABLE, iteratorId, true);
        localTable.add(iteratorReference);
        context.referenceTableStack.push(localTable);
        node.jjtGetChild(0).jjtAccept(this, data);
        ExpressionStatement iterableExpressionStatement = (ExpressionStatement)context.objectStack.pop();
        node.jjtGetChild(1).jjtAccept(this, data);
        Block block = (Block)context.objectStack.pop();
        AssignmentStatement init = new AssignmentStatement(iteratorReference, new BinaryOperation(OperatorType.METHOD_CALL, iterableExpressionStatement, new MethodInvocation("iterator")));
        init.setDeclaring(true);
        init.setASTNode(node);
        BinaryOperation condition = new BinaryOperation(OperatorType.METHOD_CALL, new ReferenceLookup(iteratorId), new MethodInvocation("hasNext"));
        condition.setASTNode(node);
        AssignmentStatement next = new AssignmentStatement(elementReference, new BinaryOperation(OperatorType.METHOD_CALL, new ReferenceLookup(iteratorId), new MethodInvocation("next")));
        next.setDeclaring(true);
        next.setASTNode(node);
        block.prependStatement(next);
        LoopStatement loopStatement = new LoopStatement(init, condition, block, null);
        Block localBlock = new Block(localTable);
        localBlock.addStatement(loopStatement);
        context.objectStack.push(localBlock);
        node.setIrElement(loopStatement);
        context.referenceTableStack.pop();
        return data;
    }

    @Override
    public Object visit(ASTTryCatchFinally node, Object data) {
        Context context = (Context)data;
        String exceptionId = node.getExceptionId();
        boolean hasCatchBlock = exceptionId != null;
        ReferenceTable localTable = context.referenceTableStack.peek().fork();
        context.referenceTableStack.push(localTable);
        node.jjtGetChild(0).jjtAccept(this, data);
        Block tryBlock = (Block)context.objectStack.pop();
        context.referenceTableStack.pop();
        Block catchBlock = null;
        Block finallyBlock = null;
        localTable = context.referenceTableStack.peek().fork();
        context.referenceTableStack.push(localTable);
        node.jjtGetChild(1).jjtAccept(this, data);
        if (hasCatchBlock) {
            catchBlock = (Block)context.objectStack.pop();
            catchBlock.getReferenceTable().add(new LocalReference(LocalReference.Kind.CONSTANT, exceptionId));
        } else {
            finallyBlock = (Block)context.objectStack.pop();
        }
        context.referenceTableStack.pop();
        if (hasCatchBlock && node.jjtGetNumChildren() > 2) {
            localTable = context.referenceTableStack.peek().fork();
            context.referenceTableStack.push(localTable);
            node.jjtGetChild(2).jjtAccept(this, data);
            finallyBlock = (Block)context.objectStack.pop();
            context.referenceTableStack.pop();
        }
        TryCatchFinally tryCatchFinally = new TryCatchFinally(exceptionId, tryBlock, catchBlock, finallyBlock);
        context.objectStack.push(tryCatchFinally);
        node.setIrElement(tryCatchFinally);
        return data;
    }

    private static class Context {
        GoloModule module;
        String augmentation;
        Deque<Object> objectStack = new LinkedList<Object>();
        Deque<ReferenceTable> referenceTableStack = new LinkedList<ReferenceTable>();
        int nextClosureId = 0;

        private Context() {
        }
    }
}

