/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.runtime.adapters;

import fr.insalyon.citi.golo.runtime.adapters.AdapterDefinition;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class JavaBytecodeAdapterGenerator {
    private static final Handle ADAPTER_HANDLE;

    private String jvmType(String klass) {
        return klass.replace(".", "/");
    }

    private String[] interfaceTypesArray(Set<String> interfaces) {
        String[] types2 = new String[interfaces.size()];
        int i = 0;
        for (String iface : interfaces) {
            types2[i] = this.jvmType(iface);
            ++i;
        }
        return types2;
    }

    public byte[] generate(AdapterDefinition adapterDefinition) {
        ClassWriter classWriter = new ClassWriter(3);
        TreeSet<String> interfaces = new TreeSet<String>(adapterDefinition.getInterfaces());
        interfaces.add("gololang.GoloAdapter");
        classWriter.visit(51, 4145, adapterDefinition.getName(), null, this.jvmType(adapterDefinition.getParent()), this.interfaceTypesArray(interfaces));
        this.makeDefinitionField(classWriter);
        this.makeConstructors(classWriter, adapterDefinition);
        this.makeFrontendOverrides(classWriter, adapterDefinition);
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    public Class<?> generateIntoDefinitionClassloader(AdapterDefinition adapterDefinition) {
        try {
            byte[] bytecode = this.generate(adapterDefinition);
            ClassLoader classLoader = adapterDefinition.getClassLoader();
            Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            if (!defineClass.isAccessible()) {
                defineClass.setAccessible(true);
            }
            return (Class)defineClass.invoke((Object)classLoader, adapterDefinition.getName(), bytecode, 0, bytecode.length);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void makeDefinitionField(ClassWriter classWriter) {
        classWriter.visitField(17, "_$_$adapter_$definition", "Lfr/insalyon/citi/golo/runtime/adapters/AdapterDefinition;", null, null).visitEnd();
    }

    private void makeFrontendOverrides(ClassWriter classWriter, AdapterDefinition adapterDefinition) {
        for (Method method : this.getAllVirtualMethods(adapterDefinition)) {
            int access = Modifier.isPublic(method.getModifiers()) ? 1 : 4;
            String name = method.getName();
            String descriptor = Type.getMethodDescriptor((Method)method);
            Class<?>[] exceptionTypes = method.getExceptionTypes();
            String[] exceptions = new String[exceptionTypes.length];
            for (int i = 0; i < exceptionTypes.length; ++i) {
                exceptions[i] = Type.getInternalName(exceptionTypes[i]);
            }
            MethodVisitor methodVisitor = classWriter.visitMethod(access, name, descriptor, null, exceptions);
            methodVisitor.visitCode();
            Class<?>[] parameterTypes = method.getParameterTypes();
            Type[] indyTypes = new Type[parameterTypes.length + 1];
            indyTypes[0] = Type.getType(Object.class);
            methodVisitor.visitVarInsn(25, 0);
            int argIndex = 1;
            for (int i = 0; i < parameterTypes.length; ++i) {
                argIndex = this.loadArgument(methodVisitor, parameterTypes[i], argIndex);
                indyTypes[i + 1] = Type.getType(parameterTypes[i]);
            }
            methodVisitor.visitInvokeDynamicInsn(method.getName(), Type.getMethodDescriptor((Type)Type.getReturnType((Method)method), (Type[])indyTypes), ADAPTER_HANDLE, new Object[0]);
            this.makeReturn(methodVisitor, method.getReturnType());
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
    }

    private HashSet<Method> getAllVirtualMethods(AdapterDefinition adapterDefinition) {
        try {
            HashSet<Method> methods = new HashSet<Method>();
            Class<?> parentClass = Class.forName(adapterDefinition.getParent(), true, adapterDefinition.getClassLoader());
            for (Method method : parentClass.getMethods()) {
                if (Modifier.isStatic(method.getModifiers()) || Modifier.isFinal(method.getModifiers())) continue;
                methods.add(method);
            }
            for (Method method : parentClass.getDeclaredMethods()) {
                if (Modifier.isStatic(method.getModifiers()) || Modifier.isPrivate(method.getModifiers()) || Modifier.isFinal(method.getModifiers())) continue;
                methods.add(method);
            }
            for (String iface : adapterDefinition.getInterfaces()) {
                for (Method method : Class.forName(iface, true, adapterDefinition.getClassLoader()).getMethods()) {
                    methods.add(method);
                }
            }
            return methods;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void makeConstructors(ClassWriter classWriter, AdapterDefinition adapterDefinition) {
        try {
            Class<?> parentClass = Class.forName(adapterDefinition.getParent(), true, adapterDefinition.getClassLoader());
            for (Constructor<?> constructor : parentClass.getDeclaredConstructors()) {
                if (!Modifier.isPublic(constructor.getModifiers()) && !Modifier.isProtected(constructor.getModifiers())) continue;
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                Type[] adapterParameterTypes = new Type[parameterTypes.length + 1];
                adapterParameterTypes[0] = Type.getType(AdapterDefinition.class);
                for (int i = 1; i < adapterParameterTypes.length; ++i) {
                    adapterParameterTypes[i] = Type.getType(parameterTypes[i - 1]);
                }
                String descriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])adapterParameterTypes);
                MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", descriptor, null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitFieldInsn(181, this.jvmType(adapterDefinition.getName()), "_$_$adapter_$definition", "Lfr/insalyon/citi/golo/runtime/adapters/AdapterDefinition;");
                methodVisitor.visitVarInsn(25, 0);
                int argIndex = 2;
                for (Class<?> parameterType : parameterTypes) {
                    argIndex = this.loadArgument(methodVisitor, parameterType, argIndex);
                }
                methodVisitor.visitMethodInsn(183, Type.getInternalName(parentClass), "<init>", Type.getConstructorDescriptor(constructor));
                methodVisitor.visitInsn(177);
                methodVisitor.visitMaxs(0, 0);
                methodVisitor.visitEnd();
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private int loadArgument(MethodVisitor methodVisitor, Class<?> type, int index) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                methodVisitor.visitVarInsn(21, index);
                return index + 1;
            }
            if (type == Boolean.TYPE) {
                methodVisitor.visitVarInsn(21, index);
                return index + 1;
            }
            if (type == Byte.TYPE) {
                methodVisitor.visitVarInsn(21, index);
                return index + 1;
            }
            if (type == Character.TYPE) {
                methodVisitor.visitVarInsn(21, index);
                return index + 1;
            }
            if (type == Short.TYPE) {
                methodVisitor.visitVarInsn(21, index);
                return index + 1;
            }
            if (type == Double.TYPE) {
                methodVisitor.visitVarInsn(24, index);
                return index + 2;
            }
            if (type == Float.TYPE) {
                methodVisitor.visitVarInsn(23, index);
                return index + 1;
            }
            methodVisitor.visitVarInsn(22, index);
            return index + 2;
        }
        methodVisitor.visitVarInsn(25, index);
        return index + 1;
    }

    private void makeReturn(MethodVisitor methodVisitor, Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                methodVisitor.visitInsn(172);
            } else if (type == Void.TYPE) {
                methodVisitor.visitInsn(177);
            } else if (type == Boolean.TYPE) {
                methodVisitor.visitInsn(172);
            } else if (type == Byte.TYPE) {
                methodVisitor.visitInsn(172);
            } else if (type == Character.TYPE) {
                methodVisitor.visitInsn(172);
            } else if (type == Short.TYPE) {
                methodVisitor.visitInsn(172);
            } else if (type == Double.TYPE) {
                methodVisitor.visitInsn(175);
            } else if (type == Float.TYPE) {
                methodVisitor.visitInsn(174);
            } else if (type == Long.TYPE) {
                methodVisitor.visitInsn(173);
            }
        } else {
            methodVisitor.visitInsn(176);
        }
    }

    static {
        String bootstrapOwner = "fr/insalyon/citi/golo/runtime/adapters/AdapterSupport";
        String bootstrapMethod = "bootstrap";
        String description = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;";
        ADAPTER_HANDLE = new Handle(6, bootstrapOwner, bootstrapMethod, description);
    }
}

