/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.runtime;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.util.HashSet;
import java.util.Set;

public class OperatorSupport {
    private static final MethodHandle GUARD_1;
    private static final MethodHandle FALLBACK_1;
    private static final MethodHandle GUARD_2;
    private static final MethodHandle FALLBACK_2;
    private static final Set<String> NO_GUARD_OPERATORS;

    public static boolean guard_1(Class<?> expected, Object arg) {
        Class t = arg == null ? Object.class : arg.getClass();
        return t == expected;
    }

    public static boolean guard_2(Class<?> expected1, Class<?> expected2, Object arg1, Object arg2) {
        Class t1 = arg1 == null ? Object.class : arg1.getClass();
        Class t2 = arg2 == null ? Object.class : arg2.getClass();
        return t1 == expected1 && t2 == expected2;
    }

    public static Object fallback_1(MonomorphicInlineCache inlineCache, Object[] args) throws Throwable {
        MethodHandle target;
        Class<Object> argClass = args[0] == null ? Object.class : args[0].getClass();
        try {
            target = inlineCache.callerLookup.findStatic(OperatorSupport.class, inlineCache.name, MethodType.methodType(Object.class, argClass));
        }
        catch (Throwable t1) {
            try {
                target = inlineCache.callerLookup.findStatic(OperatorSupport.class, inlineCache.name + "_fallback", MethodType.methodType(Object.class, Object.class));
            }
            catch (Throwable t2) {
                return OperatorSupport.reject(args[0], inlineCache.name);
            }
        }
        target = target.asType(MethodType.methodType(Object.class, Object.class));
        MethodHandle guard = GUARD_1.bindTo(argClass);
        MethodHandle guardedTarget = MethodHandles.guardWithTest(guard, target, inlineCache.fallback);
        inlineCache.setTarget(guardedTarget);
        return target.invokeWithArguments(args);
    }

    public static Object fallback_2(MonomorphicInlineCache inlineCache, Object[] args) throws Throwable {
        MethodHandle target;
        Class<Object> arg1Class = args[0] == null ? Object.class : args[0].getClass();
        Class<Object> arg2Class = args[1] == null ? Object.class : args[1].getClass();
        try {
            target = inlineCache.callerLookup.findStatic(OperatorSupport.class, inlineCache.name, MethodType.methodType(Object.class, arg1Class, arg2Class));
        }
        catch (Throwable t1) {
            try {
                target = inlineCache.callerLookup.findStatic(OperatorSupport.class, inlineCache.name + "_fallback", MethodType.methodType(Object.class, Object.class, Object.class));
            }
            catch (Throwable t2) {
                return OperatorSupport.reject(args[0], args[1], inlineCache.name);
            }
        }
        target = target.asType(MethodType.methodType(Object.class, Object.class, Object.class));
        MethodHandle guard = MethodHandles.insertArguments(GUARD_2, 0, arg1Class, arg2Class);
        MethodHandle guardedTarget = MethodHandles.guardWithTest(guard, target, inlineCache.fallback);
        inlineCache.setTarget(guardedTarget);
        return target.invokeWithArguments(args);
    }

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type, int arity) throws NoSuchMethodException, IllegalAccessException {
        MethodHandle fallbackHandle;
        if (NO_GUARD_OPERATORS.contains(name)) {
            MethodHandle target = caller.findStatic(OperatorSupport.class, name + "_noguard", MethodType.methodType(Object.class, Object.class, Object.class));
            return new ConstantCallSite(target);
        }
        MonomorphicInlineCache callSite = new MonomorphicInlineCache(caller, name, type);
        MethodHandle fallback = arity == 2 ? FALLBACK_2 : FALLBACK_1;
        callSite.fallback = fallbackHandle = fallback.bindTo(callSite).asCollector(Object[].class, type.parameterCount()).asType(type);
        callSite.setTarget(fallbackHandle);
        return callSite;
    }

    public static Object plus(Character a, Character b) {
        return a.charValue() + b.charValue();
    }

    public static Object minus(Character a, Character b) {
        return a.charValue() - b.charValue();
    }

    public static Object divide(Character a, Character b) {
        return a.charValue() / b.charValue();
    }

    public static Object times(Character a, Character b) {
        return a.charValue() * b.charValue();
    }

    public static Object modulo(Character a, Character b) {
        return a.charValue() % b.charValue();
    }

    public static Object plus(Integer a, Integer b) {
        return a + b;
    }

    public static Object minus(Integer a, Integer b) {
        return a - b;
    }

    public static Object divide(Integer a, Integer b) {
        return a / b;
    }

    public static Object times(Integer a, Integer b) {
        return a * b;
    }

    public static Object modulo(Integer a, Integer b) {
        return a % b;
    }

    public static Object plus(Long a, Long b) {
        return a + b;
    }

    public static Object minus(Long a, Long b) {
        return a - b;
    }

    public static Object divide(Long a, Long b) {
        return a / b;
    }

    public static Object times(Long a, Long b) {
        return a * b;
    }

    public static Object modulo(Long a, Long b) {
        return a % b;
    }

    public static Object plus(Double a, Double b) {
        return a + b;
    }

    public static Object minus(Double a, Double b) {
        return a - b;
    }

    public static Object divide(Double a, Double b) {
        return a / b;
    }

    public static Object times(Double a, Double b) {
        return a * b;
    }

    public static Object modulo(Double a, Double b) {
        return a % b;
    }

    public static Object plus(Float a, Float b) {
        return Float.valueOf(a.floatValue() + b.floatValue());
    }

    public static Object minus(Float a, Float b) {
        return Float.valueOf(a.floatValue() - b.floatValue());
    }

    public static Object divide(Float a, Float b) {
        return Float.valueOf(a.floatValue() / b.floatValue());
    }

    public static Object times(Float a, Float b) {
        return Float.valueOf(a.floatValue() * b.floatValue());
    }

    public static Object modulo(Float a, Float b) {
        return Float.valueOf(a.floatValue() % b.floatValue());
    }

    public static Object plus(Character a, Integer b) {
        return a.charValue() + b;
    }

    public static Object minus(Character a, Integer b) {
        return a.charValue() - b;
    }

    public static Object divide(Character a, Integer b) {
        return a.charValue() / b;
    }

    public static Object times(Character a, Integer b) {
        return a.charValue() * b;
    }

    public static Object modulo(Character a, Integer b) {
        return a.charValue() % b;
    }

    public static Object plus(Character a, Long b) {
        return (long)a.charValue() + b;
    }

    public static Object minus(Character a, Long b) {
        return (long)a.charValue() - b;
    }

    public static Object divide(Character a, Long b) {
        return (long)a.charValue() / b;
    }

    public static Object times(Character a, Long b) {
        return (long)a.charValue() * b;
    }

    public static Object modulo(Character a, Long b) {
        return (long)a.charValue() % b;
    }

    public static Object plus(Character a, Double b) {
        return (double)a.charValue() + b;
    }

    public static Object minus(Character a, Double b) {
        return (double)a.charValue() - b;
    }

    public static Object divide(Character a, Double b) {
        return (double)a.charValue() / b;
    }

    public static Object times(Character a, Double b) {
        return (double)a.charValue() * b;
    }

    public static Object modulo(Character a, Double b) {
        return (double)a.charValue() % b;
    }

    public static Object plus(Character a, Float b) {
        return Float.valueOf((float)a.charValue() + b.floatValue());
    }

    public static Object minus(Character a, Float b) {
        return Float.valueOf((float)a.charValue() - b.floatValue());
    }

    public static Object divide(Character a, Float b) {
        return Float.valueOf((float)a.charValue() / b.floatValue());
    }

    public static Object times(Character a, Float b) {
        return Float.valueOf((float)a.charValue() * b.floatValue());
    }

    public static Object modulo(Character a, Float b) {
        return Float.valueOf((float)a.charValue() % b.floatValue());
    }

    public static Object plus(Integer a, Long b) {
        return (long)a.intValue() + b;
    }

    public static Object minus(Integer a, Long b) {
        return (long)a.intValue() - b;
    }

    public static Object divide(Integer a, Long b) {
        return (long)a.intValue() / b;
    }

    public static Object times(Integer a, Long b) {
        return (long)a.intValue() * b;
    }

    public static Object modulo(Integer a, Long b) {
        return (long)a.intValue() % b;
    }

    public static Object plus(Integer a, Double b) {
        return (double)a.intValue() + b;
    }

    public static Object minus(Integer a, Double b) {
        return (double)a.intValue() - b;
    }

    public static Object divide(Integer a, Double b) {
        return (double)a.intValue() / b;
    }

    public static Object times(Integer a, Double b) {
        return (double)a.intValue() * b;
    }

    public static Object modulo(Integer a, Double b) {
        return (double)a.intValue() % b;
    }

    public static Object plus(Integer a, Float b) {
        return Float.valueOf((float)a.intValue() + b.floatValue());
    }

    public static Object minus(Integer a, Float b) {
        return Float.valueOf((float)a.intValue() - b.floatValue());
    }

    public static Object divide(Integer a, Float b) {
        return Float.valueOf((float)a.intValue() / b.floatValue());
    }

    public static Object times(Integer a, Float b) {
        return Float.valueOf((float)a.intValue() * b.floatValue());
    }

    public static Object modulo(Integer a, Float b) {
        return Float.valueOf((float)a.intValue() % b.floatValue());
    }

    public static Object plus(Long a, Double b) {
        return (double)a.longValue() + b;
    }

    public static Object minus(Long a, Double b) {
        return (double)a.longValue() - b;
    }

    public static Object divide(Long a, Double b) {
        return (double)a.longValue() / b;
    }

    public static Object times(Long a, Double b) {
        return (double)a.longValue() * b;
    }

    public static Object modulo(Long a, Double b) {
        return (double)a.longValue() % b;
    }

    public static Object plus(Long a, Float b) {
        return Float.valueOf((float)a.longValue() + b.floatValue());
    }

    public static Object minus(Long a, Float b) {
        return Float.valueOf((float)a.longValue() - b.floatValue());
    }

    public static Object divide(Long a, Float b) {
        return Float.valueOf((float)a.longValue() / b.floatValue());
    }

    public static Object times(Long a, Float b) {
        return Float.valueOf((float)a.longValue() * b.floatValue());
    }

    public static Object modulo(Long a, Float b) {
        return Float.valueOf((float)a.longValue() % b.floatValue());
    }

    public static Object plus(Double a, Float b) {
        return a + (double)b.floatValue();
    }

    public static Object minus(Double a, Float b) {
        return a - (double)b.floatValue();
    }

    public static Object divide(Double a, Float b) {
        return a / (double)b.floatValue();
    }

    public static Object times(Double a, Float b) {
        return a * (double)b.floatValue();
    }

    public static Object modulo(Double a, Float b) {
        return a % (double)b.floatValue();
    }

    public static Object plus(Integer a, Character b) {
        return a + b.charValue();
    }

    public static Object minus(Integer a, Character b) {
        return a - b.charValue();
    }

    public static Object divide(Integer a, Character b) {
        return a / b.charValue();
    }

    public static Object times(Integer a, Character b) {
        return a * b.charValue();
    }

    public static Object modulo(Integer a, Character b) {
        return a % b.charValue();
    }

    public static Object plus(Long a, Character b) {
        return a + (long)b.charValue();
    }

    public static Object minus(Long a, Character b) {
        return a - (long)b.charValue();
    }

    public static Object divide(Long a, Character b) {
        return a / (long)b.charValue();
    }

    public static Object times(Long a, Character b) {
        return a * (long)b.charValue();
    }

    public static Object modulo(Long a, Character b) {
        return a % (long)b.charValue();
    }

    public static Object plus(Double a, Character b) {
        return a + (double)b.charValue();
    }

    public static Object minus(Double a, Character b) {
        return a - (double)b.charValue();
    }

    public static Object divide(Double a, Character b) {
        return a / (double)b.charValue();
    }

    public static Object times(Double a, Character b) {
        return a * (double)b.charValue();
    }

    public static Object modulo(Double a, Character b) {
        return a % (double)b.charValue();
    }

    public static Object plus(Float a, Character b) {
        return Float.valueOf(a.floatValue() + (float)b.charValue());
    }

    public static Object minus(Float a, Character b) {
        return Float.valueOf(a.floatValue() - (float)b.charValue());
    }

    public static Object divide(Float a, Character b) {
        return Float.valueOf(a.floatValue() / (float)b.charValue());
    }

    public static Object times(Float a, Character b) {
        return Float.valueOf(a.floatValue() * (float)b.charValue());
    }

    public static Object modulo(Float a, Character b) {
        return Float.valueOf(a.floatValue() % (float)b.charValue());
    }

    public static Object plus(Long a, Integer b) {
        return a + (long)b.intValue();
    }

    public static Object minus(Long a, Integer b) {
        return a - (long)b.intValue();
    }

    public static Object divide(Long a, Integer b) {
        return a / (long)b.intValue();
    }

    public static Object times(Long a, Integer b) {
        return a * (long)b.intValue();
    }

    public static Object modulo(Long a, Integer b) {
        return a % (long)b.intValue();
    }

    public static Object plus(Double a, Integer b) {
        return a + (double)b.intValue();
    }

    public static Object minus(Double a, Integer b) {
        return a - (double)b.intValue();
    }

    public static Object divide(Double a, Integer b) {
        return a / (double)b.intValue();
    }

    public static Object times(Double a, Integer b) {
        return a * (double)b.intValue();
    }

    public static Object modulo(Double a, Integer b) {
        return a % (double)b.intValue();
    }

    public static Object plus(Float a, Integer b) {
        return Float.valueOf(a.floatValue() + (float)b.intValue());
    }

    public static Object minus(Float a, Integer b) {
        return Float.valueOf(a.floatValue() - (float)b.intValue());
    }

    public static Object divide(Float a, Integer b) {
        return Float.valueOf(a.floatValue() / (float)b.intValue());
    }

    public static Object times(Float a, Integer b) {
        return Float.valueOf(a.floatValue() * (float)b.intValue());
    }

    public static Object modulo(Float a, Integer b) {
        return Float.valueOf(a.floatValue() % (float)b.intValue());
    }

    public static Object plus(Double a, Long b) {
        return a + (double)b.longValue();
    }

    public static Object minus(Double a, Long b) {
        return a - (double)b.longValue();
    }

    public static Object divide(Double a, Long b) {
        return a / (double)b.longValue();
    }

    public static Object times(Double a, Long b) {
        return a * (double)b.longValue();
    }

    public static Object modulo(Double a, Long b) {
        return a % (double)b.longValue();
    }

    public static Object plus(Float a, Long b) {
        return Float.valueOf(a.floatValue() + (float)b.longValue());
    }

    public static Object minus(Float a, Long b) {
        return Float.valueOf(a.floatValue() - (float)b.longValue());
    }

    public static Object divide(Float a, Long b) {
        return Float.valueOf(a.floatValue() / (float)b.longValue());
    }

    public static Object times(Float a, Long b) {
        return Float.valueOf(a.floatValue() * (float)b.longValue());
    }

    public static Object modulo(Float a, Long b) {
        return Float.valueOf(a.floatValue() % (float)b.longValue());
    }

    public static Object plus(Float a, Double b) {
        return (double)a.floatValue() + b;
    }

    public static Object minus(Float a, Double b) {
        return (double)a.floatValue() - b;
    }

    public static Object divide(Float a, Double b) {
        return (double)a.floatValue() / b;
    }

    public static Object times(Float a, Double b) {
        return (double)a.floatValue() * b;
    }

    public static Object modulo(Float a, Double b) {
        return (double)a.floatValue() % b;
    }

    public static Object plus(String a, String b) {
        return a + b;
    }

    public static Object plus_fallback(Object a, Object b) {
        if (OperatorSupport.isNotNullAndString(a) || OperatorSupport.isNotNullAndString(b)) {
            return String.valueOf(a) + b;
        }
        return OperatorSupport.reject(a, b, "plus");
    }

    public static Object times_fallback(Object a, Object b) {
        if (OperatorSupport.isInteger(a) && OperatorSupport.isString(b)) {
            return OperatorSupport.repeat((String)b, (Integer)a);
        }
        if (OperatorSupport.isString(a) && OperatorSupport.isInteger(b)) {
            return OperatorSupport.repeat((String)a, (Integer)b);
        }
        return OperatorSupport.reject(a, b, "times");
    }

    private static String repeat(String string, int n) {
        StringBuilder builder = new StringBuilder(string);
        for (int i = 1; i < n; ++i) {
            builder.append(string);
        }
        return builder.toString();
    }

    public static Object equals_noguard(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static Object notequals_noguard(Object a, Object b) {
        return a != b && (a != null && !a.equals(b) || b != null && !b.equals(a));
    }

    public static Object less_noguard(Object a, Object b) {
        if (OperatorSupport.bothNotNull(a, b) && OperatorSupport.isComparable(a) && OperatorSupport.isComparable(b)) {
            return ((Comparable)a).compareTo(b) < 0;
        }
        return OperatorSupport.reject(a, b, "less");
    }

    public static Object lessorequals_noguard(Object a, Object b) {
        if (OperatorSupport.bothNotNull(a, b) && OperatorSupport.isComparable(a) && OperatorSupport.isComparable(b)) {
            return ((Comparable)a).compareTo(b) <= 0;
        }
        return OperatorSupport.reject(a, b, "lessorequals");
    }

    public static Object more_noguard(Object a, Object b) {
        if (OperatorSupport.bothNotNull(a, b) && OperatorSupport.isComparable(a) && OperatorSupport.isComparable(b)) {
            return ((Comparable)a).compareTo(b) > 0;
        }
        return OperatorSupport.reject(a, b, "more");
    }

    public static Object moreorequals_noguard(Object a, Object b) {
        if (OperatorSupport.bothNotNull(a, b) && OperatorSupport.isComparable(a) && OperatorSupport.isComparable(b)) {
            return ((Comparable)a).compareTo(b) >= 0;
        }
        return OperatorSupport.reject(a, b, "moreorequals");
    }

    public static Object not(Boolean a) {
        return a == false;
    }

    public static Object oftype_noguard(Object a, Object b) {
        if (OperatorSupport.isClass(b)) {
            return ((Class)b).isInstance(a);
        }
        return OperatorSupport.reject(a, b, "oftype");
    }

    public static Object is_noguard(Object a, Object b) {
        return a == b;
    }

    public static Object isnt_noguard(Object a, Object b) {
        return a != b;
    }

    public static Object orifnull_noguard(Object a, Object b) {
        return a != null ? a : b;
    }

    private static boolean isNotNullAndString(Object obj) {
        return obj != null && obj.getClass() == String.class;
    }

    private static boolean bothNotNull(Object a, Object b) {
        return a != null && b != null;
    }

    private static boolean isString(Object obj) {
        return obj.getClass() == String.class;
    }

    private static boolean isInteger(Object obj) {
        return obj.getClass() == Integer.class;
    }

    private static boolean isComparable(Object obj) {
        return obj instanceof Comparable;
    }

    private static boolean isClass(Object obj) {
        return obj != null && obj.getClass() == Class.class;
    }

    private static Object reject(Object a, String symbol) throws IllegalArgumentException {
        throw new IllegalArgumentException(String.format("Operator %s is not supported for type %s", symbol, a.getClass()));
    }

    private static Object reject(Object a, Object b, String symbol) throws IllegalArgumentException {
        throw new IllegalArgumentException(String.format("Operator %s is not supported for types %s and %s", symbol, a.getClass(), b.getClass()));
    }

    static {
        NO_GUARD_OPERATORS = new HashSet<String>(){
            {
                this.add("is");
                this.add("isnt");
                this.add("oftype");
                this.add("equals");
                this.add("notequals");
                this.add("more");
                this.add("less");
                this.add("moreorequals");
                this.add("lessorequals");
                this.add("orifnull");
            }
        };
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            GUARD_1 = lookup.findStatic(OperatorSupport.class, "guard_1", MethodType.methodType(Boolean.TYPE, Class.class, Object.class));
            FALLBACK_1 = lookup.findStatic(OperatorSupport.class, "fallback_1", MethodType.methodType(Object.class, MonomorphicInlineCache.class, Object[].class));
            GUARD_2 = lookup.findStatic(OperatorSupport.class, "guard_2", MethodType.methodType(Boolean.TYPE, Class.class, Class.class, Object.class, Object.class));
            FALLBACK_2 = lookup.findStatic(OperatorSupport.class, "fallback_2", MethodType.methodType(Object.class, MonomorphicInlineCache.class, Object[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error("Could not bootstrap the required method handles", e);
        }
    }

    static class MonomorphicInlineCache
    extends MutableCallSite {
        final MethodHandles.Lookup callerLookup;
        final String name;
        MethodHandle fallback;

        MonomorphicInlineCache(MethodHandles.Lookup callerLookup, String name, MethodType type) {
            super(type);
            this.callerLookup = callerLookup;
            this.name = name;
        }
    }
}

