/* Generated By:JJTree&JavaCC: Do not edit this line. GoloParser.java */
package fr.insalyon.citi.golo.compiler.parser;

import java.util.List;
import java.util.LinkedList;
import java.util.LinkedHashSet;
import java.util.Collections;

import fr.insalyon.citi.golo.compiler.utils.StringUnescaping;
import fr.insalyon.citi.golo.compiler.GoloCompilationException;

public class GoloParser/*@bgen(jjtree)*/implements GoloParserTreeConstants, GoloParserConstants {/*@bgen(jjtree)*/
  protected JJTGoloParserState jjtree = new JJTGoloParserState();
  public GoloCompilationException.Builder exceptionBuilder;

  void skipto(int kind, ParseException e, GoloASTNode node) throws ParseException {
    if (exceptionBuilder == null) {
      throw e;
    }
    exceptionBuilder.report(e, node);
    if ("<EOF>".equals(e.tokenImage[0])) {
      return;
    }
    Token t;
    do {
      t = getNextToken();
    } while (t.kind != kind);
  }

  public static class ParserClassRef {

    public String name;

    public ParserClassRef(String name) {
      this.name = name;
    }

    @Override
    public String toString() {
      return "Class<" + name + ">";
    }
  }

  public static class FunctionRef {

    public String module;
    public String name;

    public FunctionRef(String module, String name) {
      this.module = module;
      this.name = name;
    }

    @Override
    public String toString() {
      return "FunctionRef{module=" + module + ",name=" + name + "}";
    }
  }

  public static void main(String[] args) throws Throwable {
    GoloParser parser = new GoloParser(System.in);
    // ASTCompilationUnit unit = parser.CompilationUnit();
    ASTFunctionDeclaration unit = parser.FunctionDeclaration();
    unit.dump("% ");
  }

  void error() throws ParseException {
              /*@bgen(jjtree) error */
ASTerror jjtn000 = new ASTerror(JJTERROR);
boolean jjtc000 = true;
jjtree.openNodeScope(jjtn000);
jjtn000.jjtSetFirstToken(getToken(1));
try {throw generateParseException();/*@bgen(jjtree)*/
} finally {
  if (jjtc000) {
    jjtree.closeNodeScope(jjtn000, true);
    jjtn000.jjtSetLastToken(getToken(0));
  }
}
  }

  final public void BlankLine() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NEWLINE:
      jj_consume_token(NEWLINE);
      break;
    case COMMENT:
      jj_consume_token(COMMENT);
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void BlankLines() throws ParseException {
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      BlankLine();
    }
  }

  final public String QualifiedName() throws ParseException {
  Token rootToken;
  Token nextToken;
  StringBuilder nameBuilder;
    rootToken = jj_consume_token(IDENTIFIER);
    nameBuilder = new StringBuilder(rootToken.image);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 56:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      jj_consume_token(56);
      nextToken = jj_consume_token(IDENTIFIER);
      nameBuilder.append(".").append(nextToken.image);
    }
    {if (true) return nameBuilder.toString();}
    throw new Error("Missing return statement in function");
  }

  final public List<String> Arguments() throws ParseException {
  Token rootToken;
  Token nextToken;
  List<String> arguments = new LinkedList<String>();
    rootToken = jj_consume_token(IDENTIFIER);
    arguments.add(rootToken.image);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 57:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_3;
      }
      jj_consume_token(57);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[4] = jj_gen;
        ;
      }
      nextToken = jj_consume_token(IDENTIFIER);
      arguments.add(nextToken.image);
    }
    {if (true) return arguments;}
    throw new Error("Missing return statement in function");
  }

  final public String StringLiteral() throws ParseException {
  Token literal;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      literal = jj_consume_token(STRING);
      {if (true) return StringUnescaping.unescape(literal.image.substring(1, literal.image.length() - 1));}
      break;
    case MULTI_STRING:
      literal = jj_consume_token(MULTI_STRING);
      {if (true) return literal.image.substring(3, literal.image.length() - 3);}
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Character CharLiteral() throws ParseException {
  Token literal;
    literal = jj_consume_token(CHAR);
    {if (true) return Character.valueOf(literal.image.charAt(1));}
    throw new Error("Missing return statement in function");
  }

  final public Long LongLiteral() throws ParseException {
  Token literal;
    literal = jj_consume_token(LONG_NUMBER);
    String image = literal.image.substring(0, literal.image.length() - 2);
    {if (true) return Long.valueOf(image.replace("_",""));}
    throw new Error("Missing return statement in function");
  }

  final public Integer IntegerLiteral() throws ParseException {
  Token literal;
    literal = jj_consume_token(NUMBER);
    String image = literal.image.replace("_","");
    {if (true) return Integer.valueOf(image);}
    throw new Error("Missing return statement in function");
  }

  final public GoloParser.ParserClassRef ClassLiteral() throws ParseException {
  Token literal;
    literal = jj_consume_token(CLASSREF);
    String image = literal.image;
    int suffixLength = image.endsWith("class") ? 6 : 7;
    {if (true) return new GoloParser.ParserClassRef(image.substring(0, image.length() - suffixLength));}
    throw new Error("Missing return statement in function");
  }

  final public Double DoubleLiteral() throws ParseException {
  Token literal;
    literal = jj_consume_token(FLOATING_NUMBER);
    {if (true) return Double.valueOf(literal.image);}
    throw new Error("Missing return statement in function");
  }

  final public Float FloatLiteral() throws ParseException {
  Token literal;
    literal = jj_consume_token(FLOAT);
    {if (true) return Float.valueOf(literal.image.substring(0, literal.image.length() - 2));}
    throw new Error("Missing return statement in function");
  }

  final public GoloParser.FunctionRef FunctionRef() throws ParseException {
  Token literal;
    literal = jj_consume_token(FUNREF);
    String image = literal.image.substring(1);
    String[] parts = image.split("::");
    if (parts.length > 1) {
      {if (true) return new GoloParser.FunctionRef(parts[0], parts[1]);}
    } else {
      {if (true) return new GoloParser.FunctionRef(null, parts[0]);}
    }
    throw new Error("Missing return statement in function");
  }

// ............................................................................................. //
  final public ASTCompilationUnit CompilationUnit() throws ParseException {
                                       /*@bgen(jjtree) CompilationUnit */
  ASTCompilationUnit jjtn000 = new ASTCompilationUnit(JJTCOMPILATIONUNIT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      try {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
        case MODULE:
        case COMMENT:
          BlankLines();
          ModuleDeclaration();
          BlankLines();
          label_4:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case IMPORT:
              ;
              break;
            default:
              jj_la1[6] = jj_gen;
              break label_4;
            }
            ImportDeclaration();
            BlankLines();
          }
          label_5:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case FUNCTION:
            case LOCAL:
            case AUGMENT:
            case STRUCT:
              ;
              break;
            default:
              jj_la1[7] = jj_gen;
              break label_5;
            }
            try {
              ToplevelDeclaration();
              BlankLines();
            } catch (ParseException e) {
            skipto(NEWLINE, e, jjtn000);
            }
          }
          break;
        default:
          jj_la1[8] = jj_gen;
          error();
        }
        jj_consume_token(0);
      } catch (ParseException e) {
    skipto(NEWLINE, e, jjtn000);
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new Error("Missing return statement in function");
  }

  final public void ModuleDeclaration() throws ParseException {
 /*@bgen(jjtree) ModuleDeclaration */
  ASTModuleDeclaration jjtn000 = new ASTModuleDeclaration(JJTMODULEDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));String name;
    try {
      jj_consume_token(MODULE);
      name = QualifiedName();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    jjtn000.setName(name);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ImportDeclaration() throws ParseException {
 /*@bgen(jjtree) ImportDeclaration */
  ASTImportDeclaration jjtn000 = new ASTImportDeclaration(JJTIMPORTDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));String name;
    try {
      try {
        jj_consume_token(IMPORT);
        name = QualifiedName();
      jjtn000.setName(name);
      } catch (ParseException e) {
    skipto(NEWLINE, e, jjtn000);
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ToplevelDeclaration() throws ParseException {
 /*@bgen(jjtree) ToplevelDeclaration */
  ASTToplevelDeclaration jjtn000 = new ASTToplevelDeclaration(JJTTOPLEVELDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));ASTFunctionDeclaration functionDecl;
  Token local = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AUGMENT:
        AugmentDeclaration();
        break;
      case FUNCTION:
      case LOCAL:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LOCAL:
          local = jj_consume_token(LOCAL);
          break;
        default:
          jj_la1[9] = jj_gen;
          ;
        }
        functionDecl = FunctionDeclaration();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    if (local != null) {
      functionDecl.setLocal(true);
    }
        break;
      case STRUCT:
        StructDeclaration();
        break;
      default:
        jj_la1[10] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void StructDeclaration() throws ParseException {
 /*@bgen(jjtree) StructDeclaration */
  ASTStructDeclaration jjtn000 = new ASTStructDeclaration(JJTSTRUCTDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Token name;
  Token member;
  LinkedHashSet<String> members = new LinkedHashSet<String>();
    try {
      jj_consume_token(STRUCT);
      name = jj_consume_token(IDENTIFIER);
      jj_consume_token(58);
      jj_consume_token(59);
      BlankLines();
      member = jj_consume_token(IDENTIFIER);
      BlankLines();
      members.add(member.image);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 57:
          ;
          break;
        default:
          jj_la1[11] = jj_gen;
          break label_6;
        }
        jj_consume_token(57);
        BlankLines();
        member = jj_consume_token(IDENTIFIER);
        BlankLines();
        members.add(member.image);
      }
      jj_consume_token(60);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    jjtn000.setName(name.image);
    jjtn000.setMembers(members);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void AugmentDeclaration() throws ParseException {
 /*@bgen(jjtree) AugmentDeclaration */
  ASTAugmentDeclaration jjtn000 = new ASTAugmentDeclaration(JJTAUGMENTDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));String target;
  ASTFunctionDeclaration func;
    try {
      jj_consume_token(AUGMENT);
      target = QualifiedName();
      jj_consume_token(59);
      BlankLines();
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FUNCTION:
          ;
          break;
        default:
          jj_la1[12] = jj_gen;
          break label_7;
        }
        func = FunctionDeclaration();
        func.setAugmentation(true);
        ASTFunction body = (ASTFunction) func.jjtGetChild(0);
        if (body.getArguments().isEmpty()) {
          String description = "Error: augmentation function " +
            func.getName() +
            " on " +
            target +
            " must take at least 1 argument ('this' would be a good idea...)";
          if (exceptionBuilder == null) {
            {if (true) throw new TokenMgrError(description, 0);}
          }
          exceptionBuilder.report(GoloCompilationException.Problem.Type.AUGMENT_FUNCTION_NO_ARGS, body, description);
        }
        BlankLines();
      }
      jj_consume_token(60);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    jjtn000.setTarget(target);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public ASTFunctionDeclaration FunctionDeclaration() throws ParseException {
 /*@bgen(jjtree) FunctionDeclaration */
  ASTFunctionDeclaration jjtn000 = new ASTFunctionDeclaration(JJTFUNCTIONDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Token name;
    try {
      jj_consume_token(FUNCTION);
      name = jj_consume_token(IDENTIFIER);
      jj_consume_token(58);
      Function();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    jjtn000.setName(name.image);
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new Error("Missing return statement in function");
  }

// ............................................................................................. //
  final public void Statement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NEWLINE:
    case COMMENT:
      BlankLine();
      break;
    default:
      jj_la1[13] = jj_gen;
      if (jj_2_1(2)) {
        Assignment();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MATCH:
        case UNARY_OPERATOR:
        case NUMBER:
        case LONG_NUMBER:
        case FLOATING_NUMBER:
        case FLOAT:
        case STRING:
        case CHAR:
        case NULL:
        case TRUE:
        case FALSE:
        case CLASSREF:
        case FUNREF:
        case COLL_START:
        case MULTI_STRING:
        case IDENTIFIER:
        case 59:
        case 61:
        case 63:
        case 65:
          ExpressionStatement();
          break;
        case RETURN:
          Return();
          break;
        case VAR:
        case LET:
          LetOrVar();
          break;
        case IF:
          ConditionalBranching();
          break;
        case WHILE:
          WhileLoop();
          break;
        case FOR:
          ForLoop();
          break;
        case FOREACH:
          ForEachLoop();
          break;
        case THROW:
          Throw();
          break;
        case TRY:
          TryCatchFinally();
          break;
        case CASE:
          Case();
          break;
        case CONTINUE:
          Continue();
          break;
        case BREAK:
          Break();
          break;
        default:
          jj_la1[14] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void Continue() throws ParseException {
                  /*@bgen(jjtree) Continue */
  ASTContinue jjtn000 = new ASTContinue(JJTCONTINUE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(CONTINUE);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Break() throws ParseException {
               /*@bgen(jjtree) Break */
  ASTBreak jjtn000 = new ASTBreak(JJTBREAK);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(BREAK);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Throw() throws ParseException {
               /*@bgen(jjtree) Throw */
  ASTThrow jjtn000 = new ASTThrow(JJTTHROW);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(THROW);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[15] = jj_gen;
        ;
      }
      ExpressionStatement();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void WhileLoop() throws ParseException {
                   /*@bgen(jjtree) WhileLoop */
  ASTWhileLoop jjtn000 = new ASTWhileLoop(JJTWHILELOOP);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(WHILE);
      ExpressionStatement();
      Block();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ForLoop() throws ParseException {
                 /*@bgen(jjtree) ForLoop */
  ASTForLoop jjtn000 = new ASTForLoop(JJTFORLOOP);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(FOR);
      jj_consume_token(61);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[16] = jj_gen;
        ;
      }
      LetOrVar();
      jj_consume_token(57);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[17] = jj_gen;
        ;
      }
      ExpressionStatement();
      jj_consume_token(57);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[18] = jj_gen;
        ;
      }
      Statement();
      jj_consume_token(62);
      Block();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ForEachLoop() throws ParseException {
 /*@bgen(jjtree) ForEachLoop */
  ASTForEachLoop jjtn000 = new ASTForEachLoop(JJTFOREACHLOOP);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Token elementId;
    try {
      jj_consume_token(FOREACH);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        elementId = jj_consume_token(IDENTIFIER);
        jj_consume_token(IN);
        ExpressionStatement();
        break;
      case 61:
        jj_consume_token(61);
        elementId = jj_consume_token(IDENTIFIER);
        jj_consume_token(IN);
        ExpressionStatement();
        jj_consume_token(62);
        break;
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      Block();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    jjtn000.setElementIdentifier(elementId.image);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void TryCatchFinally() throws ParseException {
 /*@bgen(jjtree) TryCatchFinally */
  ASTTryCatchFinally jjtn000 = new ASTTryCatchFinally(JJTTRYCATCHFINALLY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Token exceptionId;
    try {
      jj_consume_token(TRY);
      Block();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FINALLY:
        jj_consume_token(FINALLY);
        Block();
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        jjtn000.jjtSetLastToken(getToken(0));
        jjtn000.setExceptionId(null);
        break;
      case CATCH:
        jj_consume_token(CATCH);
        jj_consume_token(61);
        exceptionId = jj_consume_token(IDENTIFIER);
        jj_consume_token(62);
        Block();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FINALLY:
          jj_consume_token(FINALLY);
          Block();
          break;
        default:
          jj_la1[20] = jj_gen;
          ;
        }
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        jjtn000.jjtSetLastToken(getToken(0));
        jjtn000.setExceptionId(exceptionId.image);
        break;
      default:
        jj_la1[21] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ExpressionStatement() throws ParseException {
    CommutativeExpression();
  }

  final public void TerminalExpression() throws ParseException {
    if (jj_2_2(2)) {
      FunctionInvocation();
    } else if (jj_2_3(2)) {
      Reference();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MATCH:
        Match();
        break;
      case NUMBER:
      case LONG_NUMBER:
      case FLOATING_NUMBER:
      case FLOAT:
      case STRING:
      case CHAR:
      case NULL:
      case TRUE:
      case FALSE:
      case CLASSREF:
      case FUNREF:
      case MULTI_STRING:
        Literal();
        break;
      case 59:
      case 63:
      case 65:
        Function();
        break;
      case COLL_START:
        CollectionLiteral();
        break;
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void UnaryExpression() throws ParseException {
 /*@bgen(jjtree) UnaryExpression */
  ASTUnaryExpression jjtn000 = new ASTUnaryExpression(JJTUNARYEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Token token;
    try {
      token = jj_consume_token(UNARY_OPERATOR);
      CommutativeExpression();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    jjtn000.setOperator(token.image);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void CommutativeExpression() throws ParseException {
 /*@bgen(jjtree) CommutativeExpression */
  ASTCommutativeExpression jjtn000 = new ASTCommutativeExpression(JJTCOMMUTATIVEEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Token token;
    try {
      AssociativeExpression();
      label_8:
      while (true) {
        if (jj_2_4(2)) {
          ;
        } else {
          break label_8;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
        case COMMENT:
          BlankLine();
          break;
        default:
          jj_la1[23] = jj_gen;
          ;
        }
        token = jj_consume_token(COMMUTATIVE_OPERATOR);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
        case COMMENT:
          BlankLine();
          break;
        default:
          jj_la1[24] = jj_gen;
          ;
        }
        AssociativeExpression();
      jjtn000.addOperator(token.image);
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void AssociativeExpression() throws ParseException {
 /*@bgen(jjtree) AssociativeExpression */
  ASTAssociativeExpression jjtn000 = new ASTAssociativeExpression(JJTASSOCIATIVEEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Token token;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 61:
        jj_consume_token(61);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
        case COMMENT:
          BlankLine();
          break;
        default:
          jj_la1[25] = jj_gen;
          ;
        }
        CommutativeExpression();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
        case COMMENT:
          BlankLine();
          break;
        default:
          jj_la1[26] = jj_gen;
          ;
        }
        jj_consume_token(62);
        break;
      case MATCH:
      case NUMBER:
      case LONG_NUMBER:
      case FLOATING_NUMBER:
      case FLOAT:
      case STRING:
      case CHAR:
      case NULL:
      case TRUE:
      case FALSE:
      case CLASSREF:
      case FUNREF:
      case COLL_START:
      case MULTI_STRING:
      case IDENTIFIER:
      case 59:
      case 63:
      case 65:
        TerminalExpression();
        break;
      case UNARY_OPERATOR:
        UnaryExpression();
        break;
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[28] = jj_gen;
        ;
      }
      label_9:
      while (true) {
        if (jj_2_5(2)) {
          ;
        } else {
          break label_9;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ASSOCIATIVE_OPERATOR:
          token = jj_consume_token(ASSOCIATIVE_OPERATOR);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NEWLINE:
          case COMMENT:
            BlankLine();
            break;
          default:
            jj_la1[29] = jj_gen;
            ;
          }
          AssociativeExpression();
        jjtn000.addOperator(token.image);
          break;
        case NEWLINE:
        case INVOCATION:
        case COMMENT:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NEWLINE:
          case COMMENT:
            BlankLine();
            break;
          default:
            jj_la1[30] = jj_gen;
            ;
          }
          token = jj_consume_token(INVOCATION);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NEWLINE:
          case COMMENT:
            BlankLine();
            break;
          default:
            jj_la1[31] = jj_gen;
            ;
          }
          MethodInvocation();
        jjtn000.addOperator(token.image);
          break;
        default:
          jj_la1[32] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[33] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void MethodInvocation() throws ParseException {
 /*@bgen(jjtree) MethodInvocation */
  ASTMethodInvocation jjtn000 = new ASTMethodInvocation(JJTMETHODINVOCATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Token token;
    try {
      token = jj_consume_token(IDENTIFIER);
      jj_consume_token(61);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[34] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MATCH:
      case UNARY_OPERATOR:
      case NUMBER:
      case LONG_NUMBER:
      case FLOATING_NUMBER:
      case FLOAT:
      case STRING:
      case CHAR:
      case NULL:
      case TRUE:
      case FALSE:
      case CLASSREF:
      case FUNREF:
      case COLL_START:
      case MULTI_STRING:
      case IDENTIFIER:
      case 59:
      case 61:
      case 63:
      case 65:
        Expressions();
        break;
      default:
        jj_la1[35] = jj_gen;
        ;
      }
      jj_consume_token(62);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    jjtn000.setName(token.image);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Block() throws ParseException {
               /*@bgen(jjtree) Block */
  ASTBlock jjtn000 = new ASTBlock(JJTBLOCK);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      try {
        jj_consume_token(59);
        label_10:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NEWLINE:
          case RETURN:
          case IF:
          case WHILE:
          case FOR:
          case FOREACH:
          case THROW:
          case TRY:
          case CASE:
          case MATCH:
          case BREAK:
          case CONTINUE:
          case UNARY_OPERATOR:
          case VAR:
          case LET:
          case NUMBER:
          case LONG_NUMBER:
          case FLOATING_NUMBER:
          case FLOAT:
          case STRING:
          case CHAR:
          case NULL:
          case TRUE:
          case FALSE:
          case CLASSREF:
          case FUNREF:
          case COLL_START:
          case MULTI_STRING:
          case IDENTIFIER:
          case COMMENT:
          case 59:
          case 61:
          case 63:
          case 65:
            ;
            break;
          default:
            jj_la1[36] = jj_gen;
            break label_10;
          }
          try {
            Statement();
          } catch (ParseException e) {
        skipto(NEWLINE, e, jjtn000);
          }
        }
        jj_consume_token(60);
      } catch (ParseException e) {
    skipto(NEWLINE, e, jjtn000);
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Function() throws ParseException {
 /*@bgen(jjtree) Function */
  ASTFunction jjtn000 = new ASTFunction(JJTFUNCTION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));List<String> arguments = null;
  Token varargsToken = null;
  boolean compactForm = false;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 63:
        jj_consume_token(63);
        arguments = Arguments();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 64:
          varargsToken = jj_consume_token(64);
          break;
        default:
          jj_la1[37] = jj_gen;
          ;
        }
        jj_consume_token(63);
        break;
      default:
        jj_la1[38] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 59:
        Block();
        break;
      case 65:
        jj_consume_token(65);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
        case COMMENT:
          BlankLine();
          break;
        default:
          jj_la1[39] = jj_gen;
          ;
        }
        ExpressionStatement();
      compactForm = true;
        break;
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    if (arguments == null) {
      arguments = Collections.emptyList();
    }
    jjtn000.setCompactForm(compactForm);
    jjtn000.setArguments(arguments);
    jjtn000.setVarargs(varargsToken != null);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Literal() throws ParseException {
 /*@bgen(jjtree) Literal */
  ASTLiteral jjtn000 = new ASTLiteral(JJTLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Object value;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CLASSREF:
        value = ClassLiteral();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
      jjtn000.setLiteralValue(value);
        break;
      case STRING:
      case MULTI_STRING:
        value = StringLiteral();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
      jjtn000.setLiteralValue(value);
        break;
      case CHAR:
        value = CharLiteral();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
      jjtn000.setLiteralValue(value);
        break;
      case FLOAT:
        value = FloatLiteral();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
      jjtn000.setLiteralValue(value);
        break;
      case FLOATING_NUMBER:
        value = DoubleLiteral();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
      jjtn000.setLiteralValue(value);
        break;
      case LONG_NUMBER:
        value = LongLiteral();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
      jjtn000.setLiteralValue(value);
        break;
      case NUMBER:
        value = IntegerLiteral();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
      jjtn000.setLiteralValue(value);
        break;
      case NULL:
        jj_consume_token(NULL);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
      jjtn000.setLiteralValue(null);
        break;
      case TRUE:
        jj_consume_token(TRUE);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
      jjtn000.setLiteralValue(Boolean.TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
      jjtn000.setLiteralValue(Boolean.FALSE);
        break;
      case FUNREF:
        value = FunctionRef();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
      jjtn000.setLiteralValue(value);
        break;
      default:
        jj_la1[41] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void CollectionLiteral() throws ParseException {
 /*@bgen(jjtree) CollectionLiteral */
  ASTCollectionLiteral jjtn000 = new ASTCollectionLiteral(JJTCOLLECTIONLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Token token;
    try {
      token = jj_consume_token(COLL_START);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[42] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MATCH:
      case UNARY_OPERATOR:
      case NUMBER:
      case LONG_NUMBER:
      case FLOATING_NUMBER:
      case FLOAT:
      case STRING:
      case CHAR:
      case NULL:
      case TRUE:
      case FALSE:
      case CLASSREF:
      case FUNREF:
      case COLL_START:
      case MULTI_STRING:
      case IDENTIFIER:
      case 59:
      case 61:
      case 63:
      case 65:
        ExpressionStatement();
        label_11:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case 57:
            ;
            break;
          default:
            jj_la1[43] = jj_gen;
            break label_11;
          }
          jj_consume_token(57);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NEWLINE:
          case COMMENT:
            BlankLine();
            break;
          default:
            jj_la1[44] = jj_gen;
            ;
          }
          ExpressionStatement();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
        case COMMENT:
          BlankLine();
          break;
        default:
          jj_la1[45] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[46] = jj_gen;
        ;
      }
      jj_consume_token(66);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    String image = token.image;
    jjtn000.setType(image.substring(0, image.length() - 1));
    if (jjtn000.getType().isEmpty()) {
      jjtn000.setType("tuple");
    }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Reference() throws ParseException {
                  /*@bgen(jjtree) Reference */
  ASTReference jjtn000 = new ASTReference(JJTREFERENCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(IDENTIFIER);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    jjtn000.setName(jjtn000.jjtGetFirstToken().image);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void LetOrVar() throws ParseException {
 /*@bgen(jjtree) LetOrVar */
  ASTLetOrVar jjtn000 = new ASTLetOrVar(JJTLETORVAR);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Token idToken;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LET:
        jj_consume_token(LET);
        idToken = jj_consume_token(IDENTIFIER);
        jj_consume_token(58);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
        case COMMENT:
          BlankLine();
          break;
        default:
          jj_la1[47] = jj_gen;
          ;
        }
        ExpressionStatement();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    jjtn000.setType(ASTLetOrVar.Type.LET);
    jjtn000.setName(idToken.image);
        break;
      case VAR:
        jj_consume_token(VAR);
        idToken = jj_consume_token(IDENTIFIER);
        jj_consume_token(58);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
        case COMMENT:
          BlankLine();
          break;
        default:
          jj_la1[48] = jj_gen;
          ;
        }
        ExpressionStatement();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    jjtn000.setType(ASTLetOrVar.Type.VAR);
    jjtn000.setName(idToken.image);
        break;
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Assignment() throws ParseException {
 /*@bgen(jjtree) Assignment */
  ASTAssignment jjtn000 = new ASTAssignment(JJTASSIGNMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Token idToken;
    try {
      idToken = jj_consume_token(IDENTIFIER);
      jj_consume_token(58);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[50] = jj_gen;
        ;
      }
      ExpressionStatement();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    jjtn000.setName(idToken.image);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Return() throws ParseException {
                /*@bgen(jjtree) Return */
  ASTReturn jjtn000 = new ASTReturn(JJTRETURN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(RETURN);
      if (jj_2_6(2)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
        case COMMENT:
          BlankLine();
          break;
        default:
          jj_la1[51] = jj_gen;
          ;
        }
        ExpressionStatement();
      } else {
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Expressions() throws ParseException {
    ExpressionStatement();
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 57:
        ;
        break;
      default:
        jj_la1[52] = jj_gen;
        break label_12;
      }
      jj_consume_token(57);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[53] = jj_gen;
        ;
      }
      ExpressionStatement();
    }
  }

  final public void FunctionInvocation() throws ParseException {
 /*@bgen(jjtree) FunctionInvocation */
  ASTFunctionInvocation jjtn000 = new ASTFunctionInvocation(JJTFUNCTIONINVOCATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));String name;
    try {
      name = QualifiedName();
      jj_consume_token(61);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[54] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MATCH:
      case UNARY_OPERATOR:
      case NUMBER:
      case LONG_NUMBER:
      case FLOATING_NUMBER:
      case FLOAT:
      case STRING:
      case CHAR:
      case NULL:
      case TRUE:
      case FALSE:
      case CLASSREF:
      case FUNREF:
      case COLL_START:
      case MULTI_STRING:
      case IDENTIFIER:
      case 59:
      case 61:
      case 63:
      case 65:
        Expressions();
        break;
      default:
        jj_la1[55] = jj_gen;
        ;
      }
      jj_consume_token(62);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    jjtn000.setName(name);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ConditionalBranching() throws ParseException {
                              /*@bgen(jjtree) ConditionalBranching */
  ASTConditionalBranching jjtn000 = new ASTConditionalBranching(JJTCONDITIONALBRANCHING);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(IF);
      ExpressionStatement();
      Block();
      if (jj_2_7(2147483647)) {
        jj_consume_token(ELSE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IF:
          ConditionalBranching();
          break;
        case 59:
          Block();
          break;
        default:
          jj_la1[56] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Case() throws ParseException {
              /*@bgen(jjtree) Case */
  ASTCase jjtn000 = new ASTCase(JJTCASE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(CASE);
      jj_consume_token(59);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[57] = jj_gen;
        ;
      }
      label_13:
      while (true) {
        jj_consume_token(WHEN);
        ExpressionStatement();
        Block();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
        case COMMENT:
          BlankLine();
          break;
        default:
          jj_la1[58] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHEN:
          ;
          break;
        default:
          jj_la1[59] = jj_gen;
          break label_13;
        }
      }
      jj_consume_token(OTHERWISE);
      Block();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[60] = jj_gen;
        ;
      }
      jj_consume_token(60);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Match() throws ParseException {
               /*@bgen(jjtree) Match */
  ASTMatch jjtn000 = new ASTMatch(JJTMATCH);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(MATCH);
      jj_consume_token(59);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[61] = jj_gen;
        ;
      }
      label_14:
      while (true) {
        jj_consume_token(WHEN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
        case COMMENT:
          BlankLine();
          break;
        default:
          jj_la1[62] = jj_gen;
          ;
        }
        ExpressionStatement();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
        case COMMENT:
          BlankLine();
          break;
        default:
          jj_la1[63] = jj_gen;
          ;
        }
        jj_consume_token(THEN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
        case COMMENT:
          BlankLine();
          break;
        default:
          jj_la1[64] = jj_gen;
          ;
        }
        ExpressionStatement();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NEWLINE:
        case COMMENT:
          BlankLine();
          break;
        default:
          jj_la1[65] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHEN:
          ;
          break;
        default:
          jj_la1[66] = jj_gen;
          break label_14;
        }
      }
      jj_consume_token(OTHERWISE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[67] = jj_gen;
        ;
      }
      ExpressionStatement();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
      case COMMENT:
        BlankLine();
        break;
      default:
        jj_la1[68] = jj_gen;
        ;
      }
      jj_consume_token(60);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_3R_28() {
    if (jj_3R_36()) return true;
    return false;
  }

  private boolean jj_3R_18() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3R_15() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(58)) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_scan_token(CHAR)) return true;
    return false;
  }

  private boolean jj_3R_27() {
    if (jj_scan_token(61)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_48()) jj_scanpos = xsp;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_20() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_42()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_5()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_43()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_scan_token(VAR)) return true;
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_scan_token(MULTI_STRING)) return true;
    return false;
  }

  private boolean jj_3_4() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_18()) jj_scanpos = xsp;
    if (jj_scan_token(COMMUTATIVE_OPERATOR)) return true;
    xsp = jj_scanpos;
    if (jj_3R_19()) jj_scanpos = xsp;
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_scan_token(LET)) return true;
    return false;
  }

  private boolean jj_3R_94() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) return true;
    }
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_3R_20()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_4()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_64() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) return true;
    }
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3R_37() {
    if (jj_scan_token(UNARY_OPERATOR)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_17() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_41() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_40() {
    if (jj_3R_46()) return true;
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_39() {
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_38() {
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_47() {
    if (jj_scan_token(COLL_START)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_74()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_75()) jj_scanpos = xsp;
    if (jj_scan_token(66)) return true;
    return false;
  }

  private boolean jj_3R_36() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3R_24() {
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_scan_token(56)) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_25() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_35()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_scan_token(TRY)) return true;
    return false;
  }

  private boolean jj_3R_55() {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_26() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) return true;
    }
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_scan_token(FOREACH)) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3R_51() {
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_97() {
    if (jj_scan_token(FOR)) return true;
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_scan_token(WHILE)) return true;
    return false;
  }

  private boolean jj_3R_45() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_99() {
    if (jj_scan_token(THROW)) return true;
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_scan_token(BREAK)) return true;
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_scan_token(CONTINUE)) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_scan_token(FUNREF)) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_scan_token(65)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_77()) jj_scanpos = xsp;
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_scan_token(63)) return true;
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_46() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_60()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) return true;
    }
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_32() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_scan_token(MATCH)) return true;
    if (jj_scan_token(59)) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_scan_token(FLOATING_NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3R_19() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_scan_token(ELSE)) return true;
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_scan_token(CASE)) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_15()) return true;
    return false;
  }

  private boolean jj_3R_30() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3R_79() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3_1()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_63() {
    if (jj_scan_token(CLASSREF)) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_scan_token(59)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_78()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(60)) return true;
    return false;
  }

  private boolean jj_3R_23() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_scan_token(IF)) return true;
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_16() {
    if (jj_3R_25()) return true;
    if (jj_scan_token(61)) return true;
    return false;
  }

  private boolean jj_3R_43() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3_6() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_23()) jj_scanpos = xsp;
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_31() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3R_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_31()) jj_scanpos = xsp;
    if (jj_scan_token(INVOCATION)) return true;
    xsp = jj_scanpos;
    if (jj_3R_32()) jj_scanpos = xsp;
    if (jj_3R_33()) return true;
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_scan_token(LONG_NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_21() {
    if (jj_scan_token(ASSOCIATIVE_OPERATOR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_30()) jj_scanpos = xsp;
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_scan_token(RETURN)) return true;
    return false;
  }

  private boolean jj_3_5() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_3R_22()) return true;
    }
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3R_29() {
    if (jj_3R_37()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public GoloParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[69];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x20,0x20,0x0,0x0,0x20,0x0,0x100,0x48000600,0xa0,0x400,0x48000600,0x0,0x200,0x20,0x314dd800,0x20,0x20,0x20,0x20,0x0,0x200000,0x300000,0x1000000,0x20,0x20,0x20,0x20,0x1000000,0x20,0x20,0x20,0x20,0x80000020,0x20,0x20,0x1000000,0x314dd820,0x0,0x0,0x20,0x0,0x0,0x20,0x0,0x20,0x20,0x1000000,0x20,0x20,0x0,0x20,0x20,0x0,0x20,0x20,0x1000000,0x1000,0x20,0x20,0x800000,0x20,0x20,0x20,0x20,0x20,0x20,0x800000,0x20,0x20,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x800000,0x800000,0x1000000,0x2000000,0x800000,0x80200,0x0,0x0,0x800000,0x0,0x0,0x2000000,0x0,0x800000,0xa819fffa,0x800000,0x800000,0x800000,0x800000,0x20100000,0x0,0x0,0x8809ffe0,0x800000,0x800000,0x800000,0x800000,0xa819ffe2,0x800000,0x800000,0x800000,0x800000,0x800004,0x800000,0x800000,0xa819ffe2,0xa899fffa,0x0,0x80000000,0x800000,0x8000000,0x8ffe0,0x800000,0x2000000,0x800000,0x800000,0xa819ffe2,0x800000,0x800000,0x18,0x800000,0x800000,0x2000000,0x800000,0x800000,0xa819ffe2,0x8000000,0x800000,0x800000,0x0,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x0,0x800000,0x800000,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x2,0x1,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[7];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public GoloParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public GoloParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new GoloParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 69; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 69; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public GoloParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new GoloParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 69; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 69; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public GoloParser(GoloParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 69; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(GoloParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 69; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[67];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 69; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 67; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 7; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
