/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.cli;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import fr.insalyon.citi.golo.cli.Metadata;
import fr.insalyon.citi.golo.compiler.GoloClassLoader;
import fr.insalyon.citi.golo.compiler.GoloCompilationException;
import fr.insalyon.citi.golo.compiler.GoloCompiler;
import fr.insalyon.citi.golo.compiler.ir.GoloModule;
import fr.insalyon.citi.golo.compiler.ir.IrTreeDumper;
import fr.insalyon.citi.golo.compiler.parser.ASTCompilationUnit;
import fr.insalyon.citi.golo.compiler.parser.GoloOffsetParser;
import fr.insalyon.citi.golo.compiler.parser.ParseException;
import fr.insalyon.citi.golo.doc.AbstractProcessor;
import fr.insalyon.citi.golo.doc.HtmlProcessor;
import fr.insalyon.citi.golo.doc.MarkdownProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;

public class Main {
    public static void main(String ... args) throws Throwable {
        GlobalArguments global = new GlobalArguments();
        JCommander cmd = new JCommander((Object)global);
        cmd.setProgramName("golo");
        VersionCommand version = new VersionCommand();
        cmd.addCommand("version", (Object)version);
        CompilerCommand goloc = new CompilerCommand();
        cmd.addCommand("compile", (Object)goloc);
        RunCommand golo = new RunCommand();
        cmd.addCommand("run", (Object)golo);
        GoloGoloCommand gologolo = new GoloGoloCommand();
        cmd.addCommand("golo", (Object)gologolo);
        DiagnoseCommand diagnose = new DiagnoseCommand();
        cmd.addCommand("diagnose", (Object)diagnose);
        DocCommand doc = new DocCommand();
        cmd.addCommand("doc", (Object)doc);
        InitCommand init = new InitCommand();
        cmd.addCommand("new", (Object)init);
        try {
            cmd.parse(args);
            if (global.help || cmd.getParsedCommand() == null) {
                cmd.usage();
            } else {
                switch (cmd.getParsedCommand()) {
                    case "version": {
                        Main.version(version);
                        break;
                    }
                    case "compile": {
                        Main.compile(goloc);
                        break;
                    }
                    case "run": {
                        Main.run(golo);
                        break;
                    }
                    case "golo": {
                        Main.golo(gologolo);
                        break;
                    }
                    case "diagnose": {
                        Main.diagnose(diagnose);
                        break;
                    }
                    case "doc": {
                        Main.doc(doc);
                        break;
                    }
                    case "new": {
                        Main.init(init);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"WTF?");
                    }
                }
            }
        }
        catch (ParameterException exception) {
            System.err.println(exception.getMessage());
            System.out.println();
            cmd.usage();
        }
        catch (IOException exception) {
            System.err.println(exception.getMessage());
            System.exit(1);
        }
    }

    private static void diagnose(DiagnoseCommand diagnose) {
        try {
            switch (diagnose.mode) {
                case "ast": {
                    Main.dumpASTs(diagnose.files);
                    break;
                }
                case "ir": {
                    Main.dumpIRs(diagnose.files);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"WTF?");
                }
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
        }
        catch (GoloCompilationException e) {
            Main.handleCompilationException(e);
        }
    }

    private static void init(InitCommand init) throws IOException {
        if (init.names.isEmpty()) {
            init.names.add("Golo");
        }
        for (String name : init.names) {
            Main.initProject(init.path, name, init.type);
        }
    }

    private static void initProject(String projectPath, String projectName, String type) throws IOException {
        switch (type) {
            case "simple": {
                Main.initSimpleProject(projectPath, projectName);
                break;
            }
            case "maven": {
                Main.initMavenProject(projectPath, projectName);
                break;
            }
            case "gradle": {
                Main.initGradleProject(projectPath, projectName);
                break;
            }
            default: {
                throw new AssertionError((Object)"The type of project must be one of {maven, gradle, simple}");
            }
        }
    }

    private static void initSimpleProject(String projectPath, String projectName) throws IOException {
        System.out.println("Generating a new simple project named " + projectName + "...");
        File projectDir = Main.createProjectDir(projectPath + File.separatorChar + projectName);
        Main.mkdir(new File(projectDir, "imports"));
        Main.mkdir(new File(projectDir, "jars"));
        Main.createMainGoloFile(projectDir, projectName);
    }

    private static void initMavenProject(String projectPath, String projectName) throws IOException {
        System.out.println("Generating a new maven project named " + projectName + "...");
        File projectDir = Main.createProjectDir(projectPath + File.separatorChar + projectName);
        Main.writeProjectFile(projectDir, projectName, "new-project/maven/pom.xml", "pom.xml");
        File sourcesDir = new File(projectDir, "src" + File.separatorChar + "main");
        Main.mkdirs(sourcesDir);
        File sourcesGolo = new File(sourcesDir, "golo");
        Main.mkdir(sourcesGolo);
        Main.createMainGoloFile(sourcesGolo, projectName);
    }

    private static void initGradleProject(String projectPath, String projectName) throws IOException {
        System.out.println("Generating a new gradle project named " + projectName + "...");
        File projectDir = Main.createProjectDir(projectPath + File.separatorChar + projectName);
        Main.writeProjectFile(projectDir, projectName, "new-project/gradle/build.gradle", "build.gradle");
        File sourcesDir = new File(projectDir, "src" + File.separatorChar + "main");
        Main.mkdirs(sourcesDir);
        File sourcesGolo = new File(sourcesDir, "golo");
        Main.mkdir(sourcesGolo);
        Main.createMainGoloFile(sourcesGolo, projectName);
    }

    private static File createProjectDir(String projectName) throws IOException {
        File projectDir = new File(projectName);
        if (projectDir.exists()) {
            throw new IOException("[error] The directory " + projectName + " already exists.");
        }
        Main.mkdir(projectDir);
        return projectDir;
    }

    private static void createMainGoloFile(File intoDir, String projectName) throws FileNotFoundException, UnsupportedEncodingException {
        File mainGoloFile = new File(intoDir, "main.golo");
        PrintWriter writer = new PrintWriter(mainGoloFile, "UTF-8");
        writer.println("module " + projectName);
        writer.println("");
        writer.println("function main = |args| {");
        writer.println("  println(\"Hello " + projectName + "!\")");
        writer.println("}");
        writer.close();
    }

    private static void writeProjectFile(File intoDir, String projectName, String sourcePath, String fileName) throws IOException {
        String line;
        InputStream sourceInputStream = Main.class.getClassLoader().getResourceAsStream(sourcePath);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sourceInputStream));
        File projectFile = new File(intoDir, fileName);
        PrintWriter writer = new PrintWriter(projectFile, "UTF-8");
        while ((line = bufferedReader.readLine()) != null) {
            writer.println(line.replace("{{projectName}}", projectName));
        }
        writer.close();
    }

    private static void mkdir(File directory) throws IOException {
        if (!directory.mkdir()) {
            throw new IOException("[error] Unable to create directory " + directory + ".");
        }
    }

    private static void mkdirs(File directory) throws IOException {
        if (!directory.mkdirs()) {
            throw new IOException("[error] Unable to create directory " + directory + ".");
        }
    }

    private static void dumpASTs(List<String> files) throws FileNotFoundException {
        GoloCompiler compiler = new GoloCompiler();
        for (String file : files) {
            System.out.println(">>> AST for: " + file);
            ASTCompilationUnit ast = compiler.parse(file, new GoloOffsetParser(new FileInputStream(file)));
            ast.dump("% ");
            System.out.println();
        }
    }

    private static void dumpIRs(List<String> files) throws FileNotFoundException {
        GoloCompiler compiler = new GoloCompiler();
        IrTreeDumper dumper = new IrTreeDumper();
        for (String file : files) {
            System.out.println(">>> IR for: " + file);
            ASTCompilationUnit ast = compiler.parse(file, new GoloOffsetParser(new FileInputStream(file)));
            GoloModule module = compiler.check(ast);
            dumper.visitModule(module);
            System.out.println();
        }
    }

    static void handleCompilationException(GoloCompilationException e) {
        if (e.getMessage() != null) {
            System.out.println("[error] " + e.getMessage());
        }
        if (e.getCause() != null) {
            System.out.println("[error] " + e.getCause().getMessage());
        }
        for (GoloCompilationException.Problem problem : e.getProblems()) {
            System.out.println("[error] " + problem.getDescription());
        }
        System.exit(1);
    }

    private static void version(VersionCommand options) {
        if (options.full) {
            System.out.println(Metadata.VERSION + " (build " + Metadata.TIMESTAMP + ")");
        } else {
            System.out.println(Metadata.VERSION);
        }
    }

    private static void compile(CompilerCommand options) {
        GoloCompiler compiler = new GoloCompiler();
        File outputDir = new File(options.output);
        for (String source : options.sources) {
            File file = new File(source);
            try {
                FileInputStream in = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    compiler.compileTo(file.getName(), in, outputDir);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                System.out.println("[error] " + source + " does not exist or could not be opened.");
                return;
            }
            catch (GoloCompilationException e) {
                Main.handleCompilationException(e);
            }
        }
    }

    private static void callRun(Class<?> klass, String[] arguments) throws Throwable {
        MethodHandle main = MethodHandles.publicLookup().findStatic(klass, "main", MethodType.methodType(Void.TYPE, String[].class));
        main.invoke(arguments);
    }

    private static void run(RunCommand golo) throws Throwable {
        try {
            URLClassLoader primaryClassLoader = Main.primaryClassLoader(golo.classpath);
            Thread.currentThread().setContextClassLoader(primaryClassLoader);
            Class<?> module = Class.forName(golo.module, true, primaryClassLoader);
            Main.callRun(module, golo.arguments.toArray(new String[golo.arguments.size()]));
        }
        catch (ClassNotFoundException e) {
            System.out.println("The module " + golo.module + " could not be loaded.");
        }
        catch (NoSuchMethodException e) {
            System.out.println("The module " + golo.module + " does not have a main method with an argument.");
        }
    }

    private static URLClassLoader primaryClassLoader(List<String> classpath) throws MalformedURLException {
        URL[] urls = new URL[classpath.size()];
        int index = 0;
        for (String element : classpath) {
            urls[index] = new File(element).toURI().toURL();
            ++index;
        }
        return new URLClassLoader(urls);
    }

    private static void golo(GoloGoloCommand gologolo) throws Throwable {
        URLClassLoader primaryClassLoader = Main.primaryClassLoader(gologolo.classpath);
        Thread.currentThread().setContextClassLoader(primaryClassLoader);
        GoloClassLoader loader = new GoloClassLoader(primaryClassLoader);
        Class<?> lastClass = null;
        for (String goloFile : gologolo.files) {
            File file = new File(goloFile);
            if (!file.exists()) {
                System.out.println("Error: " + file + " does not exist.");
                return;
            }
            if (!file.isFile()) {
                System.out.println("Error: " + file + " is not a file.");
                return;
            }
            try {
                FileInputStream in = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    lastClass = loader.load(file.getName(), in);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (GoloCompilationException e) {
                Main.handleCompilationException(e);
            }
        }
        Main.callRun(lastClass, gologolo.arguments.toArray(new String[gologolo.arguments.size()]));
    }

    private static void doc(DocCommand options) {
        AbstractProcessor processor;
        switch (options.format) {
            case "markdown": {
                processor = new MarkdownProcessor();
                break;
            }
            case "html": {
                processor = new HtmlProcessor();
                break;
            }
            default: {
                throw new AssertionError((Object)"WTF?");
            }
        }
        LinkedList<ASTCompilationUnit> units = new LinkedList<ASTCompilationUnit>();
        for (String source : options.sources) {
            try {
                FileInputStream in = new FileInputStream(source);
                Throwable throwable = null;
                try {
                    units.add(new GoloOffsetParser(in).CompilationUnit());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                System.out.println("[error] " + source + " does not exist or could not be opened.");
            }
            catch (ParseException e) {
                System.out.println("[error] " + source + " has syntax errors: " + e.getMessage());
            }
        }
        try {
            processor.process(units, Paths.get(options.output, new String[0]));
        }
        catch (Throwable throwable) {
            System.out.println("[error] " + throwable.getMessage());
        }
    }

    public static class DocFormatValidator
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            switch (value) {
                case "html": 
                case "markdown": {
                    return;
                }
            }
            throw new ParameterException("Output format must be in: {html, markdown}");
        }
    }

    @Parameters(commandDescription="Generate documentation from Golo source files")
    private static class DocCommand {
        @Parameter(names={"--format"}, description="Documentation output format (html, markdown)", validateWith=DocFormatValidator.class)
        String format = "html";
        @Parameter(names={"--output"}, description="The documentation output directory")
        String output = ".";
        @Parameter(description="Golo source files (*.golo)")
        List<String> sources = new LinkedList<String>();

        private DocCommand() {
        }
    }

    public static class DiagnoseModeValidator
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            switch (value) {
                case "ast": 
                case "ir": {
                    return;
                }
            }
            throw new ParameterException("Diagnosis tool must be in: {ast, ir}");
        }
    }

    @Parameters(commandDescription="Generate new Golo projects")
    static class InitCommand {
        @Parameter(names={"--path"}, description="Path for the new projects")
        String path = ".";
        @Parameter(names={"--type"}, description="Type of project: {maven, gradle, simple}")
        String type = "simple";
        @Parameter(description="Names of the new Golo projects")
        List<String> names = new LinkedList<String>();

        InitCommand() {
        }
    }

    @Parameters(commandDescription="Diagnosis for the Golo compiler internals")
    static class DiagnoseCommand {
        @Parameter(names={"--tool"}, description="The diagnosis tool to use: {ast, ir}", validateWith=DiagnoseModeValidator.class)
        String mode = "ir";
        @Parameter(description="Golo source files (*.golo)")
        List<String> files = new LinkedList<String>();

        DiagnoseCommand() {
        }
    }

    @Parameters(commandDescription="Dynamically loads and runs from Golo source files")
    static class GoloGoloCommand {
        @Parameter(names={"--files"}, variableArity=true, description="Golo source files (the last one has a main function)", required=true)
        List<String> files = new LinkedList<String>();
        @Parameter(names={"--args"}, variableArity=true, description="Program arguments")
        List<String> arguments = new LinkedList<String>();
        @Parameter(names={"--classpath"}, variableArity=true, description="Classpath elements (.jar and directories)")
        List<String> classpath = new LinkedList<String>();

        GoloGoloCommand() {
        }
    }

    @Parameters(commandDescription="Runs compiled Golo code")
    static class RunCommand {
        @Parameter(names={"--module"}, description="The Golo module with a main function", required=true)
        String module;
        @Parameter(description="Program arguments")
        List<String> arguments = new LinkedList<String>();
        @Parameter(names={"--classpath"}, variableArity=true, description="Classpath elements (.jar and directories)")
        List<String> classpath = new LinkedList<String>();

        RunCommand() {
        }
    }

    @Parameters(commandDescription="Compiles Golo source files")
    static class CompilerCommand {
        @Parameter(names={"--output"}, description="The compiled classes output directory")
        String output = ".";
        @Parameter(description="Golo source files (*.golo)")
        List<String> sources = new LinkedList<String>();

        CompilerCommand() {
        }
    }

    @Parameters(commandDescription="Queries the Golo version")
    static class VersionCommand {
        @Parameter(names={"--full"}, description="Prints the full information details")
        boolean full = false;

        VersionCommand() {
        }
    }

    static class GlobalArguments {
        @Parameter(names={"--help"}, description="Prints this message", help=true)
        boolean help;

        GlobalArguments() {
        }
    }
}

