/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler.ir;

import fr.insalyon.citi.golo.compiler.PackageAndClass;
import fr.insalyon.citi.golo.compiler.ir.AssignmentStatement;
import fr.insalyon.citi.golo.compiler.ir.Block;
import fr.insalyon.citi.golo.compiler.ir.GoloElement;
import fr.insalyon.citi.golo.compiler.ir.GoloFunction;
import fr.insalyon.citi.golo.compiler.ir.GoloIrVisitor;
import fr.insalyon.citi.golo.compiler.ir.LocalReference;
import fr.insalyon.citi.golo.compiler.ir.ModuleImport;
import fr.insalyon.citi.golo.compiler.ir.ReferenceTable;
import fr.insalyon.citi.golo.compiler.ir.Struct;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class GoloModule
extends GoloElement {
    private final PackageAndClass packageAndClass;
    private final Set<ModuleImport> imports = new LinkedHashSet<ModuleImport>();
    private final Set<GoloFunction> functions = new LinkedHashSet<GoloFunction>();
    private final Map<String, Set<GoloFunction>> augmentations = new LinkedHashMap<String, Set<GoloFunction>>();
    private final Set<Struct> structs = new LinkedHashSet<Struct>();
    private final Set<LocalReference> moduleState = new LinkedHashSet<LocalReference>();
    private GoloFunction moduleStateInitializer = null;
    public static final ModuleImport PREDEF = new ModuleImport(PackageAndClass.fromString("gololang.Predefined"));
    public static final ModuleImport STD_AUGMENTATIONS = new ModuleImport(PackageAndClass.fromString("gololang.StandardAugmentations"));
    public static final ModuleImport GOLOLANG = new ModuleImport(PackageAndClass.fromString("gololang"));
    public static final ModuleImport JAVALANG = new ModuleImport(PackageAndClass.fromString("java.lang"));

    public GoloModule(PackageAndClass packageAndClass) {
        this.packageAndClass = packageAndClass;
        this.imports.add(PREDEF);
        this.imports.add(STD_AUGMENTATIONS);
        this.imports.add(GOLOLANG);
        this.imports.add(JAVALANG);
    }

    public void addModuleStateInitializer(ReferenceTable table, AssignmentStatement assignment) {
        if (this.moduleStateInitializer == null) {
            this.moduleStateInitializer = new GoloFunction("<clinit>", GoloFunction.Visibility.PUBLIC, GoloFunction.Scope.MODULE);
            this.moduleStateInitializer.setBlock(new Block(table));
            this.functions.add(this.moduleStateInitializer);
        }
        this.moduleStateInitializer.getBlock().addStatement(assignment);
    }

    public PackageAndClass getPackageAndClass() {
        return this.packageAndClass;
    }

    public Set<ModuleImport> getImports() {
        return Collections.unmodifiableSet(this.imports);
    }

    public Map<String, Set<GoloFunction>> getAugmentations() {
        return Collections.unmodifiableMap(this.augmentations);
    }

    public Set<Struct> getStructs() {
        return Collections.unmodifiableSet(this.structs);
    }

    public Set<LocalReference> getModuleState() {
        return Collections.unmodifiableSet(this.moduleState);
    }

    public void addImport(ModuleImport moduleImport) {
        this.imports.add(moduleImport);
    }

    public void addFunction(GoloFunction function) {
        this.functions.add(function);
    }

    public void addAugmentation(String target, GoloFunction function) {
        Set<Object> bag;
        if (!this.augmentations.containsKey(target)) {
            bag = new HashSet();
            this.augmentations.put(target, bag);
        } else {
            bag = this.augmentations.get(target);
        }
        bag.add(function);
    }

    public void addStruct(Struct struct) {
        this.structs.add(struct);
    }

    public void addLocalState(LocalReference reference) {
        this.moduleState.add(reference);
    }

    public Set<GoloFunction> getFunctions() {
        return Collections.unmodifiableSet(this.functions);
    }

    public void accept(GoloIrVisitor visitor) {
        visitor.visitModule(this);
    }

    public void internStructAugmentations() {
        HashSet<String> structNames = new HashSet<String>();
        HashSet<String> trash = new HashSet<String>();
        for (Struct struct : this.structs) {
            structNames.add(struct.getPackageAndClass().className());
        }
        for (String augmentation : this.augmentations.keySet()) {
            if (!structNames.contains(augmentation)) continue;
            trash.add(augmentation);
        }
        for (String trashed : trash) {
            this.augmentations.put(this.packageAndClass + ".types." + trashed, this.augmentations.get(trashed));
            this.augmentations.remove(trashed);
        }
        structNames.clear();
    }
}

