/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler.ir;

import fr.insalyon.citi.golo.compiler.ir.LocalReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class ReferenceTable {
    private ReferenceTable parent;
    private final Map<String, LocalReference> table = new LinkedHashMap<String, LocalReference>();

    public ReferenceTable() {
        this(null);
    }

    private ReferenceTable(ReferenceTable parent) {
        this.parent = parent;
    }

    public ReferenceTable add(LocalReference reference) {
        this.table.put(reference.getName(), reference);
        return this;
    }

    public boolean hasReferenceFor(String name) {
        return this.table.containsKey(name) || this.parent != null && this.parent.hasReferenceFor(name);
    }

    public LocalReference get(String name) {
        LocalReference reference = this.table.get(name);
        if (reference != null) {
            return reference;
        }
        if (this.parent != null) {
            return this.parent.get(name);
        }
        return null;
    }

    public Set<String> ownedSymbols() {
        return Collections.unmodifiableSet(this.table.keySet());
    }

    public Collection<LocalReference> ownedReferences() {
        return Collections.unmodifiableCollection(this.table.values());
    }

    public void relink(ReferenceTable parent) {
        this.parent = parent;
    }

    public Set<String> symbols() {
        LinkedHashSet<String> localSymbols = new LinkedHashSet<String>(this.table.keySet());
        if (this.parent != null) {
            localSymbols.addAll(this.parent.symbols());
        }
        return localSymbols;
    }

    public Collection<LocalReference> references() {
        LinkedHashSet<LocalReference> localReferences = new LinkedHashSet<LocalReference>(this.table.values());
        if (this.parent != null) {
            for (LocalReference ref : this.parent.references()) {
                if (this.table.containsKey(ref.getName())) continue;
                localReferences.add(ref);
            }
        }
        return localReferences;
    }

    public ReferenceTable fork() {
        return new ReferenceTable(this);
    }

    public ReferenceTable flatDeepCopy(boolean turnIntoConstants) {
        ReferenceTable referenceTable = new ReferenceTable();
        Set<String> tableSymbols = this.ownedSymbols();
        for (LocalReference reference : this.references()) {
            String refName = reference.getName();
            if (turnIntoConstants && !tableSymbols.contains(refName)) {
                referenceTable.add(new LocalReference(LocalReference.Kind.CONSTANT, refName, reference.isSynthetic()));
                continue;
            }
            referenceTable.add(new LocalReference(reference.getKind(), refName, reference.isSynthetic()));
        }
        return referenceTable;
    }

    public void remove(String name) {
        this.table.remove(name);
    }
}

