/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.doc;

import fr.insalyon.citi.golo.compiler.parser.ASTAnonymousFunctionInvocation;
import fr.insalyon.citi.golo.compiler.parser.ASTAssignment;
import fr.insalyon.citi.golo.compiler.parser.ASTAssociativeExpression;
import fr.insalyon.citi.golo.compiler.parser.ASTAugmentDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTBlock;
import fr.insalyon.citi.golo.compiler.parser.ASTBreak;
import fr.insalyon.citi.golo.compiler.parser.ASTCase;
import fr.insalyon.citi.golo.compiler.parser.ASTCollectionLiteral;
import fr.insalyon.citi.golo.compiler.parser.ASTCommutativeExpression;
import fr.insalyon.citi.golo.compiler.parser.ASTCompilationUnit;
import fr.insalyon.citi.golo.compiler.parser.ASTConditionalBranching;
import fr.insalyon.citi.golo.compiler.parser.ASTContinue;
import fr.insalyon.citi.golo.compiler.parser.ASTForEachLoop;
import fr.insalyon.citi.golo.compiler.parser.ASTForLoop;
import fr.insalyon.citi.golo.compiler.parser.ASTFunction;
import fr.insalyon.citi.golo.compiler.parser.ASTFunctionDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTFunctionInvocation;
import fr.insalyon.citi.golo.compiler.parser.ASTImportDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTLetOrVar;
import fr.insalyon.citi.golo.compiler.parser.ASTLiteral;
import fr.insalyon.citi.golo.compiler.parser.ASTMatch;
import fr.insalyon.citi.golo.compiler.parser.ASTMethodInvocation;
import fr.insalyon.citi.golo.compiler.parser.ASTModuleDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTReference;
import fr.insalyon.citi.golo.compiler.parser.ASTReturn;
import fr.insalyon.citi.golo.compiler.parser.ASTStructDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTThrow;
import fr.insalyon.citi.golo.compiler.parser.ASTToplevelDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTTryCatchFinally;
import fr.insalyon.citi.golo.compiler.parser.ASTUnaryExpression;
import fr.insalyon.citi.golo.compiler.parser.ASTWhileLoop;
import fr.insalyon.citi.golo.compiler.parser.ASTerror;
import fr.insalyon.citi.golo.compiler.parser.GoloParserVisitor;
import fr.insalyon.citi.golo.compiler.parser.SimpleNode;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;

class ModuleDocumentation {
    private String moduleName;
    private String moduleDocumentation;
    private TreeSet<FunctionDocumentation> functions = new TreeSet();
    private final TreeMap<String, String> augmentations = new TreeMap();
    private final TreeMap<String, TreeSet<FunctionDocumentation>> augmentationFunctions = new TreeMap();
    private final TreeMap<String, String> structs = new TreeMap();
    private final TreeMap<String, LinkedHashSet<String>> structMembers = new TreeMap();

    ModuleDocumentation(ASTCompilationUnit compilationUnit) {
        new ModuleVisitor().visit(compilationUnit, null);
    }

    public TreeMap<String, TreeSet<FunctionDocumentation>> augmentationFunctions() {
        return this.augmentationFunctions;
    }

    public TreeMap<String, String> structs() {
        return this.structs;
    }

    public TreeMap<String, LinkedHashSet<String>> structMembers() {
        return this.structMembers;
    }

    public TreeSet<FunctionDocumentation> functions() {
        return this.functions;
    }

    public String moduleName() {
        return this.moduleName;
    }

    public String moduleDocumentation() {
        return this.moduleDocumentation;
    }

    public TreeMap<String, String> augmentations() {
        return this.augmentations;
    }

    private String documentationOrNothing(String documentation) {
        return documentation != null ? documentation : "\n";
    }

    private class ModuleVisitor
    implements GoloParserVisitor {
        private String currentAugmentation = null;
        private FunctionDocumentation currentFunctionDocumentation = null;

        private ModuleVisitor() {
        }

        @Override
        public Object visit(SimpleNode node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTerror node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTCompilationUnit node, Object data) {
            node.childrenAccept(this, data);
            return data;
        }

        @Override
        public Object visit(ASTModuleDeclaration node, Object data) {
            ModuleDocumentation.this.moduleName = node.getName();
            ModuleDocumentation.this.moduleDocumentation = ModuleDocumentation.this.documentationOrNothing(node.getDocumentation());
            return data;
        }

        @Override
        public Object visit(ASTImportDeclaration node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTToplevelDeclaration node, Object data) {
            node.childrenAccept(this, data);
            return data;
        }

        @Override
        public Object visit(ASTStructDeclaration node, Object data) {
            ModuleDocumentation.this.structs.put(node.getName(), ModuleDocumentation.this.documentationOrNothing(node.getDocumentation()));
            ModuleDocumentation.this.structMembers.put(node.getName(), node.getMembers());
            return data;
        }

        @Override
        public Object visit(ASTAugmentDeclaration node, Object data) {
            this.currentAugmentation = node.getName();
            ModuleDocumentation.this.augmentations.put(node.getName(), ModuleDocumentation.this.documentationOrNothing(node.getDocumentation()));
            ModuleDocumentation.this.augmentationFunctions.put(node.getName(), new TreeSet());
            node.childrenAccept(this, data);
            this.currentAugmentation = null;
            return data;
        }

        @Override
        public Object visit(ASTFunctionDeclaration node, Object data) {
            if (node.isLocal()) {
                return data;
            }
            this.currentFunctionDocumentation = new FunctionDocumentation();
            this.currentFunctionDocumentation.name = node.getName();
            this.currentFunctionDocumentation.documentation = ModuleDocumentation.this.documentationOrNothing(node.getDocumentation());
            this.currentFunctionDocumentation.augmentation = node.isAugmentation();
            node.childrenAccept(this, data);
            return data;
        }

        @Override
        public Object visit(ASTContinue node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTBreak node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTThrow node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTWhileLoop node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTForLoop node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTForEachLoop node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTTryCatchFinally node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTUnaryExpression node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTCommutativeExpression node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTAssociativeExpression node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTMethodInvocation node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTBlock node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTFunction node, Object data) {
            if (this.currentFunctionDocumentation != null) {
                this.currentFunctionDocumentation.arguments = node.getArguments();
                if (this.currentFunctionDocumentation.augmentation) {
                    ((TreeSet)ModuleDocumentation.this.augmentationFunctions.get(this.currentAugmentation)).add(this.currentFunctionDocumentation);
                } else {
                    ModuleDocumentation.this.functions.add(this.currentFunctionDocumentation);
                }
                this.currentFunctionDocumentation.varargs = node.isVarargs();
                this.currentFunctionDocumentation = null;
            }
            return data;
        }

        @Override
        public Object visit(ASTLiteral node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTCollectionLiteral node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTReference node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTLetOrVar node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTAssignment node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTReturn node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTAnonymousFunctionInvocation node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTFunctionInvocation node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTConditionalBranching node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTCase node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTMatch node, Object data) {
            return data;
        }
    }

    static class FunctionDocumentation
    implements Comparable<FunctionDocumentation> {
        public String name;
        public String documentation;
        public List<String> arguments;
        public boolean augmentation;
        public boolean varargs;

        FunctionDocumentation() {
        }

        @Override
        public int compareTo(FunctionDocumentation o) {
            int c = this.name.compareTo(o.name);
            if (c == 0) {
                return this.arguments.size() < this.arguments.size() ? -1 : 1;
            }
            return c;
        }
    }
}

