/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.runtime;

import fr.insalyon.citi.golo.runtime.FunctionCallSupport;
import fr.insalyon.citi.golo.runtime.Module;
import fr.insalyon.citi.golo.runtime.PrimitiveArrayIterator;
import fr.insalyon.citi.golo.runtime.TypeMatching;
import gololang.DynamicObject;
import gololang.GoloStruct;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;

public class MethodInvocationSupport {
    private static final MethodHandle CLASS_GUARD;
    private static final MethodHandle FALLBACK;
    private static final MethodHandle VTABLE_LOOKUP;
    private static final HashSet<String> DYNAMIC_OBJECT_RESERVED_METHOD_NAMES;

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type, int nullSafeGuarded) {
        InlineCache callSite = new InlineCache(caller, name, type, nullSafeGuarded != 0);
        MethodHandle fallbackHandle = FALLBACK.bindTo(callSite).asCollector(Object[].class, type.parameterCount()).asType(type);
        callSite.setTarget(fallbackHandle);
        return callSite;
    }

    public static boolean classGuard(Class<?> expected, Object receiver) {
        return receiver.getClass() == expected;
    }

    public static MethodHandle vtableLookup(InlineCache inlineCache, Object[] args) {
        Class<?> receiverClass = args[0].getClass();
        MethodHandle target = inlineCache.vtable.get(receiverClass);
        if (target == null) {
            target = MethodInvocationSupport.lookupTarget(receiverClass, inlineCache, args);
            inlineCache.vtable.put(receiverClass, target);
        }
        return target;
    }

    private static MethodHandle lookupTarget(Class<?> receiverClass, InlineCache inlineCache, Object[] args) {
        if (!MethodInvocationSupport.isCallOnDynamicObject(inlineCache, args[0])) {
            return MethodInvocationSupport.findTarget(receiverClass, inlineCache, args);
        }
        DynamicObject dynamicObject = (DynamicObject)args[0];
        return dynamicObject.invoker(inlineCache.name, inlineCache.type());
    }

    public static Object fallback(InlineCache inlineCache, Object[] args) throws Throwable {
        if (inlineCache.isMegaMorphic()) {
            return MethodInvocationSupport.installVTableDispatch(inlineCache, args);
        }
        if (args[0] == null) {
            if (MethodInvocationSupport.shouldReturnNull(inlineCache, args[0])) {
                return null;
            }
            throw new NullPointerException("On method: " + inlineCache.name + " " + inlineCache.type().dropParameterTypes(0, 1));
        }
        Class<?> receiverClass = args[0].getClass();
        MethodHandle target = MethodInvocationSupport.lookupTarget(receiverClass, inlineCache, args);
        MethodHandle guard = CLASS_GUARD.bindTo(receiverClass);
        MethodHandle fallback = inlineCache.getTarget();
        MethodHandle root = MethodHandles.guardWithTest(guard, target, fallback);
        if (inlineCache.nullSafeGuarded) {
            root = MethodInvocationSupport.makeNullSafeGuarded(root);
        }
        inlineCache.setTarget(root);
        ++inlineCache.depth;
        return target.invokeWithArguments(args);
    }

    private static MethodHandle makeNullSafeGuarded(MethodHandle root) {
        MethodHandle catchThenNull = MethodHandles.dropArguments(MethodHandles.constant(Object.class, null), 0, new Class[]{NullPointerException.class});
        root = MethodHandles.catchException(root, NullPointerException.class, catchThenNull);
        return root;
    }

    private static boolean shouldReturnNull(InlineCache inlineCache, Object arg) {
        return arg == null && inlineCache.nullSafeGuarded;
    }

    private static Object installVTableDispatch(InlineCache inlineCache, Object[] args) throws Throwable {
        if (inlineCache.vtable == null) {
            inlineCache.vtable = new WeakHashMap();
        }
        MethodHandle lookup = VTABLE_LOOKUP.bindTo(inlineCache).asCollector(Object[].class, args.length);
        MethodHandle exactInvoker = MethodHandles.exactInvoker(inlineCache.type());
        MethodHandle vtableTarget = MethodHandles.foldArguments(exactInvoker, lookup);
        if (inlineCache.nullSafeGuarded) {
            vtableTarget = MethodInvocationSupport.makeNullSafeGuarded(vtableTarget);
        }
        inlineCache.setTarget(vtableTarget);
        if (MethodInvocationSupport.shouldReturnNull(inlineCache, args[0])) {
            return null;
        }
        return vtableTarget.invokeWithArguments(args);
    }

    private static boolean isCallOnDynamicObject(InlineCache inlineCache, Object arg) {
        return arg instanceof DynamicObject && !DYNAMIC_OBJECT_RESERVED_METHOD_NAMES.contains(inlineCache.name);
    }

    private static MethodHandle findTarget(Class<?> receiverClass, InlineCache inlineCache, Object[] args) {
        MethodHandle target;
        boolean makeAccessible;
        MethodType type = inlineCache.type();
        boolean bl = makeAccessible = !Modifier.isPublic(receiverClass.getModifiers());
        if (receiverClass.isArray()) {
            return MethodInvocationSupport.findArraySpecialMethod(receiverClass, inlineCache, args, type);
        }
        Object searchResult = MethodInvocationSupport.findMethodOrField(receiverClass, inlineCache, type.parameterArray(), args);
        if (searchResult != null) {
            try {
                MethodHandle target2;
                if (searchResult.getClass() == Method.class) {
                    Method method = (Method)searchResult;
                    if (makeAccessible || MethodInvocationSupport.isValidPrivateStructAccess(args[0], method, inlineCache)) {
                        method.setAccessible(true);
                    }
                    target2 = method.isVarArgs() && TypeMatching.isLastArgumentAnArray(type.parameterCount(), args) ? inlineCache.callerLookup.unreflect(method).asFixedArity().asType(type) : inlineCache.callerLookup.unreflect(method).asType(type);
                    target2 = FunctionCallSupport.insertSAMFilter(target2, method.getParameterTypes(), 1);
                } else {
                    Field field = (Field)searchResult;
                    if (makeAccessible) {
                        field.setAccessible(true);
                    }
                    if (args.length == 1) {
                        target2 = inlineCache.callerLookup.unreflectGetter(field).asType(type);
                    } else {
                        target2 = inlineCache.callerLookup.unreflectSetter(field);
                        target2 = MethodHandles.filterReturnValue(target2, MethodHandles.constant(receiverClass, args[0])).asType(type);
                    }
                }
                return target2;
            }
            catch (IllegalAccessException ignored) {
                // empty catch block
            }
        }
        if ((target = MethodInvocationSupport.findInAugmentations(receiverClass, inlineCache, args)) != null) {
            return target;
        }
        throw new NoSuchMethodError(receiverClass + "::" + inlineCache.name);
    }

    private static MethodHandle findArraySpecialMethod(Class<?> receiverClass, InlineCache inlineCache, Object[] args, MethodType type) {
        switch (inlineCache.name) {
            case "get": {
                if (args.length != 2) {
                    throw new UnsupportedOperationException("get on arrays takes 1 parameter");
                }
                return MethodHandles.arrayElementGetter(receiverClass).asType(type);
            }
            case "set": {
                if (args.length != 3) {
                    throw new UnsupportedOperationException("set on arrays takes 2 parameters");
                }
                return MethodHandles.arrayElementSetter(receiverClass).asType(type);
            }
            case "size": 
            case "length": {
                if (args.length != 1) {
                    throw new UnsupportedOperationException("length on arrays takes no parameters");
                }
                try {
                    return inlineCache.callerLookup.findStatic(Array.class, "getLength", MethodType.methodType(Integer.TYPE, Object.class)).asType(type);
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    throw new Error(e);
                }
            }
            case "iterator": {
                if (args.length != 1) {
                    throw new UnsupportedOperationException("iterator on arrays takes no parameters");
                }
                try {
                    return inlineCache.callerLookup.findConstructor(PrimitiveArrayIterator.class, MethodType.methodType(Void.TYPE, Object[].class)).asType(type);
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    throw new Error(e);
                }
            }
            case "toString": {
                if (args.length != 1) {
                    throw new UnsupportedOperationException("toString on arrays takes no parameters");
                }
                try {
                    return inlineCache.callerLookup.findStatic(Arrays.class, "toString", MethodType.methodType(String.class, Object[].class)).asType(type);
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    throw new Error(e);
                }
            }
            case "asList": {
                if (args.length != 1) {
                    throw new UnsupportedOperationException("toString on arrays takes no parameters");
                }
                try {
                    return inlineCache.callerLookup.findStatic(Arrays.class, "asList", MethodType.methodType(List.class, Object[].class)).asFixedArity().asType(type);
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    throw new Error(e);
                }
            }
            case "equals": {
                if (args.length != 2) {
                    throw new UnsupportedOperationException("toString on arrays takes 1 parameter");
                }
                try {
                    return inlineCache.callerLookup.findStatic(Arrays.class, "equals", MethodType.methodType(Boolean.TYPE, Object[].class, Object[].class)).asType(type);
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    throw new Error(e);
                }
            }
            case "getClass": {
                if (args.length != 1) {
                    throw new UnsupportedOperationException("getClass on arrays takes no parameters");
                }
                return MethodHandles.dropArguments(MethodHandles.constant(Class.class, receiverClass), 0, new Class[]{receiverClass}).asType(type);
            }
        }
        throw new UnsupportedOperationException(inlineCache.name + " is not supported on arrays");
    }

    private static boolean isValidPrivateStructAccess(Object receiver, Method method, InlineCache inlineCache) {
        if (!(receiver instanceof GoloStruct)) {
            return false;
        }
        String receiverClassName = receiver.getClass().getName();
        String callerClassName = inlineCache.callerLookup.lookupClass().getName();
        return method.getName().equals(inlineCache.name) && Modifier.isPrivate(Modifier.methodModifiers()) && (receiverClassName.startsWith(callerClassName) || callerClassName.equals(MethodInvocationSupport.reverseStructAugmentation(receiverClassName)));
    }

    private static String reverseStructAugmentation(String receiverClassName) {
        return receiverClassName.substring(0, receiverClassName.indexOf(".types")) + "$" + receiverClassName.replace('.', '$');
    }

    private static Object findMethodOrField(Class<?> receiverClass, InlineCache inlineCache, Class<?>[] argumentTypes, Object[] args) {
        LinkedList<Method> candidates = new LinkedList<Method>();
        HashSet methods = new HashSet();
        Collections.addAll(methods, receiverClass.getMethods());
        Collections.addAll(methods, receiverClass.getDeclaredMethods());
        for (Method method : methods) {
            if (MethodInvocationSupport.isCandidateMethod(inlineCache.name, method)) {
                candidates.add(method);
                continue;
            }
            if (!MethodInvocationSupport.isValidPrivateStructAccess(args[0], method, inlineCache)) continue;
            candidates.add(method);
        }
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        if (!candidates.isEmpty()) {
            for (Method method : candidates) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                Object[] argsWithoutReceiver = Arrays.copyOfRange(args, 1, args.length);
                if (!TypeMatching.haveSameNumberOfArguments(argsWithoutReceiver, parameterTypes) && !TypeMatching.haveEnoughArgumentsForVarargs(argsWithoutReceiver, method, parameterTypes) || !TypeMatching.canAssign(parameterTypes, argsWithoutReceiver, method.isVarArgs())) continue;
                return method;
            }
        }
        if (argumentTypes.length <= 2) {
            for (Field field : receiverClass.getDeclaredFields()) {
                if (!MethodInvocationSupport.isMatchingField(inlineCache.name, field)) continue;
                return field;
            }
            for (Field field : receiverClass.getFields()) {
                if (!MethodInvocationSupport.isMatchingField(inlineCache.name, field)) continue;
                return field;
            }
        }
        return null;
    }

    private static MethodHandle findInAugmentations(Class<?> receiverClass, InlineCache inlineCache, Object[] args) {
        Class<?> callerClass = inlineCache.callerLookup.lookupClass();
        String name = inlineCache.name;
        MethodType type = inlineCache.type();
        MethodHandles.Lookup lookup = inlineCache.callerLookup;
        int arity = inlineCache.type().parameterCount();
        ClassLoader classLoader = callerClass.getClassLoader();
        for (String augmentation : Module.augmentations(callerClass)) {
            try {
                Class<?> augmentedClass = classLoader.loadClass(augmentation);
                if (!augmentedClass.isAssignableFrom(receiverClass)) continue;
                Class<?> augmentClass = classLoader.loadClass(MethodInvocationSupport.augmentClassName(callerClass, augmentedClass));
                Method[] methodArray = augmentClass.getMethods();
                int n = methodArray.length;
                for (int i = 0; i < n; ++i) {
                    Method method = methodArray[i];
                    if (!MethodInvocationSupport.isCandidateMethod(name, method) || !MethodInvocationSupport.augmentMethodMatches(arity, method)) continue;
                    MethodHandle target = lookup.unreflect(method);
                    if (target.isVarargsCollector() && TypeMatching.isLastArgumentAnArray(arity, args)) {
                        return target.asFixedArity().asType(type);
                    }
                    return target.asType(type);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException ignored) {
                // empty catch block
            }
        }
        for (String importSymbol : Module.imports(callerClass)) {
            try {
                Class<?> importClass = classLoader.loadClass(importSymbol);
                for (String augmentation : Module.augmentations(importClass)) {
                    try {
                        Class<?> augmentedClass = classLoader.loadClass(augmentation);
                        if (!augmentedClass.isAssignableFrom(receiverClass)) continue;
                        Class<?> augmentClass = classLoader.loadClass(MethodInvocationSupport.augmentClassName(importClass, augmentedClass));
                        for (Method method : augmentClass.getMethods()) {
                            if (!MethodInvocationSupport.isCandidateMethod(name, method) || !MethodInvocationSupport.augmentMethodMatches(arity, method)) continue;
                            MethodHandle target = lookup.unreflect(method);
                            if (target.isVarargsCollector() && TypeMatching.isLastArgumentAnArray(arity, args)) {
                                return target.asFixedArity().asType(type);
                            }
                            return target.asType(type);
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException ignored) {
                        // empty catch block
                    }
                }
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean augmentMethodMatches(int arity, Method method) {
        int parameterCount = method.getParameterTypes().length;
        return parameterCount == arity || method.isVarArgs() && parameterCount <= arity;
    }

    private static String augmentClassName(Class<?> moduleClass, Class<?> augmentedClass) {
        return moduleClass.getName() + "$" + augmentedClass.getName().replace('.', '$');
    }

    private static boolean isMatchingField(String name, Field field) {
        return field.getName().equals(name) && !Modifier.isStatic(field.getModifiers());
    }

    private static boolean isCandidateMethod(String name, Method method) {
        return method.getName().equals(name) && Modifier.isPublic(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers());
    }

    static {
        DYNAMIC_OBJECT_RESERVED_METHOD_NAMES = new HashSet<String>(){
            {
                this.add("get");
                this.add("define");
                this.add("undefine");
                this.add("mixin");
                this.add("copy");
                this.add("freeze");
                this.add("properties");
                this.add("invoker");
                this.add("hasMethod");
                this.add("fallback");
            }
        };
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            CLASS_GUARD = lookup.findStatic(MethodInvocationSupport.class, "classGuard", MethodType.methodType(Boolean.TYPE, Class.class, Object.class));
            FALLBACK = lookup.findStatic(MethodInvocationSupport.class, "fallback", MethodType.methodType(Object.class, InlineCache.class, Object[].class));
            VTABLE_LOOKUP = lookup.findStatic(MethodInvocationSupport.class, "vtableLookup", MethodType.methodType(MethodHandle.class, InlineCache.class, Object[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error("Could not bootstrap the required method handles", e);
        }
    }

    static final class InlineCache
    extends MutableCallSite {
        static final int MEGAMORPHIC_THRESHOLD = 5;
        final MethodHandles.Lookup callerLookup;
        final String name;
        final boolean nullSafeGuarded;
        int depth = 0;
        WeakHashMap<Class, MethodHandle> vtable;

        InlineCache(MethodHandles.Lookup callerLookup, String name, MethodType type, boolean nullSafeGuarded) {
            super(type);
            this.callerLookup = callerLookup;
            this.name = name;
            this.nullSafeGuarded = nullSafeGuarded;
        }

        boolean isMegaMorphic() {
            return this.depth > 5;
        }
    }
}

