/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.runtime;

import fr.insalyon.citi.golo.runtime.Module;
import fr.insalyon.citi.golo.runtime.TypeMatching;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class FunctionCallSupport {
    private static final MethodHandle FALLBACK;
    private static final MethodHandle SAM_FILTER;

    public static Object samFilter(Class<?> type, Object value) {
        if (value instanceof MethodHandle) {
            return MethodHandleProxies.asInterfaceInstance(type, (MethodHandle)value);
        }
        return value;
    }

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type) throws IllegalAccessException, ClassNotFoundException {
        FunctionCallSite callSite = new FunctionCallSite(caller, name.replaceAll("#", "\\."), type);
        MethodHandle fallbackHandle = FALLBACK.bindTo(callSite).asCollector(Object[].class, type.parameterCount()).asType(type);
        callSite.setTarget(fallbackHandle);
        return callSite;
    }

    public static Object fallback(FunctionCallSite callSite, Object[] args) throws Throwable {
        String functionName = callSite.name;
        MethodType type = callSite.type();
        MethodHandles.Lookup caller = callSite.callerLookup;
        Class<?> callerClass = caller.lookupClass();
        MethodHandle handle = null;
        Object result = FunctionCallSupport.findStaticMethodOrField(callerClass, functionName, args);
        if (result == null) {
            result = FunctionCallSupport.findClassWithStaticMethodOrField(callerClass, functionName, args);
        }
        if (result == null) {
            result = FunctionCallSupport.findClassWithStaticMethodOrFieldFromImports(callerClass, functionName, args);
        }
        if (result == null) {
            result = FunctionCallSupport.findClassWithConstructor(callerClass, functionName, args);
        }
        if (result == null) {
            result = FunctionCallSupport.findClassWithConstructorFromImports(callerClass, functionName, args);
        }
        if (result == null) {
            throw new NoSuchMethodError(functionName);
        }
        Class[] types2 = null;
        if (result instanceof Method) {
            Method method = (Method)result;
            FunctionCallSupport.checkLocalFunctionCallFromSameModuleAugmentation(method, callerClass.getName());
            types2 = method.getParameterTypes();
            handle = method.isVarArgs() && TypeMatching.isLastArgumentAnArray(types2.length, args) ? caller.unreflect(method).asFixedArity().asType(type) : caller.unreflect(method).asType(type);
        } else if (result instanceof Constructor) {
            Constructor constructor = (Constructor)result;
            types2 = constructor.getParameterTypes();
            handle = constructor.isVarArgs() && TypeMatching.isLastArgumentAnArray(types2.length, args) ? caller.unreflectConstructor(constructor).asFixedArity().asType(type) : caller.unreflectConstructor(constructor).asType(type);
        } else {
            Field field = (Field)result;
            handle = caller.unreflectGetter(field).asType(type);
        }
        handle = FunctionCallSupport.insertSAMFilter(handle, types2, 0);
        callSite.setTarget(handle);
        return handle.invokeWithArguments(args);
    }

    public static MethodHandle insertSAMFilter(MethodHandle handle, Class[] types2, int startIndex) {
        if (types2 != null) {
            for (int i = 0; i < types2.length; ++i) {
                if (!TypeMatching.isSAM(types2[i])) continue;
                handle = MethodHandles.filterArguments(handle, startIndex + i, SAM_FILTER.bindTo(types2[i]));
            }
        }
        return handle;
    }

    private static void checkLocalFunctionCallFromSameModuleAugmentation(Method method, String callerClassName) {
        if (Modifier.isPrivate(method.getModifiers()) && callerClassName.contains("$")) {
            String prefix = callerClassName.substring(0, callerClassName.indexOf("$"));
            if (method.getDeclaringClass().getName().equals(prefix)) {
                method.setAccessible(true);
            }
        }
    }

    private static Object findClassWithConstructorFromImports(Class<?> callerClass, String classname, Object[] args) {
        String[] imports;
        for (String imported : imports = Module.imports(callerClass)) {
            Object result = FunctionCallSupport.findClassWithConstructor(callerClass, imported + "." + classname, args);
            if (result != null) {
                return result;
            }
            if (!imported.endsWith(classname) || (result = FunctionCallSupport.findClassWithConstructor(callerClass, imported, args)) == null) continue;
            return result;
        }
        return null;
    }

    private static Object findClassWithConstructor(Class<?> callerClass, String classname, Object[] args) {
        try {
            Class<?> targetClass = Class.forName(classname, true, callerClass.getClassLoader());
            for (Constructor<?> constructor : targetClass.getConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (!TypeMatching.haveSameNumberOfArguments(args, parameterTypes) && !TypeMatching.haveEnoughArgumentsForVarargs(args, constructor, parameterTypes) || !TypeMatching.canAssign(parameterTypes, args, constructor.isVarArgs())) continue;
                return constructor;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private static Object findClassWithStaticMethodOrFieldFromImports(Class<?> callerClass, String functionName, Object[] args) {
        String[] imports = Module.imports(callerClass);
        String[] classAndMethod = null;
        int classAndMethodSeparator = functionName.lastIndexOf(".");
        if (classAndMethodSeparator > 0) {
            classAndMethod = new String[]{functionName.substring(0, classAndMethodSeparator), functionName.substring(classAndMethodSeparator + 1)};
        }
        for (String importClassName : imports) {
            try {
                Class<?> importClass;
                try {
                    importClass = Class.forName(importClassName, true, callerClass.getClassLoader());
                }
                catch (ClassNotFoundException expected) {
                    if (classAndMethod == null) {
                        throw expected;
                    }
                    importClass = Class.forName(importClassName + "." + classAndMethod[0], true, callerClass.getClassLoader());
                }
                String lookup = classAndMethod == null ? functionName : classAndMethod[1];
                Object result = FunctionCallSupport.findStaticMethodOrField(importClass, lookup, args);
                if (result == null) continue;
                return result;
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    private static Object findClassWithStaticMethodOrField(Class<?> callerClass, String functionName, Object[] args) {
        int methodClassSeparatorIndex = functionName.lastIndexOf(".");
        if (methodClassSeparatorIndex >= 0) {
            String className = functionName.substring(0, methodClassSeparatorIndex);
            String methodName = functionName.substring(methodClassSeparatorIndex + 1);
            try {
                Class<?> targetClass = Class.forName(className, true, callerClass.getClassLoader());
                return FunctionCallSupport.findStaticMethodOrField(targetClass, methodName, args);
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    private static Object findStaticMethodOrField(Class<?> klass, String name, Object[] arguments) {
        for (Method method : klass.getDeclaredMethods()) {
            if (!FunctionCallSupport.methodMatches(name, arguments, method)) continue;
            return method;
        }
        for (Method method : klass.getMethods()) {
            if (!FunctionCallSupport.methodMatches(name, arguments, method)) continue;
            return method;
        }
        if (arguments.length == 0) {
            for (AccessibleObject accessibleObject : klass.getDeclaredFields()) {
                if (!FunctionCallSupport.fieldMatches(name, (Field)accessibleObject)) continue;
                return accessibleObject;
            }
            for (AccessibleObject accessibleObject : klass.getFields()) {
                if (!FunctionCallSupport.fieldMatches(name, (Field)accessibleObject)) continue;
                return accessibleObject;
            }
        }
        return null;
    }

    private static boolean methodMatches(String name, Object[] arguments, Method method) {
        Class<?>[] parameterTypes;
        return method.getName().equals(name) && Modifier.isStatic(method.getModifiers()) && (TypeMatching.haveSameNumberOfArguments(arguments, parameterTypes = method.getParameterTypes()) || TypeMatching.haveEnoughArgumentsForVarargs(arguments, method, parameterTypes)) && TypeMatching.canAssign(parameterTypes, arguments, method.isVarArgs());
    }

    private static boolean fieldMatches(String name, Field field) {
        return field.getName().equals(name) && Modifier.isStatic(field.getModifiers());
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            FALLBACK = lookup.findStatic(FunctionCallSupport.class, "fallback", MethodType.methodType(Object.class, FunctionCallSite.class, Object[].class));
            SAM_FILTER = lookup.findStatic(FunctionCallSupport.class, "samFilter", MethodType.methodType(Object.class, Class.class, Object.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error("Could not bootstrap the required method handles", e);
        }
    }

    static class FunctionCallSite
    extends MutableCallSite {
        final MethodHandles.Lookup callerLookup;
        final String name;

        FunctionCallSite(MethodHandles.Lookup callerLookup, String name, MethodType type) {
            super(type);
            this.callerLookup = callerLookup;
            this.name = name;
        }
    }
}

