/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import gololang.IntRange;
import gololang.LongRange;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedList;

public class Predefined {
    private Predefined() {
        throw new UnsupportedOperationException("Why on earth are you trying to instantiate this class?");
    }

    public static void raise(Object message) {
        Predefined.require(message instanceof String, "raise requires a message as a String");
        throw new RuntimeException((String)message);
    }

    public static void raise(Object message, Object cause) {
        Predefined.require(message instanceof String, "raise requires a message as a String");
        Predefined.require(cause instanceof Throwable, "raise requires a cause as a Throwable");
        throw new RuntimeException((String)message, (Throwable)cause);
    }

    public static void print(Object obj) {
        System.out.print(obj);
    }

    public static void println(Object obj) {
        System.out.println(obj);
    }

    public static String readln() throws IOException {
        return System.console().readLine();
    }

    public static String readln(String message) throws IOException {
        System.out.print(message);
        return Predefined.readln();
    }

    public static String readPassword() throws IOException {
        return String.valueOf(System.console().readPassword());
    }

    public static String readPassword(String message) throws IOException {
        System.out.print(message);
        return Predefined.readPassword();
    }

    public static char[] secureReadPassword() throws IOException {
        return System.console().readPassword();
    }

    public static char[] secureReadPassword(String message) throws IOException {
        System.out.print(message);
        return Predefined.secureReadPassword();
    }

    public static void requireNotNull(Object obj) throws AssertionError {
        if (obj != null) {
            return;
        }
        throw new AssertionError((Object)"null reference encountered");
    }

    public static void require(Object condition, Object errorMessage) throws IllegalArgumentException, AssertionError {
        Predefined.requireNotNull(condition);
        Predefined.requireNotNull(errorMessage);
        if (condition instanceof Boolean && errorMessage instanceof String) {
            if (((Boolean)condition).booleanValue()) {
                return;
            }
            throw new AssertionError(errorMessage);
        }
        throw new IllegalArgumentException("Wrong parameters for require: expected (Boolean, String) but got (" + condition.getClass().getName() + ", " + errorMessage.getClass().getName() + ")");
    }

    public static Object Array(Object ... values) {
        return values;
    }

    public static Object atoList(Object[] values) {
        return Arrays.asList(values);
    }

    public static Object aget(Object a, Object i) {
        Predefined.require(a instanceof Object[], "aget takes an Array as first parameter");
        Predefined.require(i instanceof Integer, "aget takes an index as second parameter");
        Object[] array = (Object[])a;
        return array[(Integer)i];
    }

    public static void aset(Object a, Object i, Object value) {
        Predefined.require(a instanceof Object[], "aset takes an Array as first parameter");
        Predefined.require(i instanceof Integer, "aset takes an index as second parameter");
        Object[] array = (Object[])a;
        array[((Integer)i).intValue()] = value;
    }

    public static Object alength(Object a) {
        Predefined.require(a instanceof Object[], "alength takes an Array as parameter");
        Object[] array = (Object[])a;
        return array.length;
    }

    public static Object range(Object from, Object to) {
        Predefined.require(from instanceof Integer || from instanceof Long, "from must either be an Integer or a Long");
        Predefined.require(to instanceof Integer || to instanceof Long, "to must either be an Integer or a Long");
        if (to instanceof Long && from instanceof Long) {
            return new LongRange((Long)from, (Long)to);
        }
        if (to instanceof Integer && from instanceof Integer) {
            return new IntRange((Integer)from, (Integer)to);
        }
        if (from instanceof Long) {
            return new LongRange((Long)from, ((Integer)to).intValue());
        }
        return new LongRange(((Integer)from).intValue(), (Long)to);
    }

    public static Object mapEntry(Object key, Object value) {
        return new AbstractMap.SimpleEntry<Object, Object>(key, value);
    }

    public static Object asInterfaceInstance(Object interfaceClass, Object target) {
        Predefined.require(interfaceClass instanceof Class, "interfaceClass must be a Class");
        Predefined.require(target instanceof MethodHandle, "target must be a MethodHandle");
        return MethodHandleProxies.asInterfaceInstance((Class)interfaceClass, (MethodHandle)target);
    }

    public static Object isClosure(Object object) {
        return object instanceof MethodHandle;
    }

    public static Object fun(Object name, Object module, Object arity) throws Throwable {
        Predefined.require(name instanceof String, "name must be a String");
        Predefined.require(module instanceof Class, "module must be a module (e.g., foo.bar.Some.module)");
        Predefined.require(arity instanceof Integer, "name must be an Integer");
        Class moduleClass = (Class)module;
        String functionName = (String)name;
        int functionArity = (Integer)arity;
        Method targetMethod = null;
        LinkedList<Method> candidates = new LinkedList<Method>(Arrays.asList(moduleClass.getDeclaredMethods()));
        candidates.addAll(Arrays.asList(moduleClass.getMethods()));
        for (Method method : candidates) {
            if (!method.getName().equals(functionName) || !Modifier.isStatic(method.getModifiers()) || functionArity >= 0 && method.getParameterTypes().length != functionArity) continue;
            targetMethod = method;
            break;
        }
        if (targetMethod != null) {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            targetMethod.setAccessible(true);
            return lookup.unreflect(targetMethod);
        }
        throw new NoSuchMethodException(name + " in " + module + (functionArity < 0 ? "" : " with arity " + functionArity));
    }

    public static Object fun(Object name, Object module) throws Throwable {
        return Predefined.fun(name, module, -1);
    }

    public static Object fileToText(Object file, Object encoding) throws Throwable {
        Path path = Predefined.pathFrom(file);
        Charset charset = null;
        if (encoding instanceof String) {
            charset = Charset.forName((String)encoding);
        } else if (encoding instanceof Charset) {
            charset = (Charset)encoding;
        } else {
            throw new IllegalArgumentException("encoding must be either a string or a charset instance");
        }
        return new String(Files.readAllBytes(path), charset);
    }

    private static Path pathFrom(Object file) {
        if (file instanceof String) {
            return Paths.get((String)file, new String[0]);
        }
        if (file instanceof File) {
            return ((File)file).toPath();
        }
        if (file instanceof Path) {
            return (Path)file;
        }
        throw new IllegalArgumentException("file must be a string, a file or a path");
    }

    public static void textToFile(Object text, Object file) throws Throwable {
        Predefined.require(text instanceof String, "text must be a string");
        String str = (String)text;
        Path path = Predefined.pathFrom(file);
        Files.write(path, str.getBytes(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static boolean fileExists(Object file) {
        return Files.exists(Predefined.pathFrom(file), new LinkOption[0]);
    }

    public static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    public static Class<?> objectArrayType() {
        return Object[].class;
    }

    public static Class<?> arrayTypeOf(Object klass) throws ClassNotFoundException {
        Predefined.require(klass instanceof Class, "klass must be a class");
        Class type = (Class)klass;
        return Class.forName("[L" + type.getName() + ";", true, type.getClassLoader());
    }
}

