/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import java.util.Arrays;
import java.util.Iterator;

public final class Tuple
implements Iterable<Object> {
    private final Object[] data;

    public Tuple(Object ... values) {
        this.data = Arrays.copyOf(values, values.length);
    }

    public static Tuple fromArray(Object[] values) {
        return new Tuple(values);
    }

    public int size() {
        return this.data.length;
    }

    public boolean isEmpty() {
        return this.data.length == 0;
    }

    public Object get(int index) {
        if (index < 0 || index >= this.data.length) {
            throw new IndexOutOfBoundsException(index + " is outside the bounds of a " + this.data.length + "-tuple");
        }
        return this.data[index];
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Tuple.this.data.length;
            }

            @Override
            public Object next() {
                Object result = Tuple.this.data[this.i];
                ++this.i;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Tuples are immutable");
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        return Arrays.equals(this.data, tuple.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        return "tuple" + Arrays.toString(this.data);
    }
}

