/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler.ir;

import fr.insalyon.citi.golo.compiler.ir.ConditionalBranching;
import fr.insalyon.citi.golo.compiler.ir.ExpressionStatement;
import fr.insalyon.citi.golo.compiler.ir.GoloIrVisitor;
import fr.insalyon.citi.golo.compiler.ir.GoloStatement;
import fr.insalyon.citi.golo.compiler.ir.ReferenceTable;
import fr.insalyon.citi.golo.compiler.ir.ReturnStatement;
import fr.insalyon.citi.golo.compiler.ir.ThrowStatement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class Block
extends ExpressionStatement {
    private final List<GoloStatement> statements = new LinkedList<GoloStatement>();
    private ReferenceTable referenceTable;
    private boolean hasReturn = false;

    public Block(ReferenceTable referenceTable) {
        this.referenceTable = referenceTable;
    }

    public ReferenceTable getReferenceTable() {
        return this.referenceTable;
    }

    public void internReferenceTable() {
        this.referenceTable = this.referenceTable.flatDeepCopy(true);
    }

    public List<GoloStatement> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    public void addStatement(GoloStatement statement) {
        this.statements.add(statement);
        this.checkForReturns(statement);
    }

    public void prependStatement(GoloStatement statement) {
        this.statements.add(0, statement);
        this.checkForReturns(statement);
    }

    private void checkForReturns(GoloStatement statement) {
        if (statement instanceof ReturnStatement || statement instanceof ThrowStatement) {
            this.hasReturn = true;
        } else if (statement instanceof ConditionalBranching) {
            this.hasReturn = this.hasReturn || ((ConditionalBranching)statement).returnsFromBothBranches();
        }
    }

    public boolean hasReturn() {
        return this.hasReturn;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitBlock(this);
    }
}

