/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler;

import fr.insalyon.citi.golo.compiler.utils.NamingUtils;

public final class PackageAndClass {
    private final String packageName;
    private final String className;

    public PackageAndClass(String packageName, String className) {
        this.packageName = packageName;
        this.className = className;
    }

    public static PackageAndClass fromString(String qualifiedName) {
        return new PackageAndClass(NamingUtils.extractTargetJavaPackage(qualifiedName), NamingUtils.extractTargetJavaClass(qualifiedName));
    }

    public String packageName() {
        return this.packageName;
    }

    public String className() {
        return this.className;
    }

    public String toString() {
        if (this.packageName.isEmpty()) {
            return this.className;
        }
        return this.packageName + "." + this.className;
    }

    public String toJVMType() {
        return this.toString().replaceAll("\\.", "/");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageAndClass that = (PackageAndClass)o;
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        return !(this.packageName != null ? !this.packageName.equals(that.packageName) : that.packageName != null);
    }

    public int hashCode() {
        int result = this.packageName != null ? this.packageName.hashCode() : 0;
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        return result;
    }
}

