/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.doc;

import fr.insalyon.citi.golo.doc.DocumentationElement;
import java.util.LinkedList;
import java.util.List;

class FunctionDocumentation
implements Comparable<FunctionDocumentation>,
DocumentationElement {
    private String name;
    private int line;
    private String documentation;
    private List<String> arguments = new LinkedList<String>();
    private boolean augmentation = false;
    private boolean varargs = false;
    private boolean local = false;

    FunctionDocumentation() {
    }

    @Override
    public String name() {
        return this.name;
    }

    public FunctionDocumentation name(String v) {
        this.name = v;
        return this;
    }

    @Override
    public String documentation() {
        return this.documentation != null ? this.documentation : "";
    }

    public FunctionDocumentation documentation(String v) {
        this.documentation = v;
        return this;
    }

    public List<String> arguments() {
        return this.arguments;
    }

    public String argument(int i) {
        return this.arguments.get(i);
    }

    public FunctionDocumentation arguments(List<String> v) {
        this.arguments.addAll(v);
        return this;
    }

    public int arity() {
        return this.arguments.size();
    }

    public boolean augmentation() {
        return this.augmentation;
    }

    public FunctionDocumentation augmentation(boolean v) {
        this.augmentation = v;
        return this;
    }

    public boolean varargs() {
        return this.varargs;
    }

    public FunctionDocumentation varargs(boolean v) {
        this.varargs = v;
        return this;
    }

    public boolean local() {
        return this.local;
    }

    public FunctionDocumentation local(boolean v) {
        this.local = v;
        return this;
    }

    @Override
    public int line() {
        return this.line;
    }

    public FunctionDocumentation line(int l) {
        this.line = l;
        return this;
    }

    @Override
    public int compareTo(FunctionDocumentation o) {
        int c = this.name.compareTo(o.name);
        if (c == 0) {
            return this.arity() < o.arity() ? -1 : 1;
        }
        return c;
    }
}

