/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.doc;

import fr.insalyon.citi.golo.compiler.parser.ASTAnonymousFunctionInvocation;
import fr.insalyon.citi.golo.compiler.parser.ASTAssignment;
import fr.insalyon.citi.golo.compiler.parser.ASTAssociativeExpression;
import fr.insalyon.citi.golo.compiler.parser.ASTAugmentDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTBlock;
import fr.insalyon.citi.golo.compiler.parser.ASTBreak;
import fr.insalyon.citi.golo.compiler.parser.ASTCase;
import fr.insalyon.citi.golo.compiler.parser.ASTCollectionLiteral;
import fr.insalyon.citi.golo.compiler.parser.ASTCommutativeExpression;
import fr.insalyon.citi.golo.compiler.parser.ASTCompilationUnit;
import fr.insalyon.citi.golo.compiler.parser.ASTConditionalBranching;
import fr.insalyon.citi.golo.compiler.parser.ASTContinue;
import fr.insalyon.citi.golo.compiler.parser.ASTDecoratorDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTForEachLoop;
import fr.insalyon.citi.golo.compiler.parser.ASTForLoop;
import fr.insalyon.citi.golo.compiler.parser.ASTFunction;
import fr.insalyon.citi.golo.compiler.parser.ASTFunctionDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTFunctionInvocation;
import fr.insalyon.citi.golo.compiler.parser.ASTImportDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTLetOrVar;
import fr.insalyon.citi.golo.compiler.parser.ASTLiteral;
import fr.insalyon.citi.golo.compiler.parser.ASTMatch;
import fr.insalyon.citi.golo.compiler.parser.ASTMethodInvocation;
import fr.insalyon.citi.golo.compiler.parser.ASTModuleDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTNamedAugmentationDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTReference;
import fr.insalyon.citi.golo.compiler.parser.ASTReturn;
import fr.insalyon.citi.golo.compiler.parser.ASTStructDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTThrow;
import fr.insalyon.citi.golo.compiler.parser.ASTToplevelDeclaration;
import fr.insalyon.citi.golo.compiler.parser.ASTTryCatchFinally;
import fr.insalyon.citi.golo.compiler.parser.ASTUnaryExpression;
import fr.insalyon.citi.golo.compiler.parser.ASTWhileLoop;
import fr.insalyon.citi.golo.compiler.parser.ASTerror;
import fr.insalyon.citi.golo.compiler.parser.GoloParserVisitor;
import fr.insalyon.citi.golo.compiler.parser.SimpleNode;
import fr.insalyon.citi.golo.doc.AugmentationDocumentation;
import fr.insalyon.citi.golo.doc.DocumentationElement;
import fr.insalyon.citi.golo.doc.FunctionDocumentation;
import fr.insalyon.citi.golo.doc.NamedAugmentationDocumentation;
import fr.insalyon.citi.golo.doc.StructDocumentation;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

class ModuleDocumentation
implements DocumentationElement {
    private String moduleName;
    private int moduleDefLine;
    private String moduleDocumentation;
    private final Map<String, Integer> imports = new TreeMap<String, Integer>();
    private final Map<String, Integer> moduleStates = new TreeMap<String, Integer>();
    private final SortedSet<FunctionDocumentation> functions = new TreeSet<FunctionDocumentation>();
    private final Map<String, AugmentationDocumentation> augmentations = new TreeMap<String, AugmentationDocumentation>();
    private final SortedSet<StructDocumentation> structs = new TreeSet<StructDocumentation>();
    private final Set<NamedAugmentationDocumentation> namedAugmentations = new TreeSet<NamedAugmentationDocumentation>();

    ModuleDocumentation(ASTCompilationUnit compilationUnit) {
        new ModuleVisitor().visit(compilationUnit, null);
    }

    public SortedSet<StructDocumentation> structs() {
        return this.structs;
    }

    public SortedSet<FunctionDocumentation> functions() {
        return this.functions(false);
    }

    public SortedSet<FunctionDocumentation> functions(boolean withLocal) {
        if (withLocal) {
            return this.functions;
        }
        TreeSet<FunctionDocumentation> pubFunctions = new TreeSet<FunctionDocumentation>();
        for (FunctionDocumentation f : this.functions) {
            if (f.local()) continue;
            pubFunctions.add(f);
        }
        return pubFunctions;
    }

    public String moduleName() {
        return this.moduleName;
    }

    @Override
    public String name() {
        return this.moduleName;
    }

    public int moduleDefLine() {
        return this.moduleDefLine;
    }

    @Override
    public int line() {
        return this.moduleDefLine;
    }

    public String moduleDocumentation() {
        return this.moduleDocumentation != null ? this.moduleDocumentation : "\n";
    }

    @Override
    public String documentation() {
        return this.moduleDocumentation();
    }

    public Map<String, Integer> moduleStates() {
        return this.moduleStates;
    }

    public Collection<AugmentationDocumentation> augmentations() {
        return this.augmentations.values();
    }

    public Collection<NamedAugmentationDocumentation> namedAugmentations() {
        return this.namedAugmentations;
    }

    public Map<String, Integer> imports() {
        return this.imports;
    }

    private class ModuleVisitor
    implements GoloParserVisitor {
        private Deque<Set<FunctionDocumentation>> functionContext = new LinkedList<Set<FunctionDocumentation>>();
        private FunctionDocumentation currentFunction = null;

        private ModuleVisitor() {
        }

        @Override
        public Object visit(ASTCompilationUnit node, Object data) {
            this.functionContext.push(ModuleDocumentation.this.functions);
            node.childrenAccept(this, data);
            return data;
        }

        @Override
        public Object visit(ASTModuleDeclaration node, Object data) {
            ModuleDocumentation.this.moduleName = node.getName();
            ModuleDocumentation.this.moduleDefLine = node.getLineInSourceCode();
            ModuleDocumentation.this.moduleDocumentation = node.getDocumentation();
            return data;
        }

        @Override
        public Object visit(ASTImportDeclaration node, Object data) {
            ModuleDocumentation.this.imports.put(node.getName(), node.getLineInSourceCode());
            return data;
        }

        @Override
        public Object visit(ASTToplevelDeclaration node, Object data) {
            node.childrenAccept(this, data);
            return data;
        }

        @Override
        public Object visit(ASTStructDeclaration node, Object data) {
            ModuleDocumentation.this.structs.add(new StructDocumentation().name(node.getName()).documentation(node.getDocumentation()).line(node.getLineInSourceCode()).members(node.getMembers()));
            return data;
        }

        @Override
        public Object visit(ASTAugmentDeclaration node, Object data) {
            String target = node.getName();
            if (!ModuleDocumentation.this.augmentations.containsKey(target)) {
                ModuleDocumentation.this.augmentations.put(target, new AugmentationDocumentation().target(target).augmentationNames(node.getAugmentationNames()).line(node.getLineInSourceCode()));
            }
            this.functionContext.push(((AugmentationDocumentation)ModuleDocumentation.this.augmentations.get(target)).documentation(node.getDocumentation()));
            node.childrenAccept(this, data);
            this.functionContext.pop();
            return data;
        }

        @Override
        public Object visit(ASTNamedAugmentationDeclaration node, Object data) {
            NamedAugmentationDocumentation augment = new NamedAugmentationDocumentation().name(node.getName()).documentation(node.getDocumentation()).line(node.getLineInSourceCode());
            ModuleDocumentation.this.namedAugmentations.add(augment);
            this.functionContext.push(augment);
            node.childrenAccept(this, data);
            this.functionContext.pop();
            return data;
        }

        @Override
        public Object visit(ASTFunctionDeclaration node, Object data) {
            this.currentFunction = new FunctionDocumentation().name(node.getName()).documentation(node.getDocumentation()).augmentation(node.isAugmentation()).line(node.getLineInSourceCode()).local(node.isLocal());
            this.functionContext.peek().add(this.currentFunction);
            node.childrenAccept(this, data);
            this.currentFunction = null;
            return data;
        }

        @Override
        public Object visit(ASTFunction node, Object data) {
            if (this.currentFunction != null) {
                this.currentFunction.arguments(node.getArguments()).varargs(node.isVarargs());
            }
            return data;
        }

        @Override
        public Object visit(ASTLetOrVar node, Object data) {
            if (node.isModuleState()) {
                ModuleDocumentation.this.moduleStates.put(node.getName(), node.getLineInSourceCode());
            }
            return data;
        }

        @Override
        public Object visit(ASTContinue node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTBreak node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTThrow node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTWhileLoop node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTForLoop node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTForEachLoop node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTTryCatchFinally node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTUnaryExpression node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTCommutativeExpression node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTAssociativeExpression node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTMethodInvocation node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTBlock node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTLiteral node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTCollectionLiteral node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTReference node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTAssignment node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTReturn node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTAnonymousFunctionInvocation node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTFunctionInvocation node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTConditionalBranching node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTCase node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTMatch node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTDecoratorDeclaration node, Object data) {
            return data;
        }

        @Override
        public Object visit(SimpleNode node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTerror node, Object data) {
            return data;
        }
    }
}

