/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.runtime;

import fr.insalyon.citi.golo.runtime.MethodFinder;
import fr.insalyon.citi.golo.runtime.MethodInvocationSupport;
import fr.insalyon.citi.golo.runtime.Module;
import fr.insalyon.citi.golo.runtime.TypeMatching;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class AugmentationMethodFinder
implements MethodFinder {
    private final Class<?> receiverClass;
    private final Class<?> callerClass;
    private final String methodName;
    private final int arity;
    private final MethodHandles.Lookup lookup;
    private final MethodType type;
    private final Object[] args;
    private final ClassLoader classLoader;
    private MethodHandle methodHandle;
    private final FindingStrategy[] strategies = new FindingStrategy[]{new SimpleAugmentationStrategy(), new NamedAugmentationStrategy(), new ExternalFQNAugmentationStrategy(), new ImportedExternalNamedAugmentationStrategy()};

    public AugmentationMethodFinder(MethodInvocationSupport.InlineCache inlineCache, Class<?> receiverClass, Object[] args) {
        this.receiverClass = receiverClass;
        this.args = args;
        this.methodName = inlineCache.name;
        this.lookup = inlineCache.callerLookup;
        this.type = inlineCache.type();
        this.arity = this.type.parameterCount();
        this.callerClass = inlineCache.callerLookup.lookupClass();
        this.classLoader = this.callerClass.getClassLoader();
        this.methodHandle = null;
    }

    private boolean isCandidate(Method method) {
        return method.getName().equals(this.methodName) && Modifier.isPublic(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers()) && this.matchesArity(method);
    }

    private boolean matchesArity(Method method) {
        int parameterCount = method.getParameterTypes().length;
        return parameterCount == this.arity || method.isVarArgs() && parameterCount <= this.arity;
    }

    private MethodHandle toMethodHandle(Method method) {
        try {
            MethodHandle target = this.lookup.unreflect(method);
            if (target.isVarargsCollector() && TypeMatching.isLastArgumentAnArray(this.arity, this.args)) {
                return target.asFixedArity().asType(this.type);
            }
            return target.asType(this.type);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private MethodHandle findMethod(String className) {
        try {
            Class<?> theClass = this.classLoader.loadClass(className);
            for (Method method : theClass.getMethods()) {
                if (!this.isCandidate(method)) continue;
                return this.toMethodHandle(method);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private void findInClasses(Class<?> definingModule, FindingStrategy strategy) {
        if (this.methodHandle != null) {
            return;
        }
        for (String target : strategy.targets(definingModule)) {
            try {
                Class<?> augmentedClass = this.classLoader.loadClass(target);
                if (augmentedClass.isAssignableFrom(this.receiverClass)) {
                    this.methodHandle = strategy.find(definingModule, augmentedClass);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (this.methodHandle != null) break;
        }
    }

    private void findInImportedClasses(Class<?> sourceClass, FindingStrategy strategy) {
        if (this.methodHandle != null) {
            return;
        }
        for (String importSymbol : Module.imports(sourceClass)) {
            try {
                Class<?> importedClass = this.classLoader.loadClass(importSymbol);
                this.findInClasses(importedClass, strategy);
                if (this.methodHandle == null) continue;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public MethodHandle find() {
        for (FindingStrategy strategie : this.strategies) {
            this.findInClasses(this.callerClass, strategie);
        }
        for (FindingStrategy strategie : this.strategies) {
            this.findInImportedClasses(this.callerClass, strategie);
        }
        return this.methodHandle;
    }

    private class ImportedExternalNamedAugmentationStrategy
    implements FindingStrategy {
        private ImportedExternalNamedAugmentationStrategy() {
        }

        @Override
        public MethodHandle find(Class<?> definingModule, Class<?> augmentedClass) {
            for (String augmentationName : Module.augmentationApplications(definingModule, augmentedClass)) {
                for (String importSymbol : Module.imports(definingModule)) {
                    MethodHandle method = AugmentationMethodFinder.this.findMethod(importSymbol + "$" + augmentationName);
                    if (method == null) continue;
                    return method;
                }
            }
            return null;
        }

        @Override
        public String[] targets(Class<?> definingModule) {
            return Module.augmentationApplications(definingModule);
        }
    }

    private class ExternalFQNAugmentationStrategy
    extends NamedAugmentationStrategy {
        private ExternalFQNAugmentationStrategy() {
        }

        @Override
        protected String augmentationClassName(Class<?> definingModule, String augmentationName) {
            int idx = augmentationName.lastIndexOf(".");
            if (idx == -1) {
                return augmentationName;
            }
            return new StringBuilder(augmentationName).replace(idx, idx + 1, "$").toString();
        }
    }

    private class NamedAugmentationStrategy
    implements FindingStrategy {
        private NamedAugmentationStrategy() {
        }

        protected String augmentationClassName(Class<?> definingModule, String augmentationName) {
            return definingModule.getName() + "$" + augmentationName;
        }

        @Override
        public MethodHandle find(Class<?> definingModule, Class<?> augmentedClass) {
            for (String augmentationName : Module.augmentationApplications(definingModule, augmentedClass)) {
                MethodHandle method = AugmentationMethodFinder.this.findMethod(this.augmentationClassName(definingModule, augmentationName));
                if (method == null) continue;
                return method;
            }
            return null;
        }

        @Override
        public String[] targets(Class<?> definingModule) {
            return Module.augmentationApplications(definingModule);
        }
    }

    private class SimpleAugmentationStrategy
    implements FindingStrategy {
        private SimpleAugmentationStrategy() {
        }

        private String className(Class<?> moduleClass, Class<?> augmentedClass) {
            return moduleClass.getName() + "$" + augmentedClass.getName().replace('.', '$');
        }

        @Override
        public MethodHandle find(Class<?> definingModule, Class<?> augmentedClass) {
            return AugmentationMethodFinder.this.findMethod(this.className(definingModule, augmentedClass));
        }

        @Override
        public String[] targets(Class<?> definingModule) {
            return Module.augmentations(definingModule);
        }
    }

    static interface FindingStrategy {
        public MethodHandle find(Class<?> var1, Class<?> var2);

        public String[] targets(Class<?> var1);
    }
}

