/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import gololang.AbstractRange;
import gololang.Range;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class LongRange
extends AbstractRange<Long> {
    public LongRange(long from, long to) {
        super(from, to);
    }

    public LongRange(long to) {
        super(to);
    }

    @Override
    Long defaultValue() {
        return 0L;
    }

    @Override
    public Range<Long> reversed() {
        return new LongRange((Long)this.to(), (Long)this.from()).decrementBy(this.increment());
    }

    @Override
    public int size() {
        if (this.to() == this.from()) {
            return 0;
        }
        int theSize = (int)(((Long)this.to() - (Long)this.from()) / (long)this.increment());
        if (theSize < 0) {
            return 0;
        }
        if (theSize == 0) {
            return 1;
        }
        return theSize;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Long)) {
            return false;
        }
        Long obj = (Long)o;
        return this.encloses(obj) && (obj - (Long)this.from()) % (long)this.increment() == 0L;
    }

    @Override
    public Range<Long> tail() {
        if (this.isEmpty()) {
            return this;
        }
        return new LongRange((Long)this.from() + (long)this.increment(), (Long)this.to()).incrementBy(this.increment());
    }

    @Override
    public Iterator<Long> iterator() {
        return new AbstractRange.RangeIterator(){
            private boolean started = false;
            private long current = (Long)LongRange.this.from();
            private long to = (Long)LongRange.this.to();

            @Override
            public boolean hasNext() {
                return Long.compare(this.to, this.current) * LongRange.this.cmp() > 0;
            }

            @Override
            public Long next() {
                long value = this.current;
                if (this.started) {
                    if (this.hasNext()) {
                        this.current += (long)LongRange.this.increment();
                        return value;
                    }
                    throw new NoSuchElementException("iteration has finished");
                }
                this.started = true;
                this.current += (long)LongRange.this.increment();
                return value;
            }
        };
    }
}

