# Contributing to Golo

Thank you for your interest in Golo!

## Legal considerations

If you are adding or modifying files you may add your own copyright line, but please ensure that the
form is consistent with the existing files, and please note that a INSA-Lyon copyright line must
appear in every copyright notice. All files are released under the terms of the *Apache Software
License, Version 2.0*.

Last but not least, you need to sign a
[contributor license agreement](http://golo-lang.org/legal/cla/)
before your contribution can be accepted into the project.

## Technical considerations

You can propose contributions by forking the GitHub reference repository and sending pull requests.
Do not make pull requests from your `master` branch, please use topic branches instead.

When submitting code, please make every effort to follow existing conventions and style in order to
keep the code as readable as possible.

Please provide meaningful commit messages. You can take inspiration from
http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html

A contribution is not a good contribution unless it comes with unit tests, integration tests and
documentation.

### Checklist when adding a core language feature

- Update the diagnose visitor (if applicable): ir and ast
- Update the golodoc visitors and templates (if applicable): ctags, html and
  markdown
- Update the main language documentation
- Add tests
- Add sample files
- Update the completion scripts (if applicable)
- Update highlighters and IDE plugins
