/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler;

import fr.insalyon.citi.golo.compiler.GoloCompilationException;
import fr.insalyon.citi.golo.compiler.ir.AssignmentStatement;
import fr.insalyon.citi.golo.compiler.ir.BinaryOperation;
import fr.insalyon.citi.golo.compiler.ir.Block;
import fr.insalyon.citi.golo.compiler.ir.ClosureReference;
import fr.insalyon.citi.golo.compiler.ir.CollectionLiteral;
import fr.insalyon.citi.golo.compiler.ir.ConditionalBranching;
import fr.insalyon.citi.golo.compiler.ir.ConstantStatement;
import fr.insalyon.citi.golo.compiler.ir.Decorator;
import fr.insalyon.citi.golo.compiler.ir.ExpressionStatement;
import fr.insalyon.citi.golo.compiler.ir.FunctionInvocation;
import fr.insalyon.citi.golo.compiler.ir.GoloFunction;
import fr.insalyon.citi.golo.compiler.ir.GoloIrVisitor;
import fr.insalyon.citi.golo.compiler.ir.GoloModule;
import fr.insalyon.citi.golo.compiler.ir.GoloStatement;
import fr.insalyon.citi.golo.compiler.ir.LocalReference;
import fr.insalyon.citi.golo.compiler.ir.LoopBreakFlowStatement;
import fr.insalyon.citi.golo.compiler.ir.LoopStatement;
import fr.insalyon.citi.golo.compiler.ir.MethodInvocation;
import fr.insalyon.citi.golo.compiler.ir.ReferenceLookup;
import fr.insalyon.citi.golo.compiler.ir.ReferenceTable;
import fr.insalyon.citi.golo.compiler.ir.ReturnStatement;
import fr.insalyon.citi.golo.compiler.ir.ThrowStatement;
import fr.insalyon.citi.golo.compiler.ir.TryCatchFinally;
import fr.insalyon.citi.golo.compiler.ir.UnaryOperation;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

class LocalReferenceAssignmentAndVerificationVisitor
implements GoloIrVisitor {
    private GoloModule module = null;
    private AssignmentCounter assignmentCounter = new AssignmentCounter();
    private Deque<GoloFunction> functionStack = new LinkedList<GoloFunction>();
    private Deque<ReferenceTable> tableStack = new LinkedList<ReferenceTable>();
    private Deque<Set<LocalReference>> assignmentStack = new LinkedList<Set<LocalReference>>();
    private Deque<LoopStatement> loopStack = new LinkedList<LoopStatement>();
    private GoloCompilationException.Builder exceptionBuilder;
    private final HashSet<LocalReference> uninitializedReferences = new HashSet();

    LocalReferenceAssignmentAndVerificationVisitor() {
    }

    public void setExceptionBuilder(GoloCompilationException.Builder builder) {
        this.exceptionBuilder = builder;
    }

    private GoloCompilationException.Builder getExceptionBuilder() {
        if (this.exceptionBuilder == null) {
            this.exceptionBuilder = new GoloCompilationException.Builder(this.module.getPackageAndClass().toString());
        }
        return this.exceptionBuilder;
    }

    @Override
    public void visitModule(GoloModule module) {
        this.module = module;
        for (GoloFunction goloFunction : module.getFunctions()) {
            goloFunction.accept(this);
        }
        for (Collection collection : module.getAugmentations().values()) {
            for (GoloFunction function : collection) {
                function.accept(this);
            }
        }
        for (Collection collection : module.getNamedAugmentations().values()) {
            for (GoloFunction function : collection) {
                function.accept(this);
            }
        }
    }

    @Override
    public void visitFunction(GoloFunction function) {
        this.assignmentCounter.reset();
        this.functionStack.push(function);
        ReferenceTable table = function.getBlock().getReferenceTable();
        for (String parameterName : function.getParameterNames()) {
            LocalReference reference = table.get(parameterName);
            this.uninitializedReferences.remove(reference);
            if (reference == null) {
                if (function.isSynthetic()) continue;
                throw new IllegalStateException("[please report this bug] " + parameterName + " is not declared in the references of function " + function.getName());
            }
            reference.setIndex(this.assignmentCounter.next());
        }
        function.getBlock().accept(this);
        String selfName = function.getSyntheticSelfName();
        if (function.isSynthetic() && selfName != null) {
            LocalReference self = function.getBlock().getReferenceTable().get(selfName);
            ClosureReference closureReference = new ClosureReference(function);
            for (String syntheticRef : function.getSyntheticParameterNames()) {
                closureReference.addCapturedReferenceName(syntheticRef);
            }
            AssignmentStatement assign = new AssignmentStatement(self, closureReference);
            function.getBlock().prependStatement(assign);
        }
        this.functionStack.pop();
    }

    @Override
    public void visitDecorator(Decorator decorator) {
        decorator.getExpressionStatement().accept(this);
    }

    @Override
    public void visitBlock(Block block) {
        ReferenceTable table = block.getReferenceTable();
        for (LocalReference reference : table.ownedReferences()) {
            if (reference.getIndex() >= 0 || this.isModuleState(reference)) continue;
            reference.setIndex(this.assignmentCounter.next());
            this.uninitializedReferences.add(reference);
        }
        this.tableStack.push(table);
        HashSet<LocalReference> assigned = new HashSet<LocalReference>();
        if (table == this.functionStack.peek().getBlock().getReferenceTable()) {
            for (String param : this.functionStack.peek().getParameterNames()) {
                assigned.add(table.get(param));
            }
        }
        if (!this.assignmentStack.isEmpty()) {
            assigned.addAll((Collection)this.assignmentStack.peek());
        }
        this.assignmentStack.push(assigned);
        for (GoloStatement statement : block.getStatements()) {
            statement.accept(this);
        }
        this.tableStack.pop();
        this.assignmentStack.pop();
    }

    private boolean isModuleState(LocalReference reference) {
        return reference.getKind().equals((Object)LocalReference.Kind.MODULE_VARIABLE) || reference.getKind().equals((Object)LocalReference.Kind.MODULE_CONSTANT);
    }

    @Override
    public void visitConstantStatement(ConstantStatement constantStatement) {
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) {
        returnStatement.getExpressionStatement().accept(this);
    }

    @Override
    public void visitFunctionInvocation(FunctionInvocation functionInvocation) {
        if (this.tableStack.peek().hasReferenceFor(functionInvocation.getName())) {
            if (this.tableStack.peek().get(functionInvocation.getName()).isModuleState()) {
                functionInvocation.setOnModuleState(true);
            } else {
                functionInvocation.setOnReference(true);
            }
        }
        for (ExpressionStatement argument : functionInvocation.getArguments()) {
            argument.accept(this);
        }
        for (FunctionInvocation invocation : functionInvocation.getAnonymousFunctionInvocations()) {
            invocation.accept(this);
        }
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        Set<LocalReference> assignedReferences;
        LocalReference reference = assignmentStatement.getLocalReference();
        if (this.assigningConstant(reference, assignedReferences = this.assignmentStack.peek())) {
            this.getExceptionBuilder().report(GoloCompilationException.Problem.Type.ASSIGN_CONSTANT, assignmentStatement.getASTNode(), "Assigning `" + reference.getName() + "` at " + assignmentStatement.getPositionInSourceCode() + " but it is a constant reference");
        } else if (this.redeclaringReferenceInBlock(assignmentStatement, reference, assignedReferences)) {
            this.getExceptionBuilder().report(GoloCompilationException.Problem.Type.REFERENCE_ALREADY_DECLARED_IN_BLOCK, assignmentStatement.getASTNode(), "Declaring a duplicate reference `" + reference.getName() + "` at " + assignmentStatement.getPositionInSourceCode());
        }
        assignedReferences.add(reference);
        assignmentStatement.getExpressionStatement().accept(this);
        if (assignmentStatement.isDeclaring() && !reference.isSynthetic()) {
            this.uninitializedReferences.remove(reference);
        }
    }

    private boolean redeclaringReferenceInBlock(AssignmentStatement assignmentStatement, LocalReference reference, Set<LocalReference> assignedReferences) {
        return !reference.isSynthetic() && assignmentStatement.isDeclaring() && this.referenceNameExists(reference, assignedReferences);
    }

    private boolean assigningConstant(LocalReference reference, Set<LocalReference> assignedReferences) {
        return reference.getKind().equals((Object)LocalReference.Kind.MODULE_CONSTANT) && !"<clinit>".equals(this.functionStack.peek().getName()) || this.isConstantReference(reference) && assignedReferences.contains(reference);
    }

    private boolean isConstantReference(LocalReference reference) {
        return reference.getKind().equals((Object)LocalReference.Kind.CONSTANT) || reference.getKind().equals((Object)LocalReference.Kind.MODULE_CONSTANT);
    }

    private boolean referenceNameExists(LocalReference reference, Set<LocalReference> referencesInBlock) {
        for (LocalReference ref : referencesInBlock) {
            if (ref == null || !ref.getName().equals(reference.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitReferenceLookup(ReferenceLookup referenceLookup) {
        LocalReference ref;
        ReferenceTable table = this.tableStack.peek();
        if (!table.hasReferenceFor(referenceLookup.getName())) {
            this.getExceptionBuilder().report(GoloCompilationException.Problem.Type.UNDECLARED_REFERENCE, referenceLookup.getASTNode(), "Undeclared reference `" + referenceLookup.getName() + "` at " + referenceLookup.getPositionInSourceCode());
        }
        if (this.isUninitialized(ref = referenceLookup.resolveIn(table))) {
            this.getExceptionBuilder().report(GoloCompilationException.Problem.Type.UNINITIALIZED_REFERENCE_ACCESS, referenceLookup.getASTNode(), "Uninitialized reference `" + ref.getName() + "` at " + referenceLookup.getPositionInSourceCode());
        }
    }

    private boolean isUninitialized(LocalReference ref) {
        return ref != null && !ref.isSynthetic() && !ref.isModuleState() && this.uninitializedReferences.contains(ref);
    }

    @Override
    public void visitConditionalBranching(ConditionalBranching conditionalBranching) {
        conditionalBranching.getCondition().accept(this);
        conditionalBranching.getTrueBlock().accept(this);
        if (conditionalBranching.hasFalseBlock()) {
            conditionalBranching.getFalseBlock().accept(this);
        } else if (conditionalBranching.hasElseConditionalBranching()) {
            conditionalBranching.getElseConditionalBranching().accept(this);
        }
    }

    @Override
    public void visitBinaryOperation(BinaryOperation binaryOperation) {
        binaryOperation.getLeftExpression().accept(this);
        binaryOperation.getRightExpression().accept(this);
    }

    @Override
    public void visitUnaryOperation(UnaryOperation unaryOperation) {
        unaryOperation.getExpressionStatement().accept(this);
    }

    @Override
    public void visitLoopStatement(LoopStatement loopStatement) {
        this.loopStack.push(loopStatement);
        if (loopStatement.hasInitStatement()) {
            loopStatement.getInitStatement().accept(this);
        }
        loopStatement.getConditionStatement().accept(this);
        loopStatement.getBlock().accept(this);
        if (loopStatement.hasPostStatement()) {
            loopStatement.getPostStatement().accept(this);
        }
        this.loopStack.pop();
    }

    @Override
    public void visitMethodInvocation(MethodInvocation methodInvocation) {
        for (ExpressionStatement argument : methodInvocation.getArguments()) {
            argument.accept(this);
        }
        for (FunctionInvocation invocation : methodInvocation.getAnonymousFunctionInvocations()) {
            invocation.accept(this);
        }
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) {
        throwStatement.getExpressionStatement().accept(this);
    }

    @Override
    public void visitTryCatchFinally(TryCatchFinally tryCatchFinally) {
        tryCatchFinally.getTryBlock().accept(this);
        if (tryCatchFinally.hasCatchBlock()) {
            tryCatchFinally.getCatchBlock().accept(this);
        }
        if (tryCatchFinally.hasFinallyBlock()) {
            tryCatchFinally.getFinallyBlock().accept(this);
        }
    }

    @Override
    public void visitClosureReference(ClosureReference closureReference) {
        GoloFunction target = closureReference.getTarget();
        for (String name : target.getSyntheticParameterNames()) {
            closureReference.addCapturedReferenceName(name);
        }
    }

    @Override
    public void visitLoopBreakFlowStatement(LoopBreakFlowStatement loopBreakFlowStatement) {
        if (this.loopStack.isEmpty()) {
            this.getExceptionBuilder().report(GoloCompilationException.Problem.Type.BREAK_OR_CONTINUE_OUTSIDE_LOOP, loopBreakFlowStatement.getASTNode(), "continue or break statement outside a loop at " + loopBreakFlowStatement.getPositionInSourceCode());
        } else {
            loopBreakFlowStatement.setEnclosingLoop(this.loopStack.peek());
        }
    }

    @Override
    public void visitCollectionLiteral(CollectionLiteral collectionLiteral) {
        for (ExpressionStatement statement : collectionLiteral.getExpressions()) {
            statement.accept(this);
        }
    }

    private static class AssignmentCounter {
        private int counter = 0;

        private AssignmentCounter() {
        }

        public int next() {
            int value = this.counter++;
            return value;
        }

        public void reset() {
            this.counter = 0;
        }
    }
}

