/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler.ir;

import fr.insalyon.citi.golo.compiler.ir.AssignmentStatement;
import fr.insalyon.citi.golo.compiler.ir.BinaryOperation;
import fr.insalyon.citi.golo.compiler.ir.Block;
import fr.insalyon.citi.golo.compiler.ir.ClosureReference;
import fr.insalyon.citi.golo.compiler.ir.CollectionLiteral;
import fr.insalyon.citi.golo.compiler.ir.ConditionalBranching;
import fr.insalyon.citi.golo.compiler.ir.ConstantStatement;
import fr.insalyon.citi.golo.compiler.ir.Decorator;
import fr.insalyon.citi.golo.compiler.ir.ExpressionStatement;
import fr.insalyon.citi.golo.compiler.ir.FunctionInvocation;
import fr.insalyon.citi.golo.compiler.ir.GoloFunction;
import fr.insalyon.citi.golo.compiler.ir.GoloIrVisitor;
import fr.insalyon.citi.golo.compiler.ir.GoloModule;
import fr.insalyon.citi.golo.compiler.ir.GoloStatement;
import fr.insalyon.citi.golo.compiler.ir.LocalReference;
import fr.insalyon.citi.golo.compiler.ir.LoopBreakFlowStatement;
import fr.insalyon.citi.golo.compiler.ir.LoopStatement;
import fr.insalyon.citi.golo.compiler.ir.MethodInvocation;
import fr.insalyon.citi.golo.compiler.ir.ReferenceLookup;
import fr.insalyon.citi.golo.compiler.ir.ReturnStatement;
import fr.insalyon.citi.golo.compiler.ir.Struct;
import fr.insalyon.citi.golo.compiler.ir.ThrowStatement;
import fr.insalyon.citi.golo.compiler.ir.TryCatchFinally;
import fr.insalyon.citi.golo.compiler.ir.UnaryOperation;
import java.util.Set;

public class IrTreeDumper
implements GoloIrVisitor {
    private int spacing = 0;

    private void space() {
        System.out.print("# ");
        for (int i = 0; i < this.spacing; ++i) {
            System.out.print(" ");
        }
    }

    private void incr() {
        this.spacing += 2;
    }

    private void decr() {
        this.spacing -= 2;
    }

    @Override
    public void visitModule(GoloModule module) {
        Set<GoloFunction> functions;
        this.space();
        System.out.println(module.getPackageAndClass());
        for (GoloFunction function : module.getFunctions()) {
            function.accept(this);
        }
        for (Struct struct : module.getStructs()) {
            this.incr();
            this.space();
            System.out.println("Struct " + struct.getPackageAndClass().className());
            this.space();
            System.out.println(" - target class = " + struct.getPackageAndClass());
            this.space();
            System.out.println(" - members = " + struct.getMembers());
            this.decr();
        }
        for (String augmentation : module.getAugmentations().keySet()) {
            this.incr();
            this.space();
            System.out.println("Augmentation " + augmentation);
            if (module.getAugmentationApplications().containsKey(augmentation)) {
                this.incr();
                for (String name : module.getAugmentationApplications().get(augmentation)) {
                    this.space();
                    System.out.println("Named Augmentation " + name);
                }
                this.decr();
            }
            functions = module.getAugmentations().get(augmentation);
            for (GoloFunction function : functions) {
                function.accept(this);
            }
            this.decr();
        }
        for (String augmentationName : module.getNamedAugmentations().keySet()) {
            this.incr();
            this.space();
            System.out.println("Named Augmentation " + augmentationName);
            functions = module.getNamedAugmentations().get(augmentationName);
            for (GoloFunction function : functions) {
                function.accept(this);
            }
            this.decr();
        }
    }

    @Override
    public void visitFunction(GoloFunction function) {
        for (Decorator decorator : function.getDecorators()) {
            decorator.accept(this);
        }
        this.incr();
        this.space();
        System.out.print("Function " + function.getName());
        System.out.print(" = |");
        boolean first = true;
        for (String param : function.getParameterNames()) {
            if (first) {
                first = false;
            } else {
                System.out.print(", ");
            }
            System.out.print(param);
        }
        System.out.print("|");
        if (function.isVarargs()) {
            System.out.print(" (varargs)");
        }
        if (function.isSynthetic()) {
            System.out.print(" (synthetic, " + function.getSyntheticParameterCount() + " synthetic parameters)");
            if (function.getSyntheticSelfName() != null) {
                System.out.print(" (selfname: " + function.getSyntheticSelfName() + ")");
            }
        }
        System.out.println();
        function.getBlock().accept(this);
        this.decr();
    }

    @Override
    public void visitDecorator(Decorator decorator) {
        this.incr();
        this.space();
        System.out.println("@Decorator");
        decorator.getExpressionStatement().accept(this);
        this.decr();
    }

    @Override
    public void visitBlock(Block block) {
        this.incr();
        this.space();
        System.out.println("Block");
        this.incr();
        for (LocalReference ref : block.getReferenceTable().references()) {
            this.space();
            System.out.println(" - " + ref);
        }
        this.decr();
        for (GoloStatement statement : block.getStatements()) {
            statement.accept(this);
        }
        this.decr();
    }

    @Override
    public void visitConstantStatement(ConstantStatement constantStatement) {
        this.incr();
        this.space();
        System.out.println("Constant = " + constantStatement.getValue());
        this.decr();
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) {
        this.incr();
        this.space();
        System.out.println("Return");
        returnStatement.getExpressionStatement().accept(this);
        this.decr();
    }

    @Override
    public void visitFunctionInvocation(FunctionInvocation functionInvocation) {
        this.incr();
        this.space();
        System.out.println("Function call: " + functionInvocation.getName() + ", on reference? -> " + functionInvocation.isOnReference() + ", on module state? -> " + functionInvocation.isOnModuleState() + ", anonymous? -> " + functionInvocation.isAnonymous());
        for (ExpressionStatement argument : functionInvocation.getArguments()) {
            this.space();
            argument.accept(this);
        }
        for (FunctionInvocation invocation : functionInvocation.getAnonymousFunctionInvocations()) {
            invocation.accept(this);
        }
        this.decr();
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        this.incr();
        this.space();
        System.out.println("Assignment: " + assignmentStatement.getLocalReference());
        assignmentStatement.getExpressionStatement().accept(this);
        this.decr();
    }

    @Override
    public void visitReferenceLookup(ReferenceLookup referenceLookup) {
        this.incr();
        this.space();
        System.out.println("Reference lookup: " + referenceLookup.getName());
        this.decr();
    }

    @Override
    public void visitConditionalBranching(ConditionalBranching conditionalBranching) {
        this.incr();
        this.space();
        System.out.println("Conditional");
        conditionalBranching.getCondition().accept(this);
        conditionalBranching.getTrueBlock().accept(this);
        if (conditionalBranching.hasFalseBlock()) {
            conditionalBranching.getFalseBlock().accept(this);
        } else if (conditionalBranching.hasElseConditionalBranching()) {
            conditionalBranching.getElseConditionalBranching().accept(this);
        }
        this.decr();
    }

    @Override
    public void visitBinaryOperation(BinaryOperation binaryOperation) {
        this.incr();
        this.space();
        System.out.println("Binary operator: " + (Object)((Object)binaryOperation.getType()));
        binaryOperation.getLeftExpression().accept(this);
        binaryOperation.getRightExpression().accept(this);
        this.decr();
    }

    @Override
    public void visitUnaryOperation(UnaryOperation unaryOperation) {
        this.incr();
        this.space();
        System.out.println("Unary operator: " + (Object)((Object)unaryOperation.getType()));
        unaryOperation.getExpressionStatement().accept(this);
        this.decr();
    }

    @Override
    public void visitLoopStatement(LoopStatement loopStatement) {
        this.incr();
        this.space();
        System.out.println("Loop");
        if (loopStatement.hasInitStatement()) {
            loopStatement.getInitStatement().accept(this);
        }
        loopStatement.getConditionStatement().accept(this);
        loopStatement.getBlock().accept(this);
        if (loopStatement.hasPostStatement()) {
            loopStatement.getPostStatement().accept(this);
        }
        this.decr();
    }

    @Override
    public void visitMethodInvocation(MethodInvocation methodInvocation) {
        this.incr();
        this.space();
        System.out.println("Method invocation: " + methodInvocation.getName() + ", null safe? -> " + methodInvocation.isNullSafeGuarded());
        for (ExpressionStatement argument : methodInvocation.getArguments()) {
            argument.accept(this);
        }
        for (FunctionInvocation invocation : methodInvocation.getAnonymousFunctionInvocations()) {
            invocation.accept(this);
        }
        this.decr();
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) {
        this.incr();
        this.space();
        System.out.println("Throw");
        throwStatement.getExpressionStatement().accept(this);
        this.decr();
    }

    @Override
    public void visitTryCatchFinally(TryCatchFinally tryCatchFinally) {
        this.incr();
        this.space();
        System.out.println("Try");
        tryCatchFinally.getTryBlock().accept(this);
        if (tryCatchFinally.hasCatchBlock()) {
            this.space();
            System.out.println("Catch: " + tryCatchFinally.getExceptionId());
            tryCatchFinally.getCatchBlock().accept(this);
        }
        if (tryCatchFinally.hasFinallyBlock()) {
            this.space();
            System.out.println("Finally");
            tryCatchFinally.getFinallyBlock().accept(this);
        }
        this.decr();
    }

    @Override
    public void visitClosureReference(ClosureReference closureReference) {
        this.incr();
        this.space();
        System.out.printf("Closure reference: %s, regular arguments at index %d%n", closureReference.getTarget().getName(), closureReference.getTarget().getSyntheticParameterCount());
        this.incr();
        for (String refName : closureReference.getCapturedReferenceNames()) {
            this.space();
            System.out.println("- capture: " + refName);
        }
        this.decr();
        this.decr();
    }

    @Override
    public void visitLoopBreakFlowStatement(LoopBreakFlowStatement loopBreakFlowStatement) {
        this.incr();
        this.space();
        System.out.println("Loop break flow: " + loopBreakFlowStatement.getType().name());
        this.decr();
    }

    @Override
    public void visitCollectionLiteral(CollectionLiteral collectionLiteral) {
        this.incr();
        this.space();
        System.out.println("Collection literal of type: " + (Object)((Object)collectionLiteral.getType()));
        for (ExpressionStatement statement : collectionLiteral.getExpressions()) {
            statement.accept(this);
        }
        this.decr();
    }
}

