/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.doc;

import fr.insalyon.citi.golo.compiler.parser.ASTCompilationUnit;
import fr.insalyon.citi.golo.doc.AbstractProcessor;
import fr.insalyon.citi.golo.doc.AugmentationDocumentation;
import fr.insalyon.citi.golo.doc.FunctionDocumentation;
import fr.insalyon.citi.golo.doc.ModuleDocumentation;
import fr.insalyon.citi.golo.doc.NamedAugmentationDocumentation;
import fr.insalyon.citi.golo.doc.StructDocumentation;
import gololang.Predefined;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class CtagsProcessor
extends AbstractProcessor {
    private final LinkedList<String> ctags = new LinkedList();
    private String file = "file";

    private void ctagsLine(String name, String address, String field) {
        this.ctags.add(String.format("%s\t%s\t%s;\"\t%s\tlanguage:golo\n", name, this.file, address, field));
    }

    private void ctagsModule(ModuleDocumentation module) {
        this.ctagsLine(module.moduleName(), "/^module[:blank:]+" + module.moduleName().replace(".", "\\.") + "$/", "p\tline:" + module.moduleDefLine());
    }

    private void ctagsFunction(FunctionDocumentation funct) {
        this.ctagsFunction(funct, "", false);
    }

    private void ctagsFunction(FunctionDocumentation funct, String parent, boolean named) {
        String address = String.format("/function[:blank:]+%s[:blank:]+=/", funct.name());
        StringBuilder signature = new StringBuilder("\tsignature:(");
        if (funct.arity() > 0) {
            signature.append(funct.argument(0));
            for (int i = 1; i < funct.arity(); ++i) {
                signature.append(", ").append(funct.argument(i));
            }
            if (funct.varargs()) {
                signature.append("...");
            }
        }
        signature.append(")");
        StringBuilder fields = new StringBuilder("f");
        fields.append("\tline:").append(funct.line());
        if (funct.local()) {
            fields.append("\taccess:private\tfile:");
        } else {
            fields.append("\taccess:public");
        }
        fields.append((CharSequence)signature);
        if (parent != "") {
            if (named) {
                fields.append("\taugmentation:").append(parent);
            } else {
                fields.append("\taugment:").append(parent);
            }
        }
        this.ctagsLine(funct.name(), address, fields.toString());
    }

    private void ctagsAugment(String name, int line) {
        this.ctagsLine(name, String.format("/^augment[:blank:]+%s/", name.replace(".", "\\.")), String.format("a\tline:%s", line));
    }

    private void ctagsAugmentation(String name, int line) {
        this.ctagsLine(name, String.format("/^augmentation[:blank:]+%s[:blank:]+=[:blank:]+{/", name), String.format("na\tline:%s", line));
    }

    private void ctagsStruct(String name, int line) {
        this.ctagsLine(name, String.format("/^struct[:blank:]+%s[:blank:]+=/", name), String.format("s\tline:%s", line));
    }

    private void ctagsImport(String name, int line) {
        this.ctagsLine(name, String.format("/^import[:blank:]+%s/", name.replace(".", "\\.")), String.format("i\tline:%s", line));
    }

    private void ctagsModState(String name, int line) {
        this.ctagsLine(name, String.format("(let|var)[:blank:]+%s[:blank:]+=/", name), String.format("v\taccess:private\tfile:\tline:%s", line));
    }

    private void ctagsStructMember(String struct, String member, int line) {
        StringBuilder fields = new StringBuilder("m");
        fields.append("\tline:").append(line);
        if (member.charAt(0) == '_') {
            fields.append("\taccess:private");
        } else {
            fields.append("\taccess:public");
        }
        fields.append("\tstruct:").append(struct);
        this.ctagsLine(member, String.format("/struct[:blank:]+%s[:blank:]+=/", struct), fields.toString());
    }

    private String ctagsAsString() {
        Collections.sort(this.ctags);
        StringBuilder buffer = new StringBuilder();
        for (String line : this.ctags) {
            buffer.append(line);
        }
        return buffer.toString();
    }

    @Override
    public String render(ASTCompilationUnit compilationUnit) throws Throwable {
        ModuleDocumentation documentation = new ModuleDocumentation(compilationUnit);
        this.ctagsModule(documentation);
        for (Map.Entry<String, Integer> entry : documentation.imports().entrySet()) {
            this.ctagsImport(entry.getKey(), entry.getValue());
        }
        for (StructDocumentation structDocumentation : documentation.structs()) {
            this.ctagsStruct(structDocumentation.name(), structDocumentation.line());
            for (String member : structDocumentation.members()) {
                this.ctagsStructMember(structDocumentation.name(), member, structDocumentation.line());
            }
        }
        for (NamedAugmentationDocumentation namedAugmentationDocumentation : documentation.namedAugmentations()) {
            this.ctagsAugmentation(namedAugmentationDocumentation.name(), namedAugmentationDocumentation.line());
            for (FunctionDocumentation funct : namedAugmentationDocumentation.functions()) {
                this.ctagsFunction(funct, namedAugmentationDocumentation.name(), true);
            }
        }
        for (AugmentationDocumentation augmentationDocumentation : documentation.augmentations()) {
            this.ctagsAugment(augmentationDocumentation.target(), augmentationDocumentation.line());
            for (FunctionDocumentation funct : augmentationDocumentation.functions()) {
                this.ctagsFunction(funct, augmentationDocumentation.target(), false);
            }
        }
        for (Map.Entry entry : documentation.moduleStates().entrySet()) {
            this.ctagsModState((String)entry.getKey(), (Integer)entry.getValue());
        }
        for (FunctionDocumentation functionDocumentation : documentation.functions(true)) {
            this.ctagsFunction(functionDocumentation);
        }
        return this.ctagsAsString();
    }

    @Override
    public void process(Map<String, ASTCompilationUnit> units, Path targetFolder) throws Throwable {
        Path targetFile = null;
        if (targetFolder.toString().equals("-")) {
            targetFile = targetFolder;
        } else {
            this.ensureFolderExists(targetFolder);
            targetFile = targetFolder.resolve("tags");
        }
        this.ctags.clear();
        Iterator<String> iterator = units.keySet().iterator();
        while (iterator.hasNext()) {
            String src;
            this.file = src = iterator.next();
            this.render(units.get(src));
        }
        Predefined.textToFile(this.ctagsAsString(), targetFile);
    }
}

