/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.runtime;

import fr.insalyon.citi.golo.runtime.FunctionCallSupport;
import fr.insalyon.citi.golo.runtime.MethodFinder;
import fr.insalyon.citi.golo.runtime.MethodInvocationSupport;
import fr.insalyon.citi.golo.runtime.TypeMatching;
import gololang.GoloStruct;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

class RegularMethodFinder
implements MethodFinder {
    private final Object[] args;
    private final MethodType type;
    private final Class<?> receiverClass;
    private final String methodName;
    private final MethodHandles.Lookup lookup;
    private final boolean makeAccessible;
    private final int arity;

    public RegularMethodFinder(MethodInvocationSupport.InlineCache inlineCache, Class<?> receiverClass, Object[] args) {
        this.args = args;
        this.type = inlineCache.type();
        this.receiverClass = receiverClass;
        this.methodName = inlineCache.name;
        this.lookup = inlineCache.callerLookup;
        this.makeAccessible = !Modifier.isPublic(receiverClass.getModifiers());
        this.arity = this.type.parameterArray().length;
    }

    @Override
    public MethodHandle find() {
        try {
            MethodHandle target = this.findInMethods();
            if (target != null) {
                return target;
            }
            return this.findInFields();
        }
        catch (IllegalAccessException ignored) {
            return null;
        }
    }

    private MethodHandle toMethodHandle(Field field) throws IllegalAccessException {
        MethodHandle target = null;
        if (this.makeAccessible) {
            field.setAccessible(true);
        }
        if (this.args.length == 1) {
            target = this.lookup.unreflectGetter(field).asType(this.type);
        } else {
            target = this.lookup.unreflectSetter(field);
            target = MethodHandles.filterReturnValue(target, MethodHandles.constant(this.receiverClass, this.args[0])).asType(this.type);
        }
        return target;
    }

    private MethodHandle toMethodHandle(Method method) throws IllegalAccessException {
        MethodHandle target = null;
        if (this.makeAccessible || this.isValidPrivateStructAccess(method)) {
            method.setAccessible(true);
        }
        target = method.isVarArgs() && TypeMatching.isLastArgumentAnArray(this.type.parameterCount(), this.args) ? this.lookup.unreflect(method).asFixedArity().asType(this.type) : this.lookup.unreflect(method).asType(this.type);
        return FunctionCallSupport.insertSAMFilter(target, method.getParameterTypes(), 1);
    }

    private boolean isValidPrivateStructAccess(Method method) {
        Object receiver = this.args[0];
        if (!(receiver instanceof GoloStruct)) {
            return false;
        }
        String receiverClassName = receiver.getClass().getName();
        String callerClassName = this.lookup.lookupClass().getName();
        return method.getName().equals(this.methodName) && Modifier.isPrivate(Modifier.methodModifiers()) && (receiverClassName.startsWith(callerClassName) || callerClassName.equals(RegularMethodFinder.reverseStructAugmentation(receiverClassName)));
    }

    private static String reverseStructAugmentation(String receiverClassName) {
        return receiverClassName.substring(0, receiverClassName.indexOf(".types")) + "$" + receiverClassName.replace('.', '$');
    }

    private List<Method> getCandidates() {
        LinkedList<Method> candidates = new LinkedList<Method>();
        HashSet methods = new HashSet();
        Collections.addAll(methods, this.receiverClass.getMethods());
        Collections.addAll(methods, this.receiverClass.getDeclaredMethods());
        for (Method method : methods) {
            if (this.isCandidateMethod(method)) {
                candidates.add(method);
                continue;
            }
            if (!this.isValidPrivateStructAccess(method)) continue;
            candidates.add(method);
        }
        return candidates;
    }

    private MethodHandle findInMethods() throws IllegalAccessException {
        List<Method> candidates = this.getCandidates();
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return this.toMethodHandle(candidates.get(0));
        }
        for (Method method : candidates) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Object[] argsWithoutReceiver = Arrays.copyOfRange(this.args, 1, this.args.length);
            if (!TypeMatching.haveSameNumberOfArguments(argsWithoutReceiver, parameterTypes) && !TypeMatching.haveEnoughArgumentsForVarargs(argsWithoutReceiver, method, parameterTypes) || !TypeMatching.canAssign(parameterTypes, argsWithoutReceiver, method.isVarArgs())) continue;
            return this.toMethodHandle(method);
        }
        return null;
    }

    private MethodHandle findInFields() throws IllegalAccessException {
        if (this.arity > 3) {
            return null;
        }
        for (Field field : this.receiverClass.getDeclaredFields()) {
            if (!this.isMatchingField(field)) continue;
            return this.toMethodHandle(field);
        }
        for (Field field : this.receiverClass.getFields()) {
            if (!this.isMatchingField(field)) continue;
            return this.toMethodHandle(field);
        }
        return null;
    }

    private boolean isMatchingField(Field field) {
        return field.getName().equals(this.methodName) && !Modifier.isStatic(field.getModifiers());
    }

    private boolean isCandidateMethod(Method method) {
        return method.getName().equals(this.methodName) && Modifier.isPublic(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers());
    }
}

