/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class DynamicObject {
    private final HashMap<String, Object> properties = new HashMap();
    private boolean frozen = false;
    public static final MethodHandle DISPATCH_CALL;
    public static final MethodHandle DISPATCH_GET;
    public static final MethodHandle DISPATCH_SET;

    public DynamicObject define(String name, Object value) {
        this.frozenMutationCheck();
        this.properties.put(name, value);
        return this;
    }

    public Set<Map.Entry<String, Object>> properties() {
        return this.properties.entrySet();
    }

    public Object get(String name) {
        return this.properties.get(name);
    }

    public DynamicObject undefine(String name) {
        this.properties.remove(name);
        return this;
    }

    public DynamicObject copy() {
        DynamicObject copy = new DynamicObject();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            copy.properties.put(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public DynamicObject mixin(DynamicObject other) {
        this.frozenMutationCheck();
        for (Map.Entry<String, Object> entry : other.properties.entrySet()) {
            this.properties.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public DynamicObject freeze() {
        this.frozen = true;
        return this;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public static Object dispatchCall(String property, Object ... args) throws Throwable {
        DynamicObject obj = (DynamicObject)args[0];
        Object value = obj.properties.get(property);
        if (value != null) {
            if (value instanceof MethodHandle) {
                MethodHandle handle = (MethodHandle)value;
                if (handle.isVarargsCollector() && args[args.length - 1] instanceof Object[]) {
                    Object[] trailing = (Object[])args[args.length - 1];
                    Object[] spreadArgs = new Object[args.length + trailing.length - 1];
                    System.arraycopy(args, 0, spreadArgs, 0, args.length - 1);
                    System.arraycopy(trailing, 0, spreadArgs, args.length - 1, trailing.length);
                    return handle.invokeWithArguments(spreadArgs);
                }
                return handle.invokeWithArguments(args);
            }
            throw new UnsupportedOperationException("There is no dynamic object method defined for " + property);
        }
        if (obj.hasFallback()) {
            MethodHandle handle = (MethodHandle)obj.properties.get("fallback");
            Object[] fallback_args = new Object[args.length + 1];
            fallback_args[0] = obj;
            fallback_args[1] = property;
            System.arraycopy(args, 1, fallback_args, 2, args.length - 1);
            return handle.invokeWithArguments(fallback_args);
        }
        throw new UnsupportedOperationException("There is neither a dynamic object method defined for " + property + " nor a 'fallback' method");
    }

    public static Object dispatchGetterStyle(String property, DynamicObject object) throws Throwable {
        Object value = object.get(property);
        if (value != null || object.properties.containsKey(property)) {
            MethodHandle handle;
            if (value instanceof MethodHandle && ((handle = (MethodHandle)value).type().parameterCount() == 1 || handle.isVarargsCollector())) {
                return handle.invokeWithArguments(object);
            }
            return value;
        }
        if (object.hasFallback()) {
            MethodHandle handle = (MethodHandle)object.properties.get("fallback");
            return handle.invokeWithArguments(object, property);
        }
        return null;
    }

    public static Object dispatchSetterStyle(String property, DynamicObject object, Object arg) throws Throwable {
        MethodHandle handle;
        Object value = object.get(property);
        if ((value != null || object.properties.containsKey(property)) && value instanceof MethodHandle && (handle = (MethodHandle)value).type().parameterCount() == 2) {
            if (handle.isVarargsCollector() && arg instanceof Object[]) {
                return handle.invokeExact(object, (Object[])arg);
            }
            return handle.invokeWithArguments(object, arg);
        }
        return object.define(property, arg);
    }

    public MethodHandle invoker(String property, MethodType type) {
        switch (type.parameterCount()) {
            case 0: {
                throw new IllegalArgumentException("A dynamic object invoker type needs at least 1 argument (the receiver)");
            }
            case 1: {
                return DISPATCH_GET.bindTo(property).asType(MethodType.genericMethodType(1));
            }
            case 2: {
                return DISPATCH_SET.bindTo(property).asType(MethodType.genericMethodType(2));
            }
        }
        return DISPATCH_CALL.bindTo(property).asCollector(Object[].class, type.parameterCount());
    }

    public boolean hasMethod(String method) {
        Object obj = this.properties.get(method);
        if (obj != null) {
            return obj instanceof MethodHandle;
        }
        return false;
    }

    public DynamicObject fallback(Object value) {
        return this.define("fallback", value);
    }

    private boolean hasFallback() {
        return this.properties.containsKey("fallback");
    }

    private void frozenMutationCheck() {
        if (this.frozen) {
            throw new IllegalStateException("the object is frozen");
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            DISPATCH_CALL = lookup.findStatic(DynamicObject.class, "dispatchCall", MethodType.methodType(Object.class, String.class, Object[].class));
            DISPATCH_GET = lookup.findStatic(DynamicObject.class, "dispatchGetterStyle", MethodType.methodType(Object.class, String.class, DynamicObject.class));
            DISPATCH_SET = lookup.findStatic(DynamicObject.class, "dispatchSetterStyle", MethodType.methodType(Object.class, String.class, DynamicObject.class, Object.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            e.printStackTrace();
            throw new Error("Could not bootstrap the required method handles");
        }
    }
}

