/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler;

import fr.insalyon.citi.golo.compiler.parser.GoloASTNode;
import fr.insalyon.citi.golo.compiler.parser.ParseException;
import fr.insalyon.citi.golo.compiler.parser.Token;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class GoloCompilationException
extends RuntimeException {
    private final List<Problem> problems = new LinkedList<Problem>();
    private String sourceCode;

    public List<Problem> getProblems() {
        return Collections.unmodifiableList(this.problems);
    }

    private void report(Problem problem) {
        this.problems.add(problem);
    }

    private GoloCompilationException() {
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public GoloCompilationException(String message) {
        super(message);
    }

    public GoloCompilationException(Throwable throwable) {
        super(throwable);
    }

    public GoloCompilationException(String message, Throwable cause) {
        super(message, cause);
    }

    public static class Builder {
        private final GoloCompilationException exception;

        public Builder(String goloSourceFilename) {
            this.exception = new GoloCompilationException("In Golo module: " + goloSourceFilename);
            this.exception.setSourceCode(goloSourceFilename);
        }

        public Builder report(Problem.Type type, GoloASTNode source, String description) {
            this.exception.report(new Problem(type, source, description));
            return this;
        }

        public Builder report(ParseException pe, GoloASTNode source) {
            this.exception.report(new Problem(pe, source));
            return this;
        }

        public Builder report(UnsupportedCharsetException uce) {
            this.exception.report(new Problem(uce));
            return this;
        }

        public void doThrow() throws GoloCompilationException {
            throw this.exception;
        }

        public List<Problem> getProblems() {
            return this.exception.getProblems();
        }
    }

    public static class Problem {
        private final Type type;
        private final GoloASTNode source;
        private final Token firstToken;
        private final Token lastToken;
        private final String description;

        public Problem(Type type, GoloASTNode source, String description) {
            this.type = type;
            this.source = source;
            this.firstToken = source.jjtGetFirstToken();
            this.lastToken = source.jjtGetLastToken();
            this.description = description;
        }

        public Problem(Type type, GoloASTNode source, Token token, String description) {
            this.type = type;
            this.source = source;
            this.firstToken = token;
            this.lastToken = token;
            this.description = description;
        }

        public Problem(ParseException pe, GoloASTNode source) {
            this.type = Type.PARSING;
            this.source = source;
            this.firstToken = pe.currentToken;
            this.lastToken = pe.currentToken;
            this.description = pe.getMessage();
        }

        public Problem(UnsupportedCharsetException uce) {
            this.type = Type.INVALID_ENCODING;
            this.source = null;
            this.firstToken = null;
            this.lastToken = null;
            this.description = uce.getMessage();
        }

        public Type getType() {
            return this.type;
        }

        public GoloASTNode getSource() {
            return this.source;
        }

        public Token getFirstToken() {
            return this.firstToken;
        }

        public Token getLastToken() {
            return this.lastToken;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return "Problem{type=" + (Object)((Object)this.type) + ", source=" + this.source + ", description='" + this.description + '\'' + '}';
        }

        public static enum Type {
            PARSING,
            AUGMENT_FUNCTION_NO_ARGS,
            UNDECLARED_REFERENCE,
            ASSIGN_CONSTANT,
            BREAK_OR_CONTINUE_OUTSIDE_LOOP,
            REFERENCE_ALREADY_DECLARED_IN_BLOCK,
            UNINITIALIZED_REFERENCE_ACCESS,
            INVALID_ENCODING;

        }
    }
}

