/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler.ir;

import fr.insalyon.citi.golo.compiler.ir.Block;
import fr.insalyon.citi.golo.compiler.ir.GoloIrVisitor;
import fr.insalyon.citi.golo.compiler.ir.GoloStatement;

public class TryCatchFinally
extends GoloStatement {
    private final String exceptionId;
    private final Block tryBlock;
    private final Block catchBlock;
    private final Block finallyBlock;

    public TryCatchFinally(String exceptionId, Block tryBlock, Block catchBlock, Block finallyBlock) {
        this.exceptionId = exceptionId;
        this.tryBlock = tryBlock;
        this.catchBlock = catchBlock;
        this.finallyBlock = finallyBlock;
    }

    public String getExceptionId() {
        return this.exceptionId;
    }

    public Block getTryBlock() {
        return this.tryBlock;
    }

    public Block getCatchBlock() {
        return this.catchBlock;
    }

    public Block getFinallyBlock() {
        return this.finallyBlock;
    }

    public boolean hasFinallyBlock() {
        return this.finallyBlock != null;
    }

    public boolean hasCatchBlock() {
        return this.catchBlock != null;
    }

    public boolean isTryCatchFinally() {
        return this.hasCatchBlock() && this.hasFinallyBlock();
    }

    public boolean isTryCatch() {
        return this.hasCatchBlock() && !this.hasFinallyBlock();
    }

    public boolean isTryFinally() {
        return !this.hasCatchBlock() && this.hasFinallyBlock();
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitTryCatchFinally(this);
    }
}

