/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.runtime;

import fr.insalyon.citi.golo.runtime.ArrayHelper;
import fr.insalyon.citi.golo.runtime.MethodFinder;
import fr.insalyon.citi.golo.runtime.MethodInvocationSupport;
import fr.insalyon.citi.golo.runtime.PrimitiveArrayIterator;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;

class ArrayMethodFinder
implements MethodFinder {
    private final Class<?> receiverClass;
    private final Object[] args;
    private final MethodType type;
    private final int arity;
    private final String name;
    private final MethodHandles.Lookup lookup;

    public ArrayMethodFinder(MethodInvocationSupport.InlineCache inlineCache, Class<?> receiverClass, Object[] args) {
        this.args = args;
        this.receiverClass = receiverClass;
        this.type = inlineCache.type();
        this.arity = args.length - 1;
        this.name = inlineCache.name;
        this.lookup = inlineCache.callerLookup;
    }

    private void checkArity(int value) {
        if (this.arity != value) {
            throw new UnsupportedOperationException(this.name + " on arrays takes " + (value == 0 ? "no" : Integer.valueOf(value)) + " parameter" + (value > 1 ? "s" : ""));
        }
    }

    @Override
    public MethodHandle find() {
        try {
            return this.resolve().asType(this.type);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private MethodHandle resolve() throws NoSuchMethodException, IllegalAccessException {
        switch (this.name) {
            case "get": {
                this.checkArity(1);
                return MethodHandles.arrayElementGetter(this.receiverClass);
            }
            case "set": {
                this.checkArity(2);
                return MethodHandles.arrayElementSetter(this.receiverClass);
            }
            case "size": 
            case "length": {
                this.checkArity(0);
                return this.lookup.findStatic(Array.class, "getLength", MethodType.methodType(Integer.TYPE, Object.class));
            }
            case "iterator": {
                this.checkArity(0);
                return this.lookup.findConstructor(PrimitiveArrayIterator.class, MethodType.methodType(Void.TYPE, Object[].class));
            }
            case "toString": {
                this.checkArity(0);
                return this.lookup.findStatic(Arrays.class, "toString", MethodType.methodType(String.class, Object[].class));
            }
            case "asList": {
                this.checkArity(0);
                return this.lookup.findStatic(Arrays.class, "asList", MethodType.methodType(List.class, Object[].class)).asFixedArity();
            }
            case "equals": {
                this.checkArity(1);
                return this.lookup.findStatic(Arrays.class, "equals", MethodType.methodType(Boolean.TYPE, Object[].class, Object[].class));
            }
            case "getClass": {
                this.checkArity(0);
                return MethodHandles.dropArguments(MethodHandles.constant(Class.class, this.receiverClass), 0, new Class[]{this.receiverClass});
            }
            case "head": {
                this.checkArity(0);
                return this.lookup.findStatic(ArrayHelper.class, "head", MethodType.methodType(Object.class, Object[].class)).asType(this.type);
            }
            case "tail": {
                this.checkArity(0);
                return this.lookup.findStatic(ArrayHelper.class, "tail", MethodType.methodType(Object[].class, Object[].class)).asType(this.type);
            }
            case "isEmpty": {
                this.checkArity(0);
                return this.lookup.findStatic(ArrayHelper.class, "isEmpty", MethodType.methodType(Boolean.TYPE, Object[].class)).asType(this.type);
            }
        }
        throw new UnsupportedOperationException(this.name + " is not supported on arrays");
    }
}

