/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.runtime;

import fr.insalyon.citi.golo.runtime.ArrayMethodFinder;
import fr.insalyon.citi.golo.runtime.AugmentationMethodFinder;
import fr.insalyon.citi.golo.runtime.RegularMethodFinder;
import gololang.DynamicObject;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.util.HashSet;
import java.util.WeakHashMap;

public class MethodInvocationSupport {
    private static final MethodHandle CLASS_GUARD;
    private static final MethodHandle FALLBACK;
    private static final MethodHandle VTABLE_LOOKUP;
    private static final HashSet<String> DYNAMIC_OBJECT_RESERVED_METHOD_NAMES;

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type, int nullSafeGuarded) {
        InlineCache callSite = new InlineCache(caller, name, type, nullSafeGuarded != 0);
        MethodHandle fallbackHandle = FALLBACK.bindTo(callSite).asCollector(Object[].class, type.parameterCount()).asType(type);
        callSite.setTarget(fallbackHandle);
        return callSite;
    }

    public static boolean classGuard(Class<?> expected, Object receiver) {
        return receiver.getClass() == expected;
    }

    public static MethodHandle vtableLookup(InlineCache inlineCache, Object[] args) {
        Class<?> receiverClass = args[0].getClass();
        MethodHandle target = inlineCache.vtable.get(receiverClass);
        if (target == null) {
            target = MethodInvocationSupport.lookupTarget(receiverClass, inlineCache, args);
            inlineCache.vtable.put(receiverClass, target);
        }
        return target;
    }

    private static MethodHandle lookupTarget(Class<?> receiverClass, InlineCache inlineCache, Object[] args) {
        if (receiverClass.isArray()) {
            return new ArrayMethodFinder(inlineCache, receiverClass, args).find();
        }
        if (MethodInvocationSupport.isCallOnDynamicObject(inlineCache, args[0])) {
            DynamicObject dynamicObject = (DynamicObject)args[0];
            return dynamicObject.invoker(inlineCache.name, inlineCache.type());
        }
        return MethodInvocationSupport.findTarget(receiverClass, inlineCache, args);
    }

    public static Object fallback(InlineCache inlineCache, Object[] args) throws Throwable {
        if (inlineCache.isMegaMorphic()) {
            return MethodInvocationSupport.installVTableDispatch(inlineCache, args);
        }
        if (args[0] == null) {
            if (MethodInvocationSupport.shouldReturnNull(inlineCache, args[0])) {
                return null;
            }
            throw new NullPointerException("On method: " + inlineCache.name + " " + inlineCache.type().dropParameterTypes(0, 1));
        }
        Class<?> receiverClass = args[0].getClass();
        MethodHandle target = MethodInvocationSupport.lookupTarget(receiverClass, inlineCache, args);
        MethodHandle guard = CLASS_GUARD.bindTo(receiverClass);
        MethodHandle fallback = inlineCache.getTarget();
        MethodHandle root = MethodHandles.guardWithTest(guard, target, fallback);
        if (inlineCache.nullSafeGuarded) {
            root = MethodInvocationSupport.makeNullSafeGuarded(root);
        }
        inlineCache.setTarget(root);
        ++inlineCache.depth;
        return target.invokeWithArguments(args);
    }

    private static MethodHandle makeNullSafeGuarded(MethodHandle root) {
        MethodHandle catchThenNull = MethodHandles.dropArguments(MethodHandles.constant(Object.class, null), 0, new Class[]{NullPointerException.class});
        root = MethodHandles.catchException(root, NullPointerException.class, catchThenNull);
        return root;
    }

    private static boolean shouldReturnNull(InlineCache inlineCache, Object arg) {
        return arg == null && inlineCache.nullSafeGuarded;
    }

    private static Object installVTableDispatch(InlineCache inlineCache, Object[] args) throws Throwable {
        if (inlineCache.vtable == null) {
            inlineCache.vtable = new WeakHashMap();
        }
        MethodHandle lookup = VTABLE_LOOKUP.bindTo(inlineCache).asCollector(Object[].class, args.length);
        MethodHandle exactInvoker = MethodHandles.exactInvoker(inlineCache.type());
        MethodHandle vtableTarget = MethodHandles.foldArguments(exactInvoker, lookup);
        if (inlineCache.nullSafeGuarded) {
            vtableTarget = MethodInvocationSupport.makeNullSafeGuarded(vtableTarget);
        }
        inlineCache.setTarget(vtableTarget);
        if (MethodInvocationSupport.shouldReturnNull(inlineCache, args[0])) {
            return null;
        }
        return vtableTarget.invokeWithArguments(args);
    }

    private static boolean isCallOnDynamicObject(InlineCache inlineCache, Object arg) {
        return arg instanceof DynamicObject && !DYNAMIC_OBJECT_RESERVED_METHOD_NAMES.contains(inlineCache.name);
    }

    private static MethodHandle findTarget(Class<?> receiverClass, InlineCache inlineCache, Object[] args) {
        MethodHandle target = new RegularMethodFinder(inlineCache, receiverClass, args).find();
        if (target != null) {
            return target;
        }
        target = new AugmentationMethodFinder(inlineCache, receiverClass, args).find();
        if (target != null) {
            return target;
        }
        throw new NoSuchMethodError(receiverClass + "::" + inlineCache.name);
    }

    static {
        DYNAMIC_OBJECT_RESERVED_METHOD_NAMES = new HashSet<String>(){
            {
                this.add("get");
                this.add("define");
                this.add("undefine");
                this.add("mixin");
                this.add("copy");
                this.add("freeze");
                this.add("properties");
                this.add("invoker");
                this.add("hasMethod");
                this.add("fallback");
            }
        };
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            CLASS_GUARD = lookup.findStatic(MethodInvocationSupport.class, "classGuard", MethodType.methodType(Boolean.TYPE, Class.class, Object.class));
            FALLBACK = lookup.findStatic(MethodInvocationSupport.class, "fallback", MethodType.methodType(Object.class, InlineCache.class, Object[].class));
            VTABLE_LOOKUP = lookup.findStatic(MethodInvocationSupport.class, "vtableLookup", MethodType.methodType(MethodHandle.class, InlineCache.class, Object[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error("Could not bootstrap the required method handles", e);
        }
    }

    static final class InlineCache
    extends MutableCallSite {
        static final int MEGAMORPHIC_THRESHOLD = 5;
        final MethodHandles.Lookup callerLookup;
        final String name;
        final boolean nullSafeGuarded;
        int depth = 0;
        WeakHashMap<Class, MethodHandle> vtable;

        InlineCache(MethodHandles.Lookup callerLookup, String name, MethodType type, boolean nullSafeGuarded) {
            super(type);
            this.callerLookup = callerLookup;
            this.name = name;
            this.nullSafeGuarded = nullSafeGuarded;
        }

        boolean isMegaMorphic() {
            return this.depth > 5;
        }
    }
}

