/*
 * Decompiled with CFR 0.152.
 */
package org.gonn.gava;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class Box<T> {
    private T value;

    public Box(T t) {
        this.value = t;
    }

    public static <T> Box<T> of(T obj) {
        return new Box<T>(obj);
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isFull() {
        return this.value != null;
    }

    public T get() {
        return this.value;
    }

    public T get(T fallback) {
        return this.value == null ? fallback : this.value;
    }

    public Box<T> then(Consumer<T> valueConsumer) {
        if (valueConsumer != null && this.value != null) {
            valueConsumer.accept(this.value);
        }
        return this;
    }

    public Box<T> update(UnaryOperator<T> valueOperator) {
        if (valueOperator != null && this.value != null) {
            this.value = valueOperator.apply(this.value);
        }
        return this;
    }

    public Box<T> or(Supplier<T> fallbackSupplier) {
        if (fallbackSupplier != null && this.value == null) {
            this.value = fallbackSupplier.get();
        }
        return this;
    }

    public <X extends Throwable> Box<T> orThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this;
    }

    public <R> Box<R> map(Function<T, R> valueFunction) {
        return new Box<R>(valueFunction.apply(this.value));
    }

    public <R> Box<R> map(Function<T, R> valueFunction, Supplier<R> fallbackSupplier) {
        try {
            return this.map(valueFunction);
        }
        catch (Exception ignore) {
            return new Box<R>(fallbackSupplier.get());
        }
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        return obj != null && this.hashCode() == obj.hashCode();
    }
}

