/*
 * Decompiled with CFR 0.152.
 */
package org.gonn.gava;

import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class Common {
    public static final String ENV_VAR_VERBOSE = "VERBOSE";
    public static final long EPOCH_STARTED = System.currentTimeMillis();
    public static final boolean VERBOSE_MODE = Common.getConfig("VERBOSE", false);
    public static final int SECOND = 1000;
    public static final int MINUTE = 60000;
    public static final int HOUR = 3600000;
    public static final int DAY = 86400000;

    private Common() {
    }

    public static String repeat(char c, int n) {
        if (n < 1) {
            return "";
        }
        char[] out = new char[n];
        for (int i = 0; i < n; ++i) {
            out[i] = c;
        }
        return new String(out);
    }

    public static String repeat(String s, int n) {
        if (s == null || n < 1) {
            return "";
        }
        int size = s.length();
        char[] out = new char[size * n];
        for (int i = 0; i < n; ++i) {
            s.getChars(0, size, out, i * size);
        }
        return new String(out);
    }

    public static int count(String s, char c) {
        if (s == null) {
            return 0;
        }
        int out = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++out;
        }
        return out;
    }

    public static int count(String s, String search) {
        if (s == null || s.length() == 0 || search == null || search.length() == 0 || search.length() > s.length()) {
            return 0;
        }
        int out = 0;
        int cur = 0;
        while ((cur = s.indexOf(search, cur)) >= 0) {
            ++out;
            ++cur;
        }
        return out;
    }

    public static int count(String[] s, String key) {
        int out = 0;
        for (String v : s) {
            if (v == null || !v.equals(key)) continue;
            ++out;
        }
        return out;
    }

    public static String rtrim(String s) {
        if (s == null) {
            return null;
        }
        for (int i = s.length() - 1; i > 0; --i) {
            if (s.charAt(i) == ' ') continue;
            return s.substring(0, i + 1);
        }
        return "";
    }

    public static String ltrim(String s) {
        if (s == null) {
            return null;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == ' ') continue;
            return s.substring(i);
        }
        return "";
    }

    private static int substringCalc(int size, int index, boolean indexTo) {
        int p;
        int tmp = indexTo ? 1 : 0;
        int n = p = index < tmp ? size + index : index;
        if (p < 0) {
            return 0;
        }
        if (p > size) {
            return size;
        }
        return p;
    }

    public static String substring(String s, int idxFrom, int idxTo) {
        int p2;
        if (s == null) {
            return null;
        }
        int sz = s.length();
        int p1 = Common.substringCalc(sz, idxFrom, false);
        return p1 >= (p2 = Common.substringCalc(sz, idxTo, true)) ? "" : s.substring(p1, p2);
    }

    public static String substring(String s, int to) {
        if (to == 0) {
            return "";
        }
        if (to > 0) {
            return Common.substring(s, 0, to);
        }
        return Common.substring(s, to, 0);
    }

    public static String getStringBetween(String s, String prefix, String suffix) {
        if (s == null || prefix == null || suffix == null || !s.startsWith(prefix) || !s.endsWith(suffix)) {
            return null;
        }
        int sLen = s.length();
        int start = prefix.length();
        int end = suffix.length();
        if (start == 0 && end == 0) {
            return s;
        }
        if (sLen < start + end) {
            return null;
        }
        return s.substring(start, sLen - end);
    }

    public static String getNth(String s, char delim, int index) {
        if (s == null) {
            return null;
        }
        int n = index < 0 ? index + Common.count(s, delim) + 1 : index;
        int end = -1;
        int idx = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != delim) continue;
            int start = end + 1;
            end = i;
            if (idx++ != n) continue;
            return s.substring(start, i);
        }
        return idx == n ? s.substring(end + 1) : null;
    }

    public static <T> T first(T[] t) {
        return t == null || t.length == 0 ? null : (T)t[0];
    }

    public static char first(String s) {
        return s == null || s.length() == 0 ? (char)'\u0000' : s.charAt(0);
    }

    public static <T> T last(T[] t) {
        return t == null || t.length == 0 ? null : (T)t[t.length - 1];
    }

    public static char last(String s) {
        return s == null || s.length() == 0 ? (char)'\u0000' : s.charAt(s.length() - 1);
    }

    public static String removePrefix(String s, String prefix) {
        if (s == null) {
            return null;
        }
        if (prefix == null) {
            return s;
        }
        return s.startsWith(prefix) ? s.substring(prefix.length()) : s;
    }

    public static String removePrefix(String s, char prefix) {
        if (s == null) {
            return null;
        }
        return Common.first(s) == prefix ? s.substring(1) : s;
    }

    public static String removeSuffix(String s, String suffix) {
        if (s == null) {
            return null;
        }
        if (suffix == null) {
            return s;
        }
        return s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : s;
    }

    public static String removeSuffix(String s, char suffix) {
        if (s == null) {
            return null;
        }
        return Common.last(s) == suffix ? s.substring(0, s.length() - 1) : s;
    }

    public static long getEpoch() {
        return System.currentTimeMillis();
    }

    public static String epochToString(long epoch, int offsetHr, boolean signed) {
        if (offsetHr > 23 || offsetHr < -23) {
            Common.error(() -> "getEpochString(): invalid param(s)");
            return "00:00:00.000";
        }
        char[] out = new char[13];
        int epochSmall = (int)((epoch + (long)(offsetHr * 3600000)) % 86400000L);
        out[0] = 43;
        if (epoch < 0L) {
            out[0] = 45;
            epochSmall = -epochSmall;
        }
        int tmp = epochSmall % 86400000 / 3600000;
        out[1] = (char)(48 + tmp / 10);
        out[2] = (char)(48 + tmp % 10);
        out[3] = 58;
        tmp = epochSmall % 3600000 / 60000;
        out[4] = (char)(48 + tmp / 10);
        out[5] = (char)(48 + tmp % 10);
        out[6] = 58;
        tmp = epochSmall % 60000 / 1000;
        out[7] = (char)(48 + tmp / 10);
        out[8] = (char)(48 + tmp % 10);
        out[9] = 46;
        tmp = epochSmall % 1000;
        out[10] = (char)(48 + tmp / 100);
        out[11] = (char)(48 + tmp / 10 % 10);
        out[12] = (char)(48 + tmp % 10);
        if (signed) {
            return new String(out, 0, 13);
        }
        return new String(out, 1, 12);
    }

    public static String epochToString(long epoch, int offsetHr) {
        return Common.epochToString(epoch, offsetHr, false);
    }

    public static String epochToString(long epochMillis) {
        return Common.epochToString(epochMillis, 0, epochMillis < 0L);
    }

    public static String epochToString() {
        return Common.epochToString(System.currentTimeMillis() - EPOCH_STARTED);
    }

    public static void prints(String name, Object ... objs) {
        String prefix = name + "[%" + Common.getDigits(objs.length) + "d]: ";
        String fmtString = prefix + "\"%s\"\n";
        String fmtObject = prefix + "<%s>\n";
        String fmtOther = prefix + " %s \n";
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) {
                System.out.printf(fmtOther, i, "null");
                continue;
            }
            if (objs[i] instanceof String) {
                System.out.printf(fmtString, i, objs[i]);
                continue;
            }
            if (objs[i] instanceof Boolean) {
                System.out.printf(fmtOther, i, objs[i]);
                continue;
            }
            if (objs[i] instanceof Number) {
                System.out.printf(fmtOther, i, objs[i]);
                continue;
            }
            System.out.printf(fmtObject, i, objs[i]);
        }
    }

    public static void println(Object ... any) {
        System.out.print(Common.join(", ", any) + '\n');
    }

    public static String join(String delimiter, Object ... objs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objs.length; ++i) {
            if (i != 0 && delimiter != null) {
                sb.append(delimiter);
            }
            if (objs[i] == null) {
                sb.append("null");
                continue;
            }
            if (objs[i] instanceof String) {
                sb.append('\"').append(objs[i].toString()).append('\"');
                continue;
            }
            sb.append(objs[i].toString());
        }
        return sb.toString();
    }

    public static int getDigits(long n) {
        long num;
        int out = n < 0L ? 2 : 1;
        long l = num = n < 0L ? -n : n;
        while ((num /= 10L) > 0L) {
            ++out;
        }
        return out;
    }

    public static String getByteSizeString(long numOfBytes) {
        String unitString;
        long unit;
        long size;
        String sign = numOfBytes > 0L ? "" : "-";
        long l = size = numOfBytes > 0L ? numOfBytes : -numOfBytes;
        if (size < 1024L) {
            return sign + size + "B";
        }
        if (size >= 0x40000000L) {
            unit = 0x40000000L;
            unitString = "GB";
        } else if (size >= 0x100000L) {
            unit = 0x100000L;
            unitString = "MB";
        } else {
            unit = 1024L;
            unitString = "KB";
        }
        int num = (int)(size / unit);
        int decimal = (int)(size % unit * 100L / unit);
        return sign + num + "." + decimal / 10 + decimal % 10 + unitString;
    }

    public static boolean getConfig(String key, boolean fallback) {
        String res = Common.getConfig(key);
        if (res == null) {
            return fallback;
        }
        res = res.toUpperCase();
        return fallback ? !res.equals("FALSE") : res.equals("TRUE");
    }

    public static String getConfig(String key, String fallback) {
        String res = Common.getConfig(key);
        return res != null ? res : fallback;
    }

    public static String getConfig(String key) {
        String tmp = System.getProperty(key);
        if (tmp != null) {
            return tmp;
        }
        tmp = System.getenv(key);
        return tmp;
    }

    public static void parseArgs(String[] args, BiConsumer<String, String> f) {
        for (String a : args) {
            if (!a.startsWith("--")) continue;
            int idx = a.indexOf(61);
            if (idx >= 0) {
                f.accept(a.substring(2, idx), a.substring(idx + 1));
                continue;
            }
            f.accept(a.substring(2), null);
        }
    }

    public static StackTraceElement getCaller(int skip) {
        StackTraceElement[] tmp = Thread.currentThread().getStackTrace();
        if (tmp.length <= (skip += 2)) {
            return null;
        }
        return Thread.currentThread().getStackTrace()[skip];
    }

    public static String getCaller() {
        StackTraceElement tmp = Common.getCaller(1);
        if (tmp != null) {
            return tmp.getFileName() + ':' + tmp.getLineNumber();
        }
        return null;
    }

    public static long getTimed(Runnable r, int count) {
        long t = Common.getEpoch();
        for (int i = 0; i < count; ++i) {
            r.run();
        }
        return Common.getEpoch() - t;
    }

    public static boolean sleep(long ms) {
        try {
            Thread.sleep(ms);
            return true;
        }
        catch (InterruptedException e) {
            Common.error(e::toString);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static void log(String prefix, String msg) {
        System.out.print(Common.epochToString(System.currentTimeMillis() - EPOCH_STARTED) + prefix + msg + (Common.last(msg) != '\n' ? (char)'\n' : ' '));
    }

    public static void debug(Supplier<String> s) {
        if (VERBOSE_MODE) {
            Common.log(" DEBUG  ", s.get());
        }
    }

    public static void info(Supplier<String> s) {
        if (VERBOSE_MODE) {
            Common.log(" INFO  ", s.get());
        }
    }

    public static void warn(Supplier<String> s) {
        if (VERBOSE_MODE) {
            Common.log(" WARN  ", s.get());
        }
    }

    public static void error(Supplier<String> s) {
        if (VERBOSE_MODE) {
            Common.log(" ERROR  ", s.get());
        }
    }

    public static <T> T get(Supplier<T> f) {
        return f.get();
    }

    public static int getHash(String s) {
        if (s == null) {
            return 0;
        }
        int sLen = s.length();
        int h = 0;
        for (int i = 0; i < sLen; ++i) {
            h = h * 31 + s.charAt(i);
        }
        return h;
    }

    public static void main(String[] args) {
        System.out.println(Common.class.getPackage().getName() + " by Gonn");
    }
}

