/*
 * Decompiled with CFR 0.152.
 */
package org.gonn.gava;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.gonn.gava.Common;
import org.gonn.gava.Loggable;

public class DevLogger
implements Loggable<String> {
    private static final String ME = DevLogger.class.getSimpleName();
    public static final byte LV_ALL = 0;
    public static final byte LV_TRACE = 1;
    public static final byte LV_DEBUG = 2;
    public static final byte LV_INFO = 3;
    public static final byte LV_WARN = 4;
    public static final byte LV_ERROR = 5;
    public static final byte LV_FATAL = 6;
    public static final byte LV_OFF = 9;
    public static final String ENV_LOG_OUTPUT = "LOG_OUTPUT";
    public static final String ENV_LOG_LEVEL = "LOG_LEVEL";
    public static final String ENV_LOG_TIMESTAMP = "LOG_TIMESTAMP";
    public static final String ENV_LOG_FILELINE = "LOG_FILELINE";
    private final String name;
    private BiConsumer<Byte, String> writer;
    private byte level = (byte)9;
    private boolean enabled = false;
    private boolean useTimestamp = true;
    private boolean useFileLine = false;

    public DevLogger(String name) {
        this.name = name;
        String tmpThisLevel = this.name.toUpperCase() + "_" + ENV_LOG_LEVEL;
        String tmpLevel = Common.getConfig(tmpThisLevel, null);
        tmpLevel = tmpLevel != null ? tmpLevel : Common.getConfig(ENV_LOG_LEVEL, "");
        this.setLevel(tmpLevel);
        String tmpOut = Common.getConfig(ENV_LOG_OUTPUT, "").toUpperCase();
        if (tmpOut.length() == 0 || tmpOut.equals("STDOUT")) {
            this.setOutput((lv, s) -> System.out.println((String)s));
        } else if (tmpOut.equals("STDERR")) {
            this.setOutput((lv, s) -> System.err.println((String)s));
        }
        this.useTimestamp = Common.getConfig(ENV_LOG_TIMESTAMP, true);
        this.useFileLine = Common.getConfig(ENV_LOG_FILELINE, false);
        this.enable(true);
    }

    public DevLogger(Class<?> c) {
        this(c.getSimpleName());
    }

    public DevLogger(Class<?> c, String identifier) {
        this(c.getSimpleName() + ":" + identifier);
    }

    public DevLogger setOutput(BiConsumer<Byte, String> writer) {
        this.writer = writer;
        return this.enable(true);
    }

    private boolean isLoggable() {
        return this.writer != null && this.level < 9;
    }

    private DevLogger enable(boolean tf) {
        this.enabled = tf && this.isLoggable();
        return this;
    }

    public DevLogger setFormat(boolean timestamp, boolean fileline) {
        this.useTimestamp = timestamp;
        this.useFileLine = fileline;
        return this;
    }

    private static String formatter(String name, String level, Supplier<String> msg, boolean useTimestamp, boolean useFileLine, int skip) {
        StackTraceElement caller;
        StringBuilder sb = new StringBuilder(200);
        if (useTimestamp) {
            sb.append(Common.epochToString()).append("  ");
        }
        sb.append(level).append("  [").append(name).append("]  ").append(msg != null ? msg.get() : "null");
        if (useFileLine && (caller = Common.getCaller(2 + skip)) != null) {
            return sb.append("  (").append(caller.getFileName()).append(':').append(caller.getLineNumber()).append(')').toString();
        }
        return sb.toString();
    }

    private static byte parseLevel(char c) {
        if ('a' <= c && c <= 'z') {
            c = (char)(c - 32);
        }
        switch (c) {
            case 'A': {
                return 0;
            }
            case 'T': {
                return 1;
            }
            case 'D': {
                return 2;
            }
            case 'I': {
                return 3;
            }
            case 'W': {
                return 4;
            }
            case 'E': {
                return 5;
            }
            case 'F': {
                return 6;
            }
        }
        return 9;
    }

    public DevLogger setLevel(String level) {
        if (level == null || level.length() == 0) {
            return this;
        }
        return this.setLevel(DevLogger.parseLevel(level.charAt(0)));
    }

    public DevLogger setLevel(byte level) {
        this.level = level;
        return this.enable(true);
    }

    public DevLogger setLevel(int level) {
        return this.setLevel((byte)level);
    }

    public DevLogger setLevel(char level) {
        return this.setLevel(DevLogger.parseLevel(level));
    }

    @Override
    public void trace(Supplier<String> msg) {
        if (this.enabled && this.level <= 1) {
            this.writer.accept((byte)1, DevLogger.formatter(this.name, "TRACE", msg, this.useTimestamp, this.useFileLine, 0));
        }
    }

    @Override
    public void debug(Supplier<String> msg) {
        if (this.enabled && this.level <= 2) {
            this.writer.accept((byte)2, DevLogger.formatter(this.name, "DEBUG", msg, this.useTimestamp, this.useFileLine, 0));
        }
    }

    @Override
    public void info(Supplier<String> msg) {
        if (this.enabled && this.level <= 3) {
            this.writer.accept((byte)3, DevLogger.formatter(this.name, "INFO ", msg, this.useTimestamp, this.useFileLine, 0));
        }
    }

    @Override
    public void warn(Supplier<String> msg) {
        if (this.enabled && this.level <= 4) {
            this.writer.accept((byte)4, DevLogger.formatter(this.name, "WARN ", msg, this.useTimestamp, this.useFileLine, 0));
        }
    }

    @Override
    public void warn(Supplier<String> msg, int skip) {
        if (this.enabled && this.level <= 4) {
            this.writer.accept((byte)4, DevLogger.formatter(this.name, "WARN ", msg, this.useTimestamp, this.useFileLine, skip));
        }
    }

    @Override
    public void error(Supplier<String> msg) {
        if (this.enabled && this.level <= 5) {
            this.writer.accept((byte)5, DevLogger.formatter(this.name, "ERROR", msg, this.useTimestamp, this.useFileLine, 0));
        }
    }

    @Override
    public void error(Supplier<String> msg, int skip) {
        if (this.enabled && this.level <= 5) {
            this.writer.accept((byte)5, DevLogger.formatter(this.name, "ERROR", msg, this.useTimestamp, this.useFileLine, skip));
        }
    }

    @Override
    public void fatal(Supplier<String> msg) {
        if (this.enabled && this.level <= 6) {
            this.writer.accept((byte)6, DevLogger.formatter(this.name, "FATAL", msg, this.useTimestamp, this.useFileLine, 0));
        }
    }

    @Override
    public void fatal(Supplier<String> msg, int skip) {
        if (this.enabled && this.level <= 6) {
            this.writer.accept((byte)6, DevLogger.formatter(this.name, "FATAL", msg, this.useTimestamp, this.useFileLine, skip));
        }
    }

    public String toString() {
        return ME + "<" + this.name + ">";
    }

    public DevLogger testing() {
        this.setOutput((lv, s) -> System.err.println((String)s)).setFormat(true, true).setLevel((byte)0).warn(() -> "TESTING ON - Disable testing() before deployment", 1);
        return this;
    }
}

