/*
 * Decompiled with CFR 0.152.
 */
package org.gonn.gava;

import org.gonn.gava.FnR;
import org.gonn.gava.FnT;
import org.gonn.gava.FnTR;

public class Box<T> {
    private T value;

    public Box(T t) {
        this.value = t;
    }

    public static <T> Box<T> of(T obj) {
        return new Box<T>(obj);
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isFull() {
        return this.value != null;
    }

    public T get() {
        return this.value;
    }

    public T get(T fallback) {
        return this.value == null ? fallback : this.value;
    }

    public Box<T> then(FnT<T> modFn) {
        if (modFn != null && this.value != null) {
            modFn.run(this.value);
        }
        return this;
    }

    public Box<T> thenSet(FnTR<T, T> modFn) {
        if (modFn != null && this.value != null) {
            this.value = modFn.run(this.value);
        }
        return this;
    }

    public Box<T> or(T fallback) {
        if (this.value == null) {
            this.value = fallback;
        }
        return this;
    }

    public Box<T> orElse(FnR<T> fallbackFn) {
        if (this.value == null) {
            this.value = fallbackFn.run();
        }
        return this;
    }

    public <E extends Throwable> Box<T> orThrow(E exception) throws E {
        if (this.value == null) {
            throw exception;
        }
        return this;
    }

    public <R> Box<R> map(FnTR<T, R> mapFn) {
        return new Box<R>(mapFn.run(this.value));
    }

    public <R> Box<R> map(FnTR<T, R> mapFn, R fallback) {
        try {
            return this.map(mapFn);
        }
        catch (Exception ignore) {
            return new Box<R>(fallback);
        }
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        return obj != null && this.hashCode() == obj.hashCode();
    }
}

