/*
 * Decompiled with CFR 0.152.
 */
package org.gonn.gava;

import org.gonn.gava.Fx01;
import org.gonn.gava.Fx10;
import org.gonn.gava.Fx11;
import org.gonn.gava.FxBool;
import org.gonn.gava.FxThrow;
import org.gonn.gava.FxUnary;

public class Box<T> {
    private T value;

    public Box(T t) {
        this.value = t;
    }

    public static <T> Box<T> of(T obj) {
        return new Box<T>(obj);
    }

    public static <R> Box<R> of(Fx01<R> fx) {
        return new Box<R>(fx.run());
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isFull() {
        return this.value != null;
    }

    public T get() {
        return this.value;
    }

    public T get(T fallback) {
        return this.value == null ? fallback : this.value;
    }

    public Box<T> skip(FxBool<T> skipFn) {
        if (this.value != null && skipFn.run(this.value)) {
            this.value = null;
        }
        return this;
    }

    public Box<T> then(Fx10<T> modFn) {
        if (this.value != null) {
            modFn.run(this.value);
        }
        return this;
    }

    public Box<T> thenSet(FxUnary<T> modFn) {
        if (this.value != null) {
            this.value = modFn.run(this.value);
        }
        return this;
    }

    public Box<T> thenIf(FxBool<T> condition, Fx10<T> modFn) {
        if (this.value != null && condition.run(this.value)) {
            modFn.run(this.value);
        }
        return this;
    }

    public Box<T> thenIf(FxBool<T> condition, Fx10<T> fnTrue, Fx10<T> fnFalse) {
        if (this.value == null) {
            return this;
        }
        if (condition.run(this.value)) {
            fnTrue.run(this.value);
        } else {
            fnFalse.run(this.value);
        }
        return this;
    }

    public Box<T> thenSetIf(FxBool<T> condition, FxUnary<T> modFn) {
        if (this.value != null && condition.run(this.value)) {
            this.value = modFn.run(this.value);
        }
        return this;
    }

    public Box<T> thenSetIf(FxBool<T> condition, FxUnary<T> fnTrue, FxUnary<T> fnFalse) {
        if (this.value == null) {
            return this;
        }
        this.value = condition.run(this.value) ? fnTrue.run(this.value) : fnFalse.run(this.value);
        return this;
    }

    public Box<T> or(Runnable r) {
        if (this.value == null) {
            r.run();
        }
        return this;
    }

    public Box<T> orSet(Fx01<T> valueFn) {
        if (this.value == null) {
            this.value = valueFn.run();
        }
        return this;
    }

    public Box<T> eval(Fx10<T> evalFn) {
        evalFn.run(this.value);
        return this;
    }

    public <X extends Throwable> Box<T> validate(FxBool<T> validationFn, X throwable) throws X {
        if (!validationFn.run(this.value)) {
            throw throwable;
        }
        return this;
    }

    public <R> Box<R> set(Fx01<R> setFn) {
        return new Box<R>(setFn.run());
    }

    public Box<T> reset(T newValue) {
        this.value = newValue;
        return this;
    }

    public <R> Box<R> map(Fx11<T, R> mapFn) {
        return new Box<Object>((this.value == null ? null : (T)mapFn.run(this.value)));
    }

    public <R> Box<R> map(FxThrow<T, R> fnMap, Fx11<Exception, R> fnFallback) {
        if (this.value == null) {
            return Box.of(null);
        }
        try {
            return Box.of(fnMap.run(this.value));
        }
        catch (Exception e) {
            return Box.of(fnFallback.run(e));
        }
    }

    public String toString() {
        return "" + this.value;
    }
}

