/*
 * Decompiled with CFR 0.152.
 */
package org.gonn.gava;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.BiConsumer;

public class LineReader {
    public static int fromInputStream(InputStream is, BiConsumer<Integer, String> proc) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            int lineNo = 0;
            while ((line = br.readLine()) != null) {
                proc.accept(++lineNo, line);
            }
            int n = lineNo;
            return n;
        }
    }

    public static int fromFile(String filename, BiConsumer<Integer, String> proc) throws IOException {
        try (FileInputStream fis = new FileInputStream(filename);){
            int n = LineReader.fromInputStream(fis, proc);
            return n;
        }
    }

    public static int fromResource(String filename, BiConsumer<Integer, String> proc) throws IOException {
        InputStream is = LineReader.class.getResourceAsStream(filename);
        return LineReader.fromInputStream(is, proc);
    }
}

