/*
 * Decompiled with CFR 0.152.
 */
package org.gonn.gava;

import java.util.function.Consumer;
import java.util.function.Supplier;

public class ObjectPool<T> {
    private final T[] pool;
    private final Supplier<T> creator;
    private final Consumer<T> cleaner;
    private volatile int objectThrown = 0;
    private volatile int objectCreated = 0;
    private volatile int objectReused = 0;

    public ObjectPool(Supplier<T[]> arrayMaker, Supplier<T> creator, Consumer<T> cleaner) {
        this.pool = arrayMaker.get();
        this.creator = creator;
        this.cleaner = cleaner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            for (int i = 0; i < this.pool.length; ++i) {
                if (this.pool[i] == null) continue;
                T tmp = this.pool[i];
                this.pool[i] = null;
                ++this.objectReused;
                return tmp;
            }
            ++this.objectCreated;
        }
        return this.creator.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(T t) {
        this.cleaner.accept(t);
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            for (int i = 0; i < this.pool.length; ++i) {
                if (this.pool[i] != null) continue;
                this.pool[i] = t;
                return;
            }
            ++this.objectThrown;
        }
    }

    public synchronized void clear() {
        for (int i = 0; i < this.pool.length; ++i) {
            this.pool[i] = null;
        }
    }

    public int size() {
        int count = 0;
        for (int i = 0; i < this.pool.length; ++i) {
            if (this.pool[i] == null) continue;
            ++count;
        }
        return count;
    }

    public int capacity() {
        return this.pool.length;
    }

    public int created() {
        return this.objectCreated;
    }

    public int thrown() {
        return this.objectThrown;
    }

    public int reused() {
        return this.objectReused;
    }
}

