/*
 * Decompiled with CFR 0.152.
 */
package org.gonn.gava;

import org.gonn.gava.FnR;
import org.gonn.gava.FnT;
import org.gonn.gava.FnTR;
import org.gonn.gava.FnTRb;

public class Box<T> {
    private T value;

    public Box(T t) {
        this.value = t;
    }

    public static <T> Box<T> of(T obj) {
        return new Box<T>(obj);
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isFull() {
        return this.value != null;
    }

    public T get() {
        return this.value;
    }

    public T get(T fallback) {
        return this.value == null ? fallback : this.value;
    }

    public Box<T> skip(FnTRb<T> skipFn) {
        if (skipFn.run(this.value)) {
            this.value = null;
        }
        return this;
    }

    public Box<T> then(FnT<T> modFn) {
        if (modFn != null && this.value != null) {
            modFn.run(this.value);
        }
        return this;
    }

    public Box<T> thenSet(FnTR<T, T> modFn) {
        if (modFn != null && this.value != null) {
            this.value = modFn.run(this.value);
        }
        return this;
    }

    public Box<T> or(Runnable r) {
        if (this.value == null) {
            r.run();
        }
        return this;
    }

    public Box<T> orSet(FnR<T> valueFn) {
        if (this.value == null) {
            this.value = valueFn.run();
        }
        return this;
    }

    public Box<T> eval(FnT<T> evalFn) {
        evalFn.run(this.value);
        return this;
    }

    public <X extends Throwable> Box<T> validate(FnTRb<T> validationFn, X throwable) throws X {
        if (!validationFn.run(this.value)) {
            throw throwable;
        }
        return this;
    }

    public Box<T> set(FnR<T> setFn) {
        this.value = setFn.run();
        return this;
    }

    public <R> Box<R> map(FnTR<T, R> mapFn) {
        if (this.value != null) {
            return new Box<R>(mapFn.run(this.value));
        }
        return new Box<Object>(null);
    }

    public String toString() {
        return this.value != null ? String.format("Box[%s]", this.value) : "Box[]";
    }
}

