/*
 * Decompiled with CFR 0.152.
 */
package org.gonn.gava;

import org.gonn.gava.Common;
import org.gonn.gava.Fx01;
import org.gonn.gava.Fx20;
import org.gonn.gava.Loggable;

public class TempLogger
implements Loggable<String> {
    public static final byte LV_ALL = 0;
    public static final byte LV_TRACE = 1;
    public static final byte LV_DEBUG = 2;
    public static final byte LV_INFO = 3;
    public static final byte LV_WARN = 4;
    public static final byte LV_ERROR = 5;
    public static final byte LV_FATAL = 6;
    public static final byte LV_OFF = 9;
    public static final String ENV_LOG_OUTPUT = "LOG_OUTPUT";
    public static final String ENV_LOG_LEVEL = "LOG_LEVEL";
    public static final String ENV_LOG_TIMESTAMP = "LOG_TIMESTAMP";
    public static final String ENV_LOG_FILELINE = "LOG_FILELINE";
    private static final String ME = TempLogger.class.getSimpleName();
    private final String name;
    private Fx20<Byte, String> writer;
    private byte level = (byte)9;
    private boolean enabled = false;
    private boolean useTimestamp = true;
    private boolean useFileLine = false;

    public TempLogger(String name) {
        this.name = name;
        String tmpThisLevel = this.name.toUpperCase() + "_" + ENV_LOG_LEVEL;
        String tmpLevel = Common.getConfig(tmpThisLevel, null);
        tmpLevel = tmpLevel != null ? tmpLevel : Common.getConfig(ENV_LOG_LEVEL, "");
        this.setLevel(tmpLevel);
        String tmpOut = Common.getConfig(ENV_LOG_OUTPUT, "").toUpperCase();
        if (tmpOut.length() == 0 || tmpOut.equals("STDOUT")) {
            this.setOutput((lv, s) -> System.out.println((String)s));
        } else if (tmpOut.equals("STDERR")) {
            this.setOutput((lv, s) -> System.err.println((String)s));
        }
        this.useTimestamp = Common.getConfig(ENV_LOG_TIMESTAMP, true);
        this.useFileLine = Common.getConfig(ENV_LOG_FILELINE, false);
        this.enable(true);
    }

    public TempLogger(Class<?> c) {
        this(c.getSimpleName());
    }

    public TempLogger(Class<?> c, String identifier) {
        this(c.getSimpleName() + ":" + identifier);
    }

    private static String formatter(String name, String level, Fx01<String> msg, boolean useTimestamp, boolean useFileLine, int skip) {
        StackTraceElement caller;
        StringBuilder sb = new StringBuilder(200);
        if (useTimestamp) {
            sb.append(Common.epochToString()).append("  ");
        }
        sb.append(level).append("  [").append(name).append("]  ").append(msg != null ? msg.run() : "null");
        if (useFileLine && (caller = Common.getCaller(2 + skip)) != null) {
            return sb.append("  (").append(caller.getFileName()).append(':').append(caller.getLineNumber()).append(')').toString();
        }
        return sb.toString();
    }

    private static byte parseLevel(char c) {
        if ('a' <= c && c <= 'z') {
            c = (char)(c - 32);
        }
        switch (c) {
            case 'A': {
                return 0;
            }
            case 'T': {
                return 1;
            }
            case 'D': {
                return 2;
            }
            case 'I': {
                return 3;
            }
            case 'W': {
                return 4;
            }
            case 'E': {
                return 5;
            }
            case 'F': {
                return 6;
            }
        }
        return 9;
    }

    public TempLogger setOutput(Fx20<Byte, String> writer) {
        this.writer = writer;
        return this.enable(true);
    }

    private boolean isLoggable() {
        return this.writer != null && this.level < 9;
    }

    private TempLogger enable(boolean tf) {
        this.enabled = tf && this.isLoggable();
        return this;
    }

    public TempLogger setFormat(boolean timestamp, boolean fileline) {
        this.useTimestamp = timestamp;
        this.useFileLine = fileline;
        return this;
    }

    public TempLogger setLevel(String level) {
        if (level == null || level.length() == 0) {
            return this;
        }
        return this.setLevel(TempLogger.parseLevel(level.charAt(0)));
    }

    public TempLogger setLevel(byte level) {
        this.level = level;
        return this.enable(true);
    }

    public TempLogger setLevel(int level) {
        return this.setLevel((byte)level);
    }

    public TempLogger setLevel(char level) {
        return this.setLevel(TempLogger.parseLevel(level));
    }

    @Override
    public void trace(Fx01<String> msg) {
        if (this.enabled && this.level <= 1) {
            this.writer.run((byte)1, TempLogger.formatter(this.name, "TRACE", msg, this.useTimestamp, this.useFileLine, 0));
        }
    }

    @Override
    public void debug(Fx01<String> msg) {
        if (this.enabled && this.level <= 2) {
            this.writer.run((byte)2, TempLogger.formatter(this.name, "DEBUG", msg, this.useTimestamp, this.useFileLine, 0));
        }
    }

    @Override
    public void info(Fx01<String> msg) {
        if (this.enabled && this.level <= 3) {
            this.writer.run((byte)3, TempLogger.formatter(this.name, "INFO ", msg, this.useTimestamp, this.useFileLine, 0));
        }
    }

    @Override
    public void warn(Fx01<String> msg) {
        if (this.enabled && this.level <= 4) {
            this.writer.run((byte)4, TempLogger.formatter(this.name, "WARN ", msg, this.useTimestamp, this.useFileLine, 0));
        }
    }

    @Override
    public void error(Fx01<String> msg) {
        if (this.enabled && this.level <= 5) {
            this.writer.run((byte)5, TempLogger.formatter(this.name, "ERROR", msg, this.useTimestamp, this.useFileLine, 0));
        }
    }

    @Override
    public void fatal(Fx01<String> msg) {
        if (this.enabled && this.level <= 6) {
            this.writer.run((byte)6, TempLogger.formatter(this.name, "FATAL", msg, this.useTimestamp, this.useFileLine, 0));
        }
    }

    public void warn(Fx01<String> msg, int skip) {
        if (this.enabled && this.level <= 4) {
            this.writer.run((byte)4, TempLogger.formatter(this.name, "WARN ", msg, this.useTimestamp, this.useFileLine, skip));
        }
    }

    public void error(Fx01<String> msg, int skip) {
        if (this.enabled && this.level <= 5) {
            this.writer.run((byte)5, TempLogger.formatter(this.name, "ERROR", msg, this.useTimestamp, this.useFileLine, skip));
        }
    }

    public void fatal(Fx01<String> msg, int skip) {
        if (this.enabled && this.level <= 6) {
            this.writer.run((byte)6, TempLogger.formatter(this.name, "FATAL", msg, this.useTimestamp, this.useFileLine, skip));
        }
    }

    public String toString() {
        return ME + "<" + this.name + ">";
    }

    public TempLogger testing() {
        this.setOutput((lv, s) -> System.err.println((String)s)).setFormat(true, true).setLevel((byte)0).warn(() -> "TESTING ON - Disable testing() before deployment", 1);
        return this;
    }
}

