/*
 * Decompiled with CFR 0.152.
 */
package org.gonn.gava;

import org.gonn.gava.Fx01;
import org.gonn.gava.Fx10;
import org.gonn.gava.Fx11;
import org.gonn.gava.FxBool;

public class Box<T>
implements AutoCloseable {
    private T value;

    public Box(T t) {
        this.value = t;
    }

    public static <T> Box<T> of(T obj) {
        return new Box<T>(obj);
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isFull() {
        return this.value != null;
    }

    public T get() {
        return this.value;
    }

    public T get(T fallback) {
        return this.value == null ? fallback : this.value;
    }

    public Box<T> skip(FxBool<T> skipFn) {
        if (this.value != null && skipFn.run(this.value)) {
            this.value = null;
        }
        return this;
    }

    public Box<T> then(Fx10<T> modFn) {
        if (this.value != null) {
            modFn.run(this.value);
        }
        return this;
    }

    public Box<T> thenSet(Fx11<T, T> modFn) {
        if (this.value != null) {
            this.value = modFn.run(this.value);
        }
        return this;
    }

    public Box<T> or(Runnable r) {
        if (this.value == null) {
            r.run();
        }
        return this;
    }

    public Box<T> orSet(Fx01<T> valueFn) {
        if (this.value == null) {
            this.value = valueFn.run();
        }
        return this;
    }

    public Box<T> eval(Fx10<T> evalFn) {
        evalFn.run(this.value);
        return this;
    }

    public <X extends Throwable> Box<T> validate(FxBool<T> validationFn, X throwable) throws X {
        if (!validationFn.run(this.value)) {
            throw throwable;
        }
        return this;
    }

    public Box<T> set(Fx01<T> setFn) {
        this.value = setFn.run();
        return this;
    }

    public <R> Box<R> map(Fx11<T, R> mapFn) {
        return new Box<Object>((this.value == null ? null : (T)mapFn.run(this.value)));
    }

    public String toString() {
        return this.value != null ? String.format("Box[%s]", this.value) : "Box[]";
    }

    @Override
    public void close() {
        this.value = null;
    }
}

