/*
 * Decompiled with CFR 0.152.
 */
package org.gonn.gava;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.gonn.gava.Fx21;
import org.gonn.gava.Storable;
import org.gonn.gava.TempLogger;

public class Config
implements Storable<String, String>,
AutoCloseable {
    private static TempLogger log;
    private static String COMMENT;
    private static String SEPARATOR;
    private static String SEPARATOR_OUT;
    private File f = null;
    private Map<String, String> conf = new LinkedHashMap<String, String>();

    public Config(String filename) throws IOException {
        this(filename, null);
    }

    public Config(String filename, Fx21<String, String, Boolean> lineFilter) throws IOException {
        this.f = new File(filename);
        log = new TempLogger(Config.class, filename);
        if (!this.f.exists() && this.f.createNewFile()) {
            log.info(() -> "Created a new file <" + filename);
        }
        try (BufferedReader br = new BufferedReader(new FileReader(this.f));){
            String line = br.readLine();
            int lineNumber = 0;
            while (line != null) {
                ++lineNumber;
                if (line.startsWith(COMMENT)) {
                    this.conf.put(line, null);
                } else {
                    int p = line.indexOf(SEPARATOR);
                    int tmpLineNumber = lineNumber;
                    if (p > -1) {
                        String key = line.substring(0, p).trim();
                        String val = line.substring(p + 1).trim();
                        if (val.length() > 1 && val.startsWith("\"") && val.endsWith("\"")) {
                            val = val.substring(1, val.length() - 1);
                        }
                        if (lineFilter != null) {
                            if (lineFilter.run(key, val).booleanValue()) {
                                this.conf.put(key, val);
                            } else {
                                this.conf.put(line, null);
                                log.trace(() -> "Per lineFilter, skip line " + tmpLineNumber + ", key=" + key);
                            }
                        } else {
                            this.conf.put(key, val);
                        }
                    } else {
                        String tmpLine = line;
                        log.debug(() -> "Ignored line: " + tmpLineNumber + ": " + tmpLine);
                    }
                }
                line = br.readLine();
            }
        }
    }

    public void forEach(BiConsumer<String, String> f) {
        this.conf.forEach(f);
    }

    public void save() throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.f));){
            this.conf.forEach((? super K k, ? super V v) -> {
                try {
                    bw.append((CharSequence)k);
                    if (v != null) {
                        bw.append(SEPARATOR_OUT);
                        if (v.indexOf(32) > -1) {
                            bw.append('\"').append((CharSequence)v).append('\"');
                        } else {
                            bw.append((CharSequence)v);
                        }
                    }
                    bw.append('\n');
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    @Override
    public String get(String key) {
        return this.conf.get(key);
    }

    @Override
    public void set(String key, String rec) {
        if (rec != null && rec.indexOf(10) > -1) {
            this.conf.put(key, rec.replace("\n", "\\n") + "\n");
        } else {
            this.conf.put(key, rec);
        }
    }

    @Override
    public boolean delete(String key) {
        return this.conf.remove(key) != null;
    }

    @Override
    public void close() throws IOException {
        this.conf.clear();
    }

    static {
        COMMENT = "#";
        SEPARATOR = "=";
        SEPARATOR_OUT = " = ";
    }
}

