/*
 * Decompiled with CFR 0.152.
 */
package org.gonn.gava;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class SimpleTerminal {
    public static final Supplier<String> DEFAULT_PROMPTER = () -> "> ";
    private Supplier<String> prompter;
    private boolean stop;
    private final BufferedReader buffer = new BufferedReader(new InputStreamReader(System.in));
    public final PrintStream output;

    public SimpleTerminal(PrintStream output) {
        this.prompter = DEFAULT_PROMPTER;
        this.output = output;
        this.stop = false;
    }

    public SimpleTerminal() {
        this(System.out);
    }

    public SimpleTerminal setPrompt(Supplier<String> prompter) {
        this.prompter = prompter == null ? DEFAULT_PROMPTER : prompter;
        return this;
    }

    public SimpleTerminal setPrompt(String prompt) {
        return this.setPrompt(() -> prompt);
    }

    public SimpleTerminal stop() {
        this.stop = true;
        return this;
    }

    public void execute(BiConsumer<SimpleTerminal, String> handler) {
        while (!this.stop) {
            try {
                this.output.print(this.prompter.get());
                String line = this.buffer.readLine();
                if (line == null || line.trim().isEmpty()) continue;
                handler.accept(this, line);
            }
            catch (Exception e) {
                this.output.println("Error: " + e.getMessage());
            }
        }
    }

    public static SimpleTerminal newInstance(PrintStream output) {
        return new SimpleTerminal(output);
    }

    public static SimpleTerminal newInstance() {
        return new SimpleTerminal();
    }
}

