/*
 * Decompiled with CFR 0.152.
 */
package org.gonn.gava;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class Stu {
    public static final long EPOCH_STARTED = System.currentTimeMillis();
    public static boolean VERBOSE_MODE = System.getProperty("VERBOSE_MODE", null) != null;
    public static int OFFSET_HR = Stu.parseInt(System.getProperty("OFFSET_HR", null), 0);
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    private Stu() {
    }

    public static <T> T[] subset(T[] src, int start, int end, IntFunction<T[]> generator) {
        start = Stu.substringCalc(src.length, start, false);
        end = Stu.substringCalc(src.length, end, true);
        int size = end - start;
        T[] out = generator.apply(size);
        if (size > 0) {
            System.arraycopy(src, start, out, 0, size);
        }
        return out;
    }

    public static int count(String haystack, char needle) {
        if (haystack == null) {
            return 0;
        }
        int out = 0;
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++out;
        }
        return out;
    }

    public static int count(String haystack, String needle) {
        if (haystack == null || haystack.isEmpty() || needle == null || needle.isEmpty() || needle.length() > haystack.length()) {
            return 0;
        }
        int out = 0;
        int cur = 0;
        while ((cur = haystack.indexOf(needle, cur)) > -1) {
            ++out;
            ++cur;
        }
        return out;
    }

    public static <T> int count(T[] s, T key) {
        int out = 0;
        for (T v : s) {
            if (v == null || !v.equals(key)) continue;
            ++out;
        }
        return out;
    }

    public static <T> boolean contain(T[] ts, T key) {
        for (T v : ts) {
            if (v == null || !v.equals(key)) continue;
            return true;
        }
        return false;
    }

    private static int substringCalc(int size, int index, boolean indexTo) {
        int p;
        int tmp = indexTo ? 1 : 0;
        int n = p = index < tmp ? size + index : index;
        if (p < 0) {
            return 0;
        }
        if (p > size) {
            return size;
        }
        return p;
    }

    public static String substring(String s, int idxFrom, int idxTo) {
        int p2;
        if (s == null) {
            return null;
        }
        int sz = s.length();
        int p1 = Stu.substringCalc(sz, idxFrom, false);
        return p1 >= (p2 = Stu.substringCalc(sz, idxTo, true)) ? "" : s.substring(p1, p2);
    }

    public static String substring(String s, int idx) {
        if (idx == 0) {
            return "";
        }
        if (idx > 0) {
            return Stu.substring(s, 0, idx);
        }
        return Stu.substring(s, idx, 0);
    }

    public static String getBetween(String s, String prefix, String suffix) {
        if (!Stu.isBetween(s, prefix, suffix)) {
            return null;
        }
        return s.substring(prefix.length(), s.length() - suffix.length());
    }

    public static boolean isBetween(String s, String prefix, String suffix) {
        if (s.length() < prefix.length() + suffix.length()) {
            return false;
        }
        return s.startsWith(prefix) && s.endsWith(suffix);
    }

    public static String getNth(String s, char delim, int index) {
        if (s == null) {
            return null;
        }
        int n = index < 0 ? index + Stu.count(s, delim) + 1 : index;
        int end = -1;
        int idx = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != delim) continue;
            int start = end + 1;
            end = i;
            if (idx++ != n) continue;
            return s.substring(start, i);
        }
        return idx == n ? s.substring(end + 1) : null;
    }

    public static <T> T getNth(T[] tArr, int index, T fallback) {
        return tArr.length > index ? tArr[index] : fallback;
    }

    public static <T> T first(T[] t) {
        return t == null || t.length == 0 ? null : (T)t[0];
    }

    public static <T> T last(T[] t) {
        return t == null || t.length == 0 ? null : (T)t[t.length - 1];
    }

    public static char first(String s) {
        return s == null || s.isEmpty() ? (char)'\u0000' : s.charAt(0);
    }

    public static char last(String s) {
        return s == null || s.isEmpty() ? (char)'\u0000' : s.charAt(s.length() - 1);
    }

    public static String removePrefix(String s, String prefix) {
        if (s == null) {
            return null;
        }
        if (prefix == null) {
            return s;
        }
        return s.startsWith(prefix) ? s.substring(prefix.length()) : s;
    }

    public static String removePrefix(String s, char prefix) {
        if (s == null) {
            return null;
        }
        return Stu.first(s) == prefix ? s.substring(1) : s;
    }

    public static String removeSuffix(String s, String suffix) {
        if (s == null) {
            return null;
        }
        if (suffix == null) {
            return s;
        }
        return s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : s;
    }

    public static String removeSuffix(String s, char suffix) {
        if (s == null) {
            return null;
        }
        return Stu.last(s) == suffix ? s.substring(0, s.length() - 1) : s;
    }

    public static long getEpoch() {
        return System.currentTimeMillis();
    }

    public static String epochToString(long milliseconds, int offsetHr, boolean signed) {
        if (offsetHr > 23 || offsetHr < -23) {
            Stu.log("epochToString(): invalid offsetHr param: " + offsetHr);
            return "00:00:00.000";
        }
        char[] out = new char[13];
        long epochSmall = (milliseconds + (long)offsetHr * 3600000L) % 86400000L;
        if (milliseconds < 0L) {
            out[0] = 45;
            epochSmall = -epochSmall;
        } else {
            out[0] = 43;
        }
        long tmp = epochSmall % 86400000L / 3600000L;
        out[1] = (char)(48L + tmp / 10L);
        out[2] = (char)(48L + tmp % 10L);
        out[3] = 58;
        tmp = epochSmall % 3600000L / 60000L;
        out[4] = (char)(48L + tmp / 10L);
        out[5] = (char)(48L + tmp % 10L);
        out[6] = 58;
        tmp = epochSmall % 60000L / 1000L;
        out[7] = (char)(48L + tmp / 10L);
        out[8] = (char)(48L + tmp % 10L);
        out[9] = 46;
        tmp = epochSmall % 1000L;
        out[10] = (char)(48L + tmp / 100L);
        out[11] = (char)(48L + tmp / 10L % 10L);
        out[12] = (char)(48L + tmp % 10L);
        if (signed) {
            return new String(out, 0, 13);
        }
        return new String(out, 1, 12);
    }

    public static String epochToString(long milliseconds, int offsetHr) {
        return Stu.epochToString(milliseconds, offsetHr, false);
    }

    public static String epochToString(long milliseconds) {
        return Stu.epochToString(milliseconds, OFFSET_HR, false);
    }

    public static String epochToString() {
        return Stu.epochToString(System.currentTimeMillis(), OFFSET_HR, false);
    }

    public static void prints(String name, Object ... objs) {
        String prefix = name + "[%" + Stu.getDigits(objs.length) + "d]: ";
        String fmtString = prefix + "\"%s\"\n";
        String fmtObject = prefix + "<%s>\n";
        String fmtOther = prefix + " %s \n";
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) {
                System.out.printf(fmtOther, i, "null");
                continue;
            }
            if (objs[i] instanceof String) {
                System.out.printf(fmtString, i, objs[i]);
                continue;
            }
            if (objs[i] instanceof Boolean) {
                System.out.printf(fmtOther, i, objs[i]);
                continue;
            }
            if (objs[i] instanceof Number) {
                System.out.printf(fmtOther, i, objs[i]);
                continue;
            }
            System.out.printf(fmtObject, i, objs[i]);
        }
    }

    public static void println(Object ... any) {
        System.out.print(Stu.join(", ", any) + '\n');
    }

    public static String join(String delimiter, Object ... objs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objs.length; ++i) {
            if (i != 0 && delimiter != null) {
                sb.append(delimiter);
            }
            if (objs[i] == null) {
                sb.append("null");
                continue;
            }
            if (objs[i] instanceof String) {
                sb.append('\"').append(objs[i].toString()).append('\"');
                continue;
            }
            sb.append(objs[i].toString());
        }
        return sb.toString();
    }

    public static int getDigits(int n) {
        n = n < 0 ? -n : n;
        int out = 1;
        while ((n /= 10) > 0) {
            ++out;
        }
        return out;
    }

    public static int getDigits(long n) {
        n = n < 0L ? -n : n;
        int out = 1;
        while ((n /= 10L) > 0L) {
            ++out;
        }
        return out;
    }

    public static void parseArgs(String[] args, BiConsumer<String, String> f) {
        for (String a : args) {
            if (!a.startsWith("--")) continue;
            int idx = a.indexOf(61);
            if (idx >= 0) {
                f.accept(a.substring(2, idx), a.substring(idx + 1));
                continue;
            }
            f.accept(a.substring(2), null);
        }
    }

    public static StackTraceElement getCaller(int skip) {
        StackTraceElement[] tmp = Thread.currentThread().getStackTrace();
        if (tmp.length <= (skip += 2)) {
            return null;
        }
        return Thread.currentThread().getStackTrace()[skip];
    }

    public static String getCallerString(int skip) {
        StackTraceElement tmp = Stu.getCaller(skip + 1);
        if (tmp != null) {
            return tmp.getFileName() + ":" + tmp.getLineNumber();
        }
        return null;
    }

    public static long getTimed(Runnable r) {
        long t = Stu.getEpoch();
        r.run();
        return Stu.getEpoch() - t;
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Stu.log("Thread.sleep() interrupted: " + e);
            Thread.currentThread().interrupt();
        }
    }

    public static void log(String msg) {
        if (VERBOSE_MODE) {
            System.out.println(Stu.epochToString() + "  " + msg);
        }
    }

    public static void log(Supplier<String> msg) {
        if (VERBOSE_MODE) {
            System.out.println(Stu.epochToString() + "  " + msg.get());
        }
    }

    public static <T> T mustGet(T t, T fallback) {
        return t != null ? t : fallback;
    }

    public static <X extends Throwable, T> T mustGet(T t, X exception) throws X {
        if (t == null) {
            throw exception;
        }
        return t;
    }

    public static <T> T ifNull(T t, T fallback) {
        return Stu.mustGet(t, fallback);
    }

    public static int parseInt(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int out = 0;
        int x = 48;
        boolean neg = false;
        for (int i = 0; i < s.length(); ++i) {
            x = s.charAt(i);
            if (x == 45) {
                neg = true;
                continue;
            }
            if (x < 48 || x > 57) {
                throw new NumberFormatException(s);
            }
            out = out * 10 + (x - 48);
        }
        return neg ? -out : out;
    }

    public static int parseInt(String s, int fallback) {
        try {
            return Stu.parseInt(s);
        }
        catch (NumberFormatException ignore) {
            return fallback;
        }
    }

    public static long parseLong(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        long out = 0L;
        int x = 48;
        for (int i = 0; i < s.length(); ++i) {
            x = s.charAt(i);
            if (x < 48 || x > 57) {
                throw new NumberFormatException(s);
            }
            out = out * 10L + (long)(x - 48);
        }
        return out;
    }

    public static long parseLong(String s, long fallback) {
        try {
            return Stu.parseLong(s);
        }
        catch (NumberFormatException ignore) {
            return fallback;
        }
    }

    public static int getHash(String s) {
        if (s == null) {
            return 0;
        }
        int sLen = s.length();
        int h = 0;
        for (int i = 0; i < sLen; ++i) {
            h = h * 31 + s.charAt(i);
        }
        return h;
    }

    @Deprecated
    public static boolean isDigit(char c) {
        return Stu.isNumeric(c);
    }

    @Deprecated
    public static boolean isDigit(String s) {
        return Stu.isNumeric(s);
    }

    public static boolean isNumeric(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(char c) {
        return '0' <= c && c <= '9';
    }

    public static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isAlphanumeric(String s) {
        if (s == null) {
            return false;
        }
        boolean hasNumber = false;
        boolean hasAlpha = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Stu.isNumeric(c)) {
                hasNumber = true;
                continue;
            }
            if (Stu.isAlpha(c)) {
                hasAlpha = true;
                continue;
            }
            return false;
        }
        return hasAlpha && hasNumber;
    }

    public static <T> void iterateNotNull(T[] ts, Consumer<T> fx) {
        if (ts == null) {
            return;
        }
        for (T t : ts) {
            if (t == null) continue;
            fx.accept(t);
        }
    }

    public static String bitsToString(long bitflag) {
        return Stu.bitsToString(bitflag, -1, 'O', '-', true);
    }

    public static String bitsToString(long bitflag, int size, char on, char off, boolean reverse) {
        if (size < 0) {
            size = 64;
        }
        char[] flagString = new char[size];
        if (reverse) {
            for (int i = 0; i < size; ++i) {
                flagString[i] = (bitflag & 1L << i) != 0L ? on : off;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                flagString[size - i - 1] = (bitflag & 1L << i) != 0L ? on : off;
            }
        }
        return new String(flagString);
    }

    public static String bitsToString(int bitflag) {
        return Stu.bitsToString(bitflag, -1, 'O', '-', true);
    }

    public static String bitsToString(int bitflag, int size, char on, char off, boolean reverse) {
        if (size < 0) {
            size = 32;
        }
        char[] flagString = new char[size];
        if (reverse) {
            for (int i = 0; i < size; ++i) {
                flagString[i] = (bitflag & 1 << i) != 0 ? on : off;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                flagString[size - i - 1] = (bitflag & 1 << i) != 0 ? on : off;
            }
        }
        return new String(flagString);
    }

    public static int setBits(int flag, int mask, boolean to) {
        return to ? flag | mask : flag & ~mask;
    }

    public static boolean hasBits(int flag, int mask, boolean hasAll) {
        return hasAll ? (flag & mask) == mask : (flag & mask) != 0;
    }

    public static <T> T chain(T t, UnaryOperator<T> fx1, UnaryOperator<T> fx2) {
        return (T)fx2.apply(fx1.apply(t));
    }

    public static <T> T chain(T t, UnaryOperator<T> fx1, UnaryOperator<T> fx2, UnaryOperator<T> fx3) {
        return (T)fx3.apply(fx2.apply(fx1.apply(t)));
    }

    public static <T> T chain(T t, UnaryOperator<T> fx1, UnaryOperator<T> fx2, UnaryOperator<T> fx3, UnaryOperator<T> fx4) {
        return (T)fx4.apply(fx3.apply(fx2.apply(fx1.apply(t))));
    }

    public static String repeat(char c, int n) {
        if (n < 1) {
            return "";
        }
        char[] out = new char[n];
        for (int i = 0; i < n; ++i) {
            out[i] = c;
        }
        return new String(out);
    }

    public static String repeat(String s, int n) {
        if (s == null || n < 1) {
            return "";
        }
        int size = s.length();
        char[] out = new char[size * n];
        for (int i = 0; i < n; ++i) {
            s.getChars(0, size, out, i * size);
        }
        return new String(out);
    }

    public static String byteSizeToString(long sizeInByte) {
        String unitString;
        long unit;
        long size;
        String sign = sizeInByte > 0L ? "" : "-";
        long l = size = sizeInByte > 0L ? sizeInByte : -sizeInByte;
        if (size < 1024L) {
            return sign + size + "B";
        }
        if (size < 0x100000L) {
            unit = 1024L;
            unitString = "KB";
        } else if (size < 0x40000000L) {
            unit = 0x100000L;
            unitString = "MB";
        } else {
            unit = 0x40000000L;
            unitString = "GB";
        }
        int num = (int)(size / unit);
        int decimal = (int)(size % unit * 100L / unit);
        return sign + num + "." + decimal / 10 + decimal % 10 + unitString;
    }

    public static String toHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_ARRAY[v >>> 4];
            hexChars[i * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static <T> String arrayToString(T[] ts) {
        if (ts == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (ts.length > 0) {
            boolean isString = ts[0] instanceof String;
            for (int i = 0; i < ts.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                if (isString) {
                    sb.append('\"').append(ts[i]).append('\"');
                    continue;
                }
                sb.append(ts[i].toString());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public static String intComma(long n) {
        if (n == 0L) {
            return "0";
        }
        boolean neg = false;
        if (n < 0L) {
            n = -n;
            neg = true;
        }
        int length = Stu.getDigits(n);
        length = length + (length - 1) / 3 + (neg ? 1 : 0);
        byte[] out = new byte[length];
        if (neg) {
            out[0] = 48;
        }
        int i = length - 1;
        int j = 0;
        while (n > 0L) {
            if (j == 3) {
                out[i--] = 44;
                j = 0;
            }
            out[i--] = (byte)(48L + n % 10L);
            n /= 10L;
            ++j;
        }
        return new String(out);
    }

    public static String intPadding(long positiveNumber, int length, char padding) {
        int i;
        if (positiveNumber < 0L) {
            positiveNumber = -positiveNumber;
        }
        char[] out = new char[length];
        for (i = 0; i < length; ++i) {
            out[i] = padding;
        }
        for (i = length - 1; i >= 0 && positiveNumber != 0L; positiveNumber /= 10L, --i) {
            out[i] = (char)(48L + positiveNumber % 10L);
        }
        return new String(out);
    }

    public static String pad(String s, int min, int max, char padding, boolean leftPadding) {
        int i;
        if (s == null) {
            return null;
        }
        int sLen = s.length();
        if (sLen >= min) {
            return max > 0 ? s.substring(0, max) : s;
        }
        char[] out = new char[min];
        if (leftPadding) {
            for (i = 0; i < min - sLen; ++i) {
                out[i] = padding;
            }
            for (int j = 0; j < sLen; ++j) {
                out[i++] = s.charAt(j);
            }
        } else {
            while (i < sLen) {
                out[i] = s.charAt(i);
                ++i;
            }
            while (i < min) {
                out[i] = padding;
                ++i;
            }
        }
        return new String(out);
    }

    public static String padLeft(String s, int length, char padding) {
        return Stu.pad(s, length, length, padding, true);
    }

    public static String padRight(String s, int length, char padding) {
        return Stu.pad(s, length, length, padding, false);
    }

    public static String trimLeft(String s) {
        if (s == null) {
            return null;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == ' ') continue;
            return s.substring(i);
        }
        return "";
    }

    public static String trimRight(String s) {
        if (s == null) {
            return null;
        }
        for (int i = s.length() - 1; i > 0; --i) {
            if (s.charAt(i) == ' ') continue;
            return s.substring(0, i + 1);
        }
        return "";
    }

    public static String trimString(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder sb = new StringBuilder(input);
        int n = sb.length();
        int index = 0;
        boolean lastWasSpace = true;
        for (int i = 0; i < n; ++i) {
            char c = sb.charAt(i);
            if (c != ' ') {
                sb.setCharAt(index++, c);
                lastWasSpace = false;
                continue;
            }
            if (lastWasSpace) continue;
            sb.setCharAt(index++, c);
            lastWasSpace = true;
        }
        if (index > 0 && sb.charAt(index - 1) == ' ') {
            --index;
        }
        sb.setLength(index);
        return sb.toString();
    }
}

