/*
 * Decompiled with CFR 0.152.
 */
package org.goots.exploder;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.goots.exploder.ExploderFileProcessor;
import org.goots.exploder.FileHandler;
import org.goots.exploder.InternalException;
import org.goots.exploder.types.FileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exploder {
    public static final String ARCHIVE_UNPACK_SUFFIX = "-unpacked-" + UUID.randomUUID().toString();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FileHandler fsh = new FileHandler();
    private final HashSet<String> excludedSuffixes = new HashSet();
    private File directoryRoot;

    public Exploder excludeSuffix(String suffix) throws InternalException {
        suffix = suffix.trim().toLowerCase();
        if (!this.fsh.getSupportedSuffixes().contains(suffix)) {
            throw new InternalException("Unknown suffix " + suffix);
        }
        this.excludedSuffixes.add(suffix);
        return this;
    }

    public Set<String> getSupportedSuffixes() {
        return this.fsh.getSupportedSuffixes();
    }

    public void unpack(File root) throws InternalException {
        this.unpack(null, root);
    }

    public void unpack(ExploderFileProcessor processor, File working, File root) throws InternalException {
        try {
            if (root.isDirectory()) {
                FileUtils.copyDirectory((File)root, (File)working);
            } else if (root.isFile()) {
                if (working.isDirectory()) {
                    FileUtils.copyFileToDirectory((File)root, (File)working);
                } else {
                    FileUtils.copyFile((File)root, (File)working);
                }
            } else {
                throw new InternalException("Target (" + root + ") is not directory or file ( exists: " + root.exists() + ')');
            }
            this.unpack(processor, working);
        }
        catch (IOException e) {
            throw new InternalException("Error setting up working directory", e);
        }
    }

    public void unpack(ExploderFileProcessor processor, File root) throws InternalException {
        block23: {
            if (this.directoryRoot == null) {
                this.logger.debug("Setting directory root to {}", (Object)root);
                this.directoryRoot = root;
            }
            if (root.isDirectory()) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(root.toPath());){
                    for (Path entry : stream) {
                        this.unpack(processor, entry.toFile());
                    }
                    break block23;
                }
                catch (IOException e) {
                    throw new InternalException("Unable to iterate through directory", e);
                }
            }
            FileType type = this.fsh.getType(root);
            if (!this.excludedSuffixes.contains(type.getTypename())) {
                if (type.isArchive()) {
                    this.logger.debug("Unpacking {} and type {} ", (Object)root, (Object)type.getTypename());
                    this.unpackArchive(root, type, processor);
                } else if (type.isCompressed()) {
                    this.logger.debug("Decompressing {}", (Object)root);
                    this.decompressFile(root, type, processor);
                } else {
                    this.logger.debug("Found standard file {} ", (Object)root);
                }
            }
            if (processor != null) {
                processor.processFile(this.directoryRoot, root);
            }
        }
    }

    private void decompressFile(File root, FileType type, ExploderFileProcessor processor) throws InternalException {
        try (CompressorInputStream c = (CompressorInputStream)type.getStream(root);){
            File destination = new File(type.getUncompressedFilename(root));
            IOUtils.copy((InputStream)c, (OutputStream)Files.newOutputStream(destination.toPath(), new OpenOption[0]));
            this.logger.debug("Now examining decompressed file {} ", (Object)destination);
            this.unpack(processor, destination);
        }
        catch (IOException | ArchiveException | CompressorException e) {
            throw new InternalException("Caught exception decompressing file", (Exception)e);
        }
    }

    private void unpackArchive(File root, FileType type, ExploderFileProcessor processor) throws InternalException {
        try (ArchiveInputStream i = (ArchiveInputStream)type.getStream(root);){
            File target = new File(root.getParentFile(), root.getName() + ARCHIVE_UNPACK_SUFFIX);
            target.mkdirs();
            this.extract(i, target);
            this.unpack(processor, target);
        }
        catch (IOException | ArchiveException | CompressorException e) {
            throw new InternalException("Caught exception unpacking archive", (Exception)e);
        }
    }

    private void extract(ArchiveInputStream input, File destination) throws IOException, InternalException {
        ArchiveEntry entry;
        while ((entry = input.getNextEntry()) != null) {
            if (!input.canReadEntryData(entry)) {
                throw new InternalException("Unable to read data entry for " + entry.toString());
            }
            File file = new File(destination, entry.getName());
            if (entry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            file.getParentFile().mkdirs();
            FileOutputStream output = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (output == null) continue;
                if (throwable != null) {
                    try {
                        output.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                output.close();
            }
        }
    }
}

