/*
 * Decompiled with CFR 0.152.
 */
package org.goots.exploder;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.compress.compressors.bzip2.BZip2Utils;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.compress.compressors.lzma.LZMAUtils;
import org.apache.commons.compress.compressors.xz.XZUtils;
import org.goots.exploder.types.ARFileType;
import org.goots.exploder.types.BZIP2FileType;
import org.goots.exploder.types.CpioFileType;
import org.goots.exploder.types.DumpFileType;
import org.goots.exploder.types.FileType;
import org.goots.exploder.types.GZIPFileType;
import org.goots.exploder.types.JavaFileType;
import org.goots.exploder.types.LZMAFileType;
import org.goots.exploder.types.SevenZFileType;
import org.goots.exploder.types.StandardFileType;
import org.goots.exploder.types.TarFileType;
import org.goots.exploder.types.XZFileType;
import org.goots.exploder.types.ZipFileType;

class FileHandler {
    private static final String WAR = "war";
    private static final String EAR = "ear";
    private static final String FILE = "file";
    private final HashMap<String, FileType> fileTypes = new HashMap();

    public FileHandler() {
        this.fileTypes.put("bzip2", new BZIP2FileType());
        this.fileTypes.put("lzma", new LZMAFileType());
        this.fileTypes.put("xz", new XZFileType());
        this.fileTypes.put("gz", new GZIPFileType());
        this.fileTypes.put("tar", new TarFileType());
        this.fileTypes.put("zip", new ZipFileType());
        this.fileTypes.put("jar", new JavaFileType());
        this.fileTypes.put(WAR, new JavaFileType());
        this.fileTypes.put(EAR, new JavaFileType());
        this.fileTypes.put(FILE, new StandardFileType());
        this.fileTypes.put("ar", new ARFileType());
        this.fileTypes.put("cpio", new CpioFileType());
        this.fileTypes.put("7z", new SevenZFileType());
        this.fileTypes.put("dump", new DumpFileType());
    }

    Set<String> getSupportedSuffixes() {
        return Collections.unmodifiableSet(this.fileTypes.keySet());
    }

    public FileType getType(File source) {
        if (GzipUtils.isCompressedFilename((String)source.getName())) {
            return this.fileTypes.get("gz");
        }
        if (LZMAUtils.isCompressedFilename((String)source.getName())) {
            return this.fileTypes.get("lzma");
        }
        if (XZUtils.isCompressedFilename((String)source.getName())) {
            return this.fileTypes.get("xz");
        }
        if (BZip2Utils.isCompressedFilename((String)source.getName())) {
            return this.fileTypes.get("bzip2");
        }
        if (source.getName().endsWith(".tar")) {
            return this.fileTypes.get("tar");
        }
        if (source.getName().endsWith(".zip")) {
            return this.fileTypes.get("tar");
        }
        if (source.getName().endsWith(".jar")) {
            return this.fileTypes.get("jar");
        }
        if (source.getName().endsWith(".war")) {
            return this.fileTypes.get(WAR);
        }
        if (source.getName().endsWith(".ear")) {
            return this.fileTypes.get(EAR);
        }
        if (source.getName().endsWith(".ar")) {
            return this.fileTypes.get("ar");
        }
        if (source.getName().endsWith(".cpio")) {
            return this.fileTypes.get("cpio");
        }
        if (source.getName().endsWith(".7z")) {
            return this.fileTypes.get("7z");
        }
        if (source.getName().endsWith(".dump")) {
            return this.fileTypes.get("dump");
        }
        return this.fileTypes.get(FILE);
    }
}

