/*
 * Decompiled with CFR 0.152.
 */
package org.goots.exploder;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.goots.exploder.ExploderFileProcessor;
import org.goots.exploder.FileHandler;
import org.goots.exploder.InternalException;
import org.goots.exploder.types.FileType;
import org.goots.jdownloader.JDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exploder {
    public static final String ARCHIVE_UNPACK_SUFFIX = "-unpacked-" + UUID.randomUUID().toString();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FileHandler fsh = new FileHandler();
    private final HashSet<String> excludedSuffixes = new HashSet();
    private File directoryRoot;
    private File targetDirectory;
    private boolean cleanup;
    private boolean recurse = true;

    public Exploder excludeSuffix(String suffix) throws InternalException {
        suffix = suffix.trim().toLowerCase();
        if (!this.fsh.getSupportedSuffixes().contains(suffix)) {
            throw new InternalException("Unknown suffix " + suffix);
        }
        this.excludedSuffixes.add(suffix);
        return this;
    }

    public Exploder disableRecursion() {
        this.recurse = false;
        return this;
    }

    public Exploder useTemporaryDirectory() throws InternalException {
        if (this.targetDirectory != null) {
            throw new InternalException("Working directory already configured");
        }
        try {
            Path temporaryLocation = Files.createTempDirectory("exploder-" + UUID.randomUUID().toString(), new FileAttribute[0]);
            this.cleanup = true;
            this.targetDirectory = temporaryLocation.toFile();
        }
        catch (IOException e) {
            throw new InternalException("Error setting up working directory", e);
        }
        return this;
    }

    public Exploder useTargetDirectory(File targetDirectory) throws InternalException {
        if (this.targetDirectory != null) {
            throw new InternalException("Target directory already configured");
        }
        this.targetDirectory = targetDirectory;
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        return this;
    }

    public Set<String> getSupportedSuffixes() {
        return this.fsh.getSupportedSuffixes();
    }

    public void unpack(String path) throws InternalException {
        if (path.startsWith("http:") || path.startsWith("https:") || path.startsWith("file:")) {
            try {
                this.unpack(null, new URL(path));
            }
            catch (MalformedURLException e) {
                throw new InternalException("Unable to translate path (" + path + ") into URL.");
            }
        } else {
            this.unpack(new File(path));
        }
    }

    public void unpack(ExploderFileProcessor processor, URL url) throws InternalException {
        try {
            if (this.targetDirectory == null) {
                this.useTemporaryDirectory();
            }
            File target = new File(Files.createTempDirectory("exploder-" + UUID.randomUUID().toString(), new FileAttribute[0]).toFile(), url.getFile().substring(url.getFile().lastIndexOf(47)));
            this.logger.debug("Downloading URL {} to {} unpacking to {}", new Object[]{url, target, this.targetDirectory});
            if (url.getProtocol().equals("file")) {
                Files.copy(new File(url.getPath()).toPath(), target.toPath(), new CopyOption[0]);
            } else {
                new JDownloader(url).target(target.getAbsolutePath()).execute();
            }
            this.directoryRoot = this.targetDirectory;
            this.internal_unpack(processor, target, this.targetDirectory);
        }
        catch (IOException | URISyntaxException | org.goots.jdownloader.utils.InternalException e) {
            throw new InternalException("Error downloading remote URL", (Exception)e);
        }
        finally {
            this.cleanup();
        }
    }

    public void unpack(File root) throws InternalException {
        this.unpack(null, root);
    }

    public void unpack(ExploderFileProcessor processor, File root) throws InternalException {
        try {
            if (this.targetDirectory == null) {
                this.targetDirectory = root.isDirectory() ? root : root.getParentFile();
            } else if (root.isDirectory()) {
                FileUtils.copyDirectory((File)root, (File)this.targetDirectory);
                root = this.targetDirectory;
            } else if (!root.isFile()) {
                throw new InternalException("Target (" + root + ") is not directory or file ( exists: " + root.exists() + ')');
            }
            this.logger.debug("Setting directory root to {} with target directory {}", (Object)root, (Object)this.targetDirectory.getAbsolutePath());
            this.directoryRoot = this.targetDirectory;
            this.internal_unpack(processor, root, this.targetDirectory);
        }
        catch (IOException e) {
            throw new InternalException("Error setting up targetDirectory directory", e);
        }
        finally {
            this.cleanup();
        }
    }

    private void internal_unpack(ExploderFileProcessor processor, File root, File targetDirectory) throws InternalException {
        block22: {
            if (root.isDirectory()) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(root.toPath());){
                    for (Path entry : stream) {
                        this.internal_unpack(processor, entry.toFile(), null);
                    }
                    break block22;
                }
                catch (IOException e) {
                    throw new InternalException("Unable to iterate through directory", e);
                }
            }
            FileType type = this.fsh.getType(root);
            if (!this.excludedSuffixes.contains(type.getTypename())) {
                if (type.isArchive()) {
                    this.logger.debug("Unpacking {} and type {}", (Object)root, (Object)type.getTypename());
                    this.unpackArchive(root, type, processor, targetDirectory);
                } else if (type.isCompressed()) {
                    this.logger.debug("Decompressing {}", (Object)root);
                    this.decompressFile(root, type, processor, targetDirectory);
                } else {
                    this.logger.debug("Found standard file {} ", (Object)root);
                }
            }
            if (processor != null) {
                processor.processFile(this.directoryRoot, root);
            }
        }
    }

    private void decompressFile(File root, FileType type, ExploderFileProcessor processor, File targetDirectory) throws InternalException {
        try (CompressorInputStream c = (CompressorInputStream)type.getStream(root);){
            File destination = targetDirectory != null ? new File(targetDirectory, type.getUncompressedFilename(new File(root.getName()))) : new File(type.getUncompressedFilename(root));
            IOUtils.copy((InputStream)c, (OutputStream)Files.newOutputStream(destination.toPath(), new OpenOption[0]));
            this.logger.debug("Now examining decompressed file {} ", (Object)destination);
            if (this.recurse) {
                this.internal_unpack(processor, destination, null);
            }
        }
        catch (IOException | ArchiveException | CompressorException e) {
            throw new InternalException("Caught exception decompressing file", (Exception)e);
        }
    }

    private void unpackArchive(File root, FileType type, ExploderFileProcessor processor, File targetDirectory) throws InternalException {
        try (ArchiveInputStream i = (ArchiveInputStream)type.getStream(root);){
            File target;
            if (targetDirectory == null) {
                target = new File(root.getParentFile(), root.getName() + ARCHIVE_UNPACK_SUFFIX);
                target.mkdirs();
            } else {
                target = targetDirectory;
            }
            this.extract(i, target);
            if (this.recurse) {
                this.internal_unpack(processor, target, null);
            }
        }
        catch (IOException | ArchiveException | CompressorException e) {
            throw new InternalException("Caught exception unpacking archive", (Exception)e);
        }
    }

    private void extract(ArchiveInputStream input, File destination) throws IOException, InternalException {
        ArchiveEntry entry;
        while ((entry = input.getNextEntry()) != null) {
            if (!input.canReadEntryData(entry)) {
                throw new InternalException("Unable to read data entry for " + entry.toString());
            }
            File file = new File(destination, entry.getName());
            if (entry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            file.getParentFile().mkdirs();
            FileOutputStream output = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (output == null) continue;
                if (throwable != null) {
                    try {
                        output.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                output.close();
            }
        }
    }

    private void cleanup() throws InternalException {
        if (this.cleanup) {
            try {
                this.logger.debug("Cleaning up temporary directory {} ", (Object)this.targetDirectory);
                FileUtils.deleteDirectory((File)this.targetDirectory);
            }
            catch (IOException e) {
                throw new InternalException("Error cleaning up working directory", e);
            }
        }
    }
}

