/*
 * Decompiled with CFR 0.152.
 */
package org.goots.exploder.types;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.goots.exploder.InternalException;
import org.goots.exploder.types.ArchiveFileType;

public class SevenZFileType
extends ArchiveFileType {
    @Override
    public String getUncompressedFilename(File source) {
        return source.getName();
    }

    @Override
    public String getTypename() {
        return "7z";
    }

    @Override
    public <T extends InputStream> T getStream(File source) throws InternalException {
        try {
            return (T)((Object)new SevenZInputStream(new SevenZFile(source)));
        }
        catch (IOException e) {
            throw new InternalException("Exception unarchiving SeverZFile", e);
        }
    }

    private static class SevenZInputStream
    extends ArchiveInputStream {
        private SevenZFile file;

        SevenZInputStream(SevenZFile file) {
            this.file = file;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.file.read(b, off, len);
        }

        public ArchiveEntry getNextEntry() throws IOException {
            return this.file.getNextEntry();
        }

        public void close() throws IOException {
            this.file.close();
        }
    }
}

