/*
 * Decompiled with CFR 0.152.
 */
package org.goots.maven.extensions.grabdependencypopulator;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.project.MavenProject;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.commonjava.maven.ext.common.util.ManifestUtils;
import org.goots.maven.extensions.grabdependencypopulator.GrabParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class GrabEventSpy
extends AbstractEventSpy {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String DISABLE_GRAB_EXTENSION = "grab.extension.disable";
    private final GrabParser grabParser;

    @Inject
    public GrabEventSpy(GrabParser lp) {
        this.grabParser = lp;
    }

    public void onEvent(Object event) {
        ExecutionEvent ee;
        ExecutionEvent.Type type;
        if (this.isEventSpyDisabled()) {
            return;
        }
        if (event instanceof ExecutionEvent && (type = (ee = (ExecutionEvent)event).getType()) == ExecutionEvent.Type.SessionStarted) {
            try {
                this.logger.info("Activating GrabDependencyPopulator extension {}", (Object)ManifestUtils.getManifestInformation());
                MavenProject p = ee.getProject();
                this.grabParser.setErrorOnMismatch(Boolean.parseBoolean(ee.getSession().getSystemProperties().getProperty("grabPopulatorErrorOnMismatch", "false")));
                this.grabParser.searchGroovyFiles(p.getBasedir());
                if (this.grabParser.getDependencies().size() > 0) {
                    this.logger.info("Adding to project the dependencies {} ", this.grabParser.getDependencies().values());
                    p.getModel().getDependencies().addAll(this.grabParser.getDependencies().values());
                }
                if (this.grabParser.getRepositories().size() > 0) {
                    this.logger.info("Adding to project the dependencies {} ", this.grabParser.getRepositories());
                    p.getModel().getRepositories().addAll(this.grabParser.getRepositories());
                }
            }
            catch (ManipulationUncheckedException e) {
                ee.getSession().getResult().addException(e.getCause());
            }
            catch (IOException | ManipulationException e) {
                ee.getSession().getResult().addException(e);
            }
        }
    }

    private boolean isEventSpyDisabled() {
        return "true".equalsIgnoreCase(System.getProperty("grab.extension.disable")) || "true".equalsIgnoreCase(System.getenv("grab.extension.disable"));
    }
}

