/*
 * Decompiled with CFR 0.152.
 */
package org.goots.maven.extensions.grabdependencypopulator;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.goots.maven.extensions.grabdependencypopulator.Configuration;
import org.goots.maven.extensions.grabdependencypopulator.GrabParser;
import org.goots.maven.extensions.grabdependencypopulator.ManifestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class GrabEventSpy
extends AbstractEventSpy {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Configuration config;
    private final GrabParser grabParser;

    @Inject
    public GrabEventSpy(GrabParser lp, Configuration c) {
        this.grabParser = lp;
        this.config = c;
        this.config.init(System.getProperties());
    }

    public void onEvent(Object event) {
        ExecutionEvent ee;
        ExecutionEvent.Type type;
        if (this.config.isDisabled()) {
            return;
        }
        if (event instanceof ExecutionEvent && (type = (ee = (ExecutionEvent)event).getType()) == ExecutionEvent.Type.SessionStarted) {
            this.config.init(ee.getSession().getSystemProperties(), ee.getSession().getUserProperties());
            try {
                this.logger.info("Activating GrabDependencyPopulator extension {}", (Object)ManifestUtils.getManifestInformation());
                MavenProject p = ee.getProject();
                this.grabParser.setErrorOnMismatch(this.config.isErrorOnMismatch());
                this.grabParser.searchGroovyFiles(p.getBasedir());
                if (this.grabParser.getDependencies().size() > 0) {
                    if (this.config.isVerifyDependencies()) {
                        if (p.getModel().getDependencyManagement() != null) {
                            this.verifyDeps(false, this.grabParser.getDependencies().values(), p.getModel().getDependencyManagement().getDependencies());
                        }
                        this.verifyDeps(true, this.grabParser.getDependencies().values(), p.getModel().getDependencies());
                    }
                    this.logger.info("Adding to project the dependencies {} ", this.grabParser.getDependencies().values());
                    p.getModel().getDependencies().addAll(this.config.isAtEnd() ? p.getModel().getDependencies().size() : 0, this.grabParser.getDependencies().values());
                }
                if (this.grabParser.getRepositories().size() > 0) {
                    this.logger.info("Adding to project the dependencies {} ", this.grabParser.getRepositories());
                    p.getModel().getRepositories().addAll(this.grabParser.getRepositories());
                }
            }
            catch (ManipulationUncheckedException e) {
                ee.getSession().getResult().addException(e.getCause());
            }
            catch (IOException e) {
                ee.getSession().getResult().addException((Throwable)new ManipulationException("Error searching groovy files", (Throwable)e, new Object[0]));
            }
        }
    }

    private void verifyDeps(boolean warnOnMatch, Collection<Dependency> grabbedDeps, List<Dependency> targetDeps) {
        grabbedDeps.forEach(d -> targetDeps.forEach(t -> {
            if (t.getGroupId().equals(d.getGroupId()) && t.getArtifactId().equals(d.getArtifactId())) {
                if (!d.getVersion().equals(t.getVersion())) {
                    this.logger.error("Mismatched version between Grab ({}) and native dependency ({})", d, t);
                    throw new ManipulationUncheckedException((Throwable)new ManipulationException("Mismatched version between Grab and native dependencies." + d + " and " + t, new String[0]));
                }
                if (warnOnMatch) {
                    this.logger.warn("Duplicate dependency definition between Grab ({}) and native dependency ({})", d, t);
                }
            }
        }));
    }
}

