/*
 * Copyright (C) 2020 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.goots.maven.extensions.grabdependencypopulator;

import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.commonjava.maven.ext.common.ManipulationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.inject.Named;
import javax.inject.Singleton;

@SuppressWarnings( "unused" )
@Named
@Singleton
public class GrabLifeCycleParticipant
    extends AbstractMavenLifecycleParticipant
{
    private final Logger logger = LoggerFactory.getLogger( getClass() );

    @Override
    public void afterSessionEnd( MavenSession session ) throws MavenExecutionException
    {
        super.afterSessionEnd( session );

        if ( session.getResult().getExceptions().size() > 0)
        {
            session.getResult().getExceptions().forEach( e -> {
                if ( e instanceof ManipulationException )
                {
                    logger.error( "Exception from extension: {}", e.getMessage());
                    // Underlying code uses CopyOnWriteArray so safe to remove.
                    session.getResult().getExceptions().remove( e );
                }
            } );
        }
    }
}
